/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.IdValueEventArgs;
import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.PointControl;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class SteadyDetector
extends PointControl {
    private Observable<IdValueEventArgs> steadyEvent = new Observable<IdValueEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSteadyDetector_RegisterSteady(SteadyDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSteadyDetector_UnregisterSteady(SteadyDetector.this.toNative(), l);
        }

        public void callback(int n, float f) {
            this.notify((Object)new IdValueEventArgs(n, f));
        }
    };
    private Observable<IdValueEventArgs> notSteadyEvent = new Observable<IdValueEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSteadyDetector_RegisterNotSteady(SteadyDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSteadyDetector_UnregisterNotSteady(SteadyDetector.this.toNative(), l);
        }

        public void callback(int n, float f) {
            this.notify((Object)new IdValueEventArgs(n, f));
        }
    };

    public SteadyDetector(int n, float f) throws GeneralException {
        super(NativeMethods.xnvSteadyDetector_Create(0, n, f, "Steady"));
    }

    public SteadyDetector() throws GeneralException {
        this(250, 0.01f);
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvSteadyDetector_Destroy(this.toNative());
    }

    public void reset() throws StatusException {
        int n = NativeMethods.xnvSteadyDetector_Reset(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public int getDetectionDuration() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSteadyDetector_GetDetectionDuration(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public float getMaxDeviationForSteady() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSteadyDetector_GetMaximumStdDevForSteady(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public float getMinDeviationForNotSteady() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSteadyDetector_GetMinimumStdDevForNotSteady(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setDetectionDuration(int n) throws StatusException {
        int n2 = NativeMethods.xnvSteadyDetector_SetDetectionDuration(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void setMaxDeviationForSteady(float f) throws StatusException {
        int n = NativeMethods.xnvSteadyDetector_SetMaximumStdDevForSteady(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public void setMinDeviationForNotSteady(float f) throws StatusException {
        int n = NativeMethods.xnvSteadyDetector_SetMinimumStdDevForNotSteady(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public IObservable<IdValueEventArgs> getSteadyEvent() {
        return this.steadyEvent;
    }

    public IObservable<IdValueEventArgs> getNotSteadyEvent() {
        return this.notSteadyEvent;
    }
}

