/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.HandEventArgs;
import com.primesense.NITE.HandIdEventArgs;
import com.primesense.NITE.HandPointContext;
import com.primesense.NITE.HandPointEventArgs;
import com.primesense.NITE.IdEventArgs;
import com.primesense.NITE.MessageListener;
import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.NullEventArgs;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class PointControl
extends MessageListener {
    private Observable<HandEventArgs> pointCreateEvent;
    private Observable<HandEventArgs> pointUpdateEvent;
    private Observable<IdEventArgs> pointDestroyEvent;
    private Observable<HandPointEventArgs> primaryPointCreateEvent;
    private Observable<HandEventArgs> primaryPointUpdateEvent;
    private Observable<HandIdEventArgs> primaryPointReplaceEvent;
    private Observable<IdEventArgs> primaryPointDestroyEvent;
    private Observable<NullEventArgs> noPointsEvent;
    private boolean localCreation;

    public PointControl(long l) throws GeneralException {
        super(l);
        this.localCreation = false;
        this.init();
    }

    public PointControl() throws GeneralException {
        this("PointControl");
    }

    public PointControl(String string) throws GeneralException {
        super(NativeMethods.xnvPointControl_Create(string));
        this.localCreation = true;
        this.init();
    }

    private void init() {
        this.pointCreateEvent = new Observable<HandEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterPointCreate(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterPointCreate(PointControl.this.toNative(), l);
            }

            public void callback(HandPointContext handPointContext) {
                this.notify((Object)new HandEventArgs(handPointContext));
            }
        };
        this.pointUpdateEvent = new Observable<HandEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterPointUpdate(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterPointUpdate(PointControl.this.toNative(), l);
            }

            public void callback(HandPointContext handPointContext) {
                this.notify((Object)new HandEventArgs(handPointContext));
            }
        };
        this.pointDestroyEvent = new Observable<IdEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterPointDestroy(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterPointDestroy(PointControl.this.toNative(), l);
            }

            public void callback(int n) {
                this.notify((Object)new IdEventArgs(n));
            }
        };
        this.primaryPointCreateEvent = new Observable<HandPointEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterPrimaryPointCreate(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterPrimaryPointCreate(PointControl.this.toNative(), l);
            }

            public void callback(HandPointContext handPointContext, Point3D point3D) {
                this.notify((Object)new HandPointEventArgs(handPointContext, point3D));
            }
        };
        this.primaryPointUpdateEvent = new Observable<HandEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterPrimaryPointUpdate(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterPrimaryPointUpdate(PointControl.this.toNative(), l);
            }

            public void callback(HandPointContext handPointContext) {
                this.notify((Object)new HandEventArgs(handPointContext));
            }
        };
        this.primaryPointReplaceEvent = new Observable<HandIdEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterPrimaryPointReplace(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterPrimaryPointReplace(PointControl.this.toNative(), l);
            }

            public void callback(HandPointContext handPointContext, int n) {
                this.notify((Object)new HandIdEventArgs(handPointContext, n));
            }
        };
        this.primaryPointDestroyEvent = new Observable<IdEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterPrimaryPointDestroy(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterPrimaryPointDestroy(PointControl.this.toNative(), l);
            }

            public void callback(int n) {
                this.notify((Object)new IdEventArgs(n));
            }
        };
        this.noPointsEvent = new Observable<NullEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointControl_RegisterNoPoints(PointControl.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointControl_UnregisterNoPoints(PointControl.this.toNative(), l);
            }

            public void callback() {
                this.notify((Object)new NullEventArgs());
            }
        };
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        if (this.localCreation) {
            NativeMethods.xnvPointControl_Destroy(this.toNative());
        }
    }

    public int getPrimaryID() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPointControl_GetPrimaryID(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public IObservable<HandEventArgs> getPointCreateEvent() {
        return this.pointCreateEvent;
    }

    public IObservable<HandEventArgs> getPointUpdateEvent() {
        return this.pointUpdateEvent;
    }

    public IObservable<IdEventArgs> getPointDestroyEvent() {
        return this.pointDestroyEvent;
    }

    public IObservable<HandPointEventArgs> getPrimaryPointCreateEvent() {
        return this.primaryPointCreateEvent;
    }

    public IObservable<HandEventArgs> getPrimaryPointUpdateEvent() {
        return this.primaryPointUpdateEvent;
    }

    public IObservable<HandIdEventArgs> getPrimaryPointReplaceEvent() {
        return this.primaryPointReplaceEvent;
    }

    public IObservable<IdEventArgs> getPrimaryPointDestroyEvent() {
        return this.primaryPointDestroyEvent;
    }

    public IObservable<NullEventArgs> getNoPointsEvent() {
        return this.noPointsEvent;
    }
}

