/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.Circle;
import com.primesense.NITE.CircleEventArgs;
import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.NoCircleEventArgs;
import com.primesense.NITE.NoCircleReason;
import com.primesense.NITE.PointControl;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class CircleDetector
extends PointControl {
    private Observable<CircleEventArgs> circleEvent = new Observable<CircleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvCircleDetector_RegisterToCircle(CircleDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvCircleDetector_UnregisterFromCircle(CircleDetector.this.toNative(), l);
        }

        public void callback(float f, boolean bl, Point3D point3D, float f2) {
            this.notify((Object)new CircleEventArgs(f, bl, new Circle(point3D, f2)));
        }
    };
    private Observable<NoCircleEventArgs> noCircleEvent = new Observable<NoCircleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvCircleDetector_RegisterToNoCircle(CircleDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvCircleDetector_UnregisterFromNoCircle(CircleDetector.this.toNative(), l);
        }

        public void callback(float f, int n) {
            this.notify((Object)new NoCircleEventArgs(f, NoCircleReason.fromNative(n)));
        }
    };

    public CircleDetector(String string) throws GeneralException {
        super(NativeMethods.xnvCircleDetector_Create(string));
    }

    public CircleDetector() throws GeneralException {
        this("");
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvCircleDetector_Destroy(this.toNative());
    }

    public void reset() throws StatusException {
        int n = NativeMethods.xnvCircleDetector_Reset(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void setMinimumPoints(int n) throws StatusException {
        int n2 = NativeMethods.xnvCircleDetector_SetMinimumPoints(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getMinimumPoints() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvCircleDetector_GetMinimumPoints(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public void setCloseToExistingRatio(float f) throws StatusException {
        int n = NativeMethods.xnvCircleDetector_SetCloseToExistingRatio(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getCloseToExistingRatio() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvCircleDetector_GetCloseToExistingRatio(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setCloseEnough(float f) throws StatusException {
        int n = NativeMethods.xnvCircleDetector_SetCloseEnough(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getCloseEnough() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvCircleDetector_GetCloseEnough(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setMinRadius(float f) throws StatusException {
        int n = NativeMethods.xnvCircleDetector_SetMinRadius(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getMinRadius() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvCircleDetector_GetMinRadius(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setMaxRadius(float f) throws StatusException {
        int n = NativeMethods.xnvCircleDetector_SetMaxRadius(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getMaxRadius() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvCircleDetector_GetMaxRadius(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setExistingWeight(float f) throws StatusException {
        int n = NativeMethods.xnvCircleDetector_SetExistingWeight(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getExistingWeight() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvCircleDetector_GetExistingWeight(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setMaxErrors(int n) throws StatusException {
        int n2 = NativeMethods.xnvCircleDetector_SetMaxErrors(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getMaxErrors() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvCircleDetector_GetMaxErrors(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public IObservable<CircleEventArgs> getCircleEvent() {
        return this.circleEvent;
    }

    public IObservable<NoCircleEventArgs> getNoCircleEvent() {
        return this.noCircleEvent;
    }
}

