//
//  Copyright (c)2004 GE Medical Systems
//
//  Helper comment to enable syntax coloring in InterDev: <script>

var strViewerLiteObject = 
	'<object id = "activexviewerlite"' +
	'	name		= "%VIEWPORTID%"' +
	'	series		= "%SERIESID%"' +
	'	type		= "application/x-oleobject"' +
	'	classid		= "clsid:C51B9D7B-E720-4398-AA62-6DC347D385E6"' +
	'	codebase	= "dcmview.cab#version=' + strVersion + '"' +
	'	class		= "classNoFocus">' +
	'</object>';

var strViewerLiteInExe = 
	'<span style="height:100%; width:100%" id = "activexviewerlite"' +
	'	name		= "%VIEWPORTID%"' +
	'	series		= "%SERIESID%"' +
	'	class		= "classNoFocus"' +
	'	onresize	= "external.UpdatePosition(this);">' +
	'</span>';


//
// Viewport C'tor
//
function Viewport(_nViewportId, _nSeriesId)
{
	this._strImageUID			= '';
	this._strSeriesUID			= '';
	this._nFrameIndex			= 0;
	this._viewframe				= parent;
	this._dicomdirframe			= null;
	this._strViewportId			= _nViewportId.toString();
	this._strSeriesId			= _nSeriesId.toString();
	this._activexviewerElement	= null;
	this._activexviewer			= null;
	this._strInitWL				= '';
	this._strDataPath			= '';
	this._strDataPathFusion		= '';
	this._presstateidx			= 0;	// no presentation state applied
}


var f_reViewport = /%VIEWPORTID%/g;
var f_reSeries = /%SERIESID%/g;

//
// GetObjectElementString
//
function Viewport.prototype.GetObjectElementString()
{ with(this) {
	var strElement = GetApp().IsInViewerExe() ? strViewerLiteInExe : strViewerLiteObject;

	strElement = strElement.replace(f_reViewport, _strViewportId);
	return strElement.replace(f_reSeries, _strSeriesId);
}}


//
// Init
//
function Viewport.prototype.Init(activexviewer)
{ with(this) {
	_activexviewerElement = activexviewer;

	if (GetApp().IsInViewerExe() || _activexviewerElement.readyState == 4)
	{
		InitImpl();
	}
	else
	{
		_activexviewerElement.onreadystatechange = CreateStaticFunction(this, 'InitImpl');
	}
}}

//
// InitImpl
//
function Viewport.prototype.InitImpl()
{ with(this) {

	if (GetApp().IsInViewerExe())
	{
		_activexviewer = external.CreateObjectInPlace('{C51B9D7B-E720-4398-AA62-6DC347D385E6}', _activexviewerElement);
	}
	else
	{
		if (_activexviewerElement.readyState != 4 || typeof(_activexviewerElement) != 'object')
			return;

		_activexviewer = _activexviewerElement;
	}

	Unlock(GetApp().GetLicenseKey());

	_activexviewerElement.onreadystatechange = null;

	_activexviewer.AttachEvent('OnSetFocus',				_viewframe.OnSetFocus);
	_activexviewer.AttachEvent('OnMouseWheel',				_viewframe.OnMouseWheelViewControl);
	_activexviewer.AttachEvent('OnResetImageSettings',		_viewframe.OnResetImageSettings);
	_activexviewer.AttachEvent('OnChangeImageAnnotations',	_viewframe.OnChangeImageAnnotations);
	
	if (HasErrors())
		return;

	try
	{
		var config = GetApp().GetConfig();
		_activexviewer.strApplicationDataURL = GetApp().GetApplicationDataUrl(location);
		_activexviewer.SetConfig(config.GetConfigNode());
		_activexviewer.SetLocaleDbAndId(GetApp().GetLocaleDB().GetXMLDb(), config.LocaleId())
		SetFusionColorPalette(config.GetDefaultColorMapFile());
	}
	catch (e)
	{
	}
}}


//
// Dispose
//
function Viewport.prototype.Dispose()
{ with(this) {
	Unload();

	_activexviewer = null;

	if (GetApp().IsInViewerExe())
	{
		external.DisposeObject(_activexviewerElement);
	}
}}

//
// Unload
//
function Viewport.prototype.Unload()
{ with(this) {
	_strImageUID	= '';
	_strSeriesUID	= '';
}}



//
// Unlock
//
function Viewport.prototype.Unlock(licensekey)
{ with(this) {
	if (licensekey == null)
		return;

	licensekey.Unlock(_activexviewer);
}}


//
// GetFusionColorPalette
//
function Viewport.prototype.GetFusionColorPalette()
{ with(this) {
	return _strColorPalette;
}}


//
// SetFusionColorPalette
//
function Viewport.prototype.SetFusionColorPalette(strColorPalette)
{ with(this) {
	var strColorTableFile				= GetApp().GetApplicationDataUrl(location) + "/" + strColorPalette;
	_activexviewer.strFusionColorTable	= strColorTableFile.replace('file:///', '');
	this._strColorPalette				= strColorPalette;
}}


//
// HasErrors
//
function Viewport.prototype.HasErrors()
{ with (this) {
	return _activexviewer == null;
}}


//
// GetErrorText
//
function Viewport.prototype.GetErrorText()
{ with (this) {
	return GetApp().GetLocaleString('msgCannotLoadAmiViewerLite');
}}


//
// ApplyPresentationState
//
function Viewport.prototype.ApplyPresentationState()
{ with(this) {

	_presstateidx	= _viewframe.GetPresentationStateIndex();
	var strFilename = _presstateidx > 0 ? _dicomdirframe.GetPresentationStateFilename(_presstateidx - 1, _strImageUID) : "";
	
	SetPresentationState(strFilename);	
	
	_strInitWL = GetWindowLevel();	
}}


//
// ApplyImageAttributes
//
function Viewport.prototype.ApplyImageAttributes(attributes)
{ with(this) {
	if (attributes == null)
		return;

	SetAttributes(attributes);
}}


//
// ApplyImageAnnotations
//
function Viewport.prototype.ApplyImageAnnotations()
{ with(this) {

	var strAnnot = _viewframe.GetImageAnnotations(_strSeriesUID, _strImageUID, _nFrameIndex);
	if (strAnnot != null && strAnnot != "")
	{
		_activexviewer.SetImageAnnotations(_nFrameIndex, strAnnot);
	}
}}


//
// SetDataPath
//
function Viewport.prototype.SetDataPath(strDataPath, strDataPathFusion)
{ with(this) {
	_nFrameIndex		= 0;
	_strDataPath		= strDataPath;
	_strDataPathFusion	= strDataPathFusion;
	_activexviewer.SetDataPath(_strDataPath, _strDataPathFusion); 
}}


//
// ApplyFusionWindowLevels
//
function Viewport.prototype.ApplyFusionWindowLevels()
{ with(this) {
	var series		= GetActiveSeries();
	var viewportPT	= series != null ? series.GetViewport(SERIESTYPE_PT) : null;
	var viewportCT	= series != null ? series.GetViewport(SERIESTYPE_CT) : null;
	
	SetWindowLevel      (viewportCT != null ? viewportCT.GetWindowLevel() : '');
	SetFusionWindowLevel(viewportPT != null ? viewportPT.GetWindowLevel() : '');
}}


//
// UpdateViewport
//
function Viewport.prototype.UpdateViewport(dicomdirframe, bIsPetCtMode)
{ with(this) {
	_dicomdirframe		= dicomdirframe;
	var nViewportIndex	= GetViewportIndex();
	
    if (nViewportIndex == SERIESTYPE_FUSED && bIsPetCtMode)
    {
		var strCTPath	= _dicomdirframe.GetImagePath(SERIESTYPE_CT);
		var strPETPath	= _dicomdirframe.GetImagePath(SERIESTYPE_PT);
		
		if (strCTPath == "" || strPETPath == "")
		{ 
			_strSeriesUID = '';
			SetDataPath("", "");
			return;
		}
		
		if (strCTPath != _strDataPath || strPETPath != _strDataPathFusion)
		{
			_strSeriesUID	= _dicomdirframe.GetSeriesInstanceUID(SERIESTYPE_CT) + '_';
			_strSeriesUID	+= _dicomdirframe.GetSeriesInstanceUID(SERIESTYPE_PT);
		
			SetDataPath(strCTPath, strPETPath);
			
			OnShowAnnotationsChange(bIsPetCtMode);

			var attributes = _viewframe.GetSeriesAttributes(_strSeriesUID);
			if (attributes == null)
			{
				OnResetImageSettings(bIsPetCtMode);
			}
			else
			{
				ApplyFusionWindowLevels();
				ApplyImageAttributes(attributes);
			}
		}
    }
    else
    {
		var strDataPath = _dicomdirframe.GetImagePath(nViewportIndex);
		if (_strDataPath != strDataPath)
		{
			Unload();

			_strImageUID	= _dicomdirframe.GetImageInstanceUID(nViewportIndex);
			_strSeriesUID	= _dicomdirframe.GetSeriesInstanceUID(nViewportIndex);

			SetDataPath(strDataPath, "");
			
			ApplyPresentationState();
			
			OnShowAnnotationsChange(bIsPetCtMode);

			var attributes = _viewframe.GetSeriesAttributes(_strSeriesUID);
			if (attributes == null)
			{
				OnResetImageSettings(bIsPetCtMode);
			}
			else
			{
				ApplyImageAttributes(attributes);
			}
			
			ApplyImageAnnotations();
		}
	}
}}


//
//	OnResetImageSettings
//
function Viewport.prototype.OnResetImageSettings(bIsPetCtMode)
{ with(this) {

	var nViewportIndex	= GetViewportIndex();

	if (bIsPetCtMode && nViewportIndex == SERIESTYPE_FUSED)
	{
		ApplyFusionWindowLevels();
		SetFusionBlendFactor(0.5);
		return;
	}

	if (IsPetImage())
	{	
		var strWindowLevel = _dicomdirframe.GetPETWindowLevel(bIsPetCtMode ? nViewportIndex : _dicomdirframe.GetActiveSeriesIndex());
		if (strWindowLevel != '')
		{
			SetWindowLevel(strWindowLevel);		
		}
	
		SetWindowInvert(true);
	}
}}


//
// SelectFrame
//
function Viewport.prototype.SelectFrame(nFrameIndexNew)
{ with(this) {

	_nFrameIndex = nFrameIndexNew;
	if (_nFrameIndex < 0)
	{
		_nFrameIndex = GetFrameCount() - 1;
	}
	else if (_nFrameIndex >= GetFrameCount())
	{
		_nFrameIndex = 0;
	}
	
	_activexviewer.SetFrame(_nFrameIndex);

	ApplyPresentationState();
	ApplyImageAttributes(_viewframe.GetSeriesAttributes(_strSeriesUID));
	ApplyImageAnnotations();
}}


//
// GetFrameCount
//
function Viewport.prototype.GetFrameCount()
{ with(this) {
	return _activexviewer.FrameCount;
}}


//
// SelectPreviousFrame
//
function Viewport.prototype.SelectPreviousFrame()
{ with(this) {
	SelectFrame(_nFrameIndex - 1);
}}


//
// SelectNextImage
//
function Viewport.prototype.SelectNextFrame()
{ with(this) {
	SelectFrame(_nFrameIndex + 1);
}}


//
// OnFocusViewControl
//
function Viewport.prototype.OnFocusViewControl()
{ with(this) {
	SetActiveViewport(parseInt(_activexviewerElement.name), parseInt(_activexviewerElement.series));
}}


//
// OnShowAnnotationsChange
//
function Viewport.prototype.OnShowAnnotationsChange(bIsPetCtMode)
{ with(this) {

	var nNone	= 0;
	var nBasic	= 1;
	var nFull	= 2;	

	if (bIsPetCtMode && GetViewportIndex() == SERIESTYPE_FUSED)
	{
		// fusion viewport should never show viewport annotations
		_activexviewer.AnnotationLevel = nBasic;
		return;
	}

	if (_viewframe.GetShowAnnotations())
	{
		_activexviewer.AnnotationLevel = nFull;
	}
	else
	{
		_activexviewer.AnnotationLevel = nBasic;
	}
}}


//
// OnPresentationStateChange
//
function Viewport.prototype.OnPresentationStateChange(value)
{ with(this) {
	ApplyPresentationState();
}}


//
// GetAttributes
//
function Viewport.prototype.GetAttributes()
{ with(this) {
	return _activexviewer.GetImageAttributes();
}}


//
// SetAttributes
//
function Viewport.prototype.SetAttributes(attributes)
{ with(this) {
	_activexviewer.SetImageAttributes(attributes);
}}


//
// GetPresentationStateCount
//
function Viewport.prototype.GetPresentationStateCount()
{ with(this) {
	return _activexviewer.PresentationStateCount;
}}


//
// SetPresentationState
//
function Viewport.prototype.SetPresentationState(strFilename)
{ with(this) {
	_activexviewer.strPresentationStatePath = strFilename;
}}


//
// GetViewportIndex
//
function Viewport.prototype.GetViewportIndex()
{ with(this) {
	return parseInt(_strViewportId);
}}


//
// MakeActive
//
function Viewport.prototype.MakeActive()
{ with(this) {
	_activexviewerElement.parentElement.className = "classFocus";
}}


//
// MakeInactive
//
function Viewport.prototype.MakeInactive()
{ with(this) {
	_activexviewerElement.parentElement.className = "classNoFocus";
}}


//
// GetWindowLevel
//
function Viewport.prototype.GetWindowLevel()
{ with(this) {
	return _activexviewer.GetViewportProperty('windowlevel');
}}


//
// SetWindowLevel
//
function Viewport.prototype.SetWindowLevel(strValue)
{ with(this) {
	_activexviewer.SetViewportProperty('windowlevel', strValue);
}}


//
// SetFusionWindowLevel
//
function Viewport.prototype.SetFusionWindowLevel(strValue)
{ with(this) {
	_activexviewer.strFusionWindowLevel = strValue;
}}


//
// SetFusionBlendFactor
//
function Viewport.prototype.SetFusionBlendFactor(dblValue)
{ with(this) {
	_activexviewer.dblFusionBlendFactor	= dblValue;
}}


//
// GetInitialWindowLevel
//
function Viewport.prototype.GetInitialWindowLevel()
{ with(this) {
	return _strInitWL;
}}


//
// SetWindowInvert
//
function Viewport.prototype.SetWindowInvert(bValue)
{ with(this) {
	_activexviewer.SetViewportProperty('windowinvert', bValue ? '1' : '0');
}}


//
// IsPetImage
//
function Viewport.prototype.IsPetImage()
{ with(this) {
	return _activexviewer.GetViewportProperty('ispetimage') != '0';
}}


//
// IsStaticPaletteMonitor
//
function Viewport.prototype.IsStaticPaletteMonitor()
{ with(this) {
	return _activexviewer.IsStaticPaletteMonitor();
}}


//
// GetPresentationStateIndex
//
function Viewport.prototype.GetPresentationStateIndex()
{ with(this) {
	return _presstateidx;
}}


//
// GetImageUID
//
function Viewport.prototype.GetImageUID()
{ with(this) {
	return _strImageUID;
}}


//
// GetSeriesUID
//
function Viewport.prototype.GetSeriesUID()
{ with(this) {
	return _strSeriesUID;
}}


//
// GetFrameIndex
//
function Viewport.prototype.GetFrameIndex()
{ with(this) {
	return _nFrameIndex;
}}

//
//	Match()
//
function Viewport.prototype.Match(oViewport)
{ with(this) {
	return GetApp().IsInViewerExe() ? 
		oViewport == _activexviewer :
		oViewport == _activexviewer.object;
}}
