//
//	Copyright (c)2004 GE Medical Systems
//

var _dicomdirframe = null;
var _oPrintCtl = null;
var _reDate = /^\d{8}$/;
var _reTime = /^\d{6}$/;


//
//	ctor
//
function CReportSR(index)
{
// private:
	this._index	= index;
}


//
//	GetLabel()
//
function CReportSR.prototype.GetLabel()
{ with (this) {
	return _activexDicomTreeView.GetStructuredReportLabel(_index);
}}


//
//	GetDcmInfo()
//
function CReportSR.prototype.GetDcmInfo()
{ with (this) {
	return _activexDicomTreeView.GetStructuredReportXML(_index);
}}


//
//	GetHtml()
//
function CReportSR.prototype.GetHtml()
{ with (this) {
	xmldoc		= GetDcmInfo();

	// transform XML -> XML
	var xmlnode = TransformXMLDocumentToNode(xmldoc, 'dcm2sr.xsl');
	
	if (xmlnode == null)
		return "";
		
	var xmlInput = CreateXmlDoc4();

	var xmlrootnode = xmlInput.createElement('dicom:report');
	xmlrootnode.appendChild(xmlnode.documentElement);
	xmlInput.appendChild(xmlrootnode);

	// transform XML -> HTML
	return TransformXMLDocument(xmlInput, 'sr2html.xsl');
}}

///////////////////////////////////////////////////////////////////////////////

//
//	ctor
//
function CReportDMS(strLabel, strUrl)
{
// private:
	this._strLabel	= strLabel;
	this._strUrl	= strUrl;
}


//
//	GetLabel()
//
function CReportDMS.prototype.GetLabel()
{ with (this) {
	return _strLabel;
}}


//
//	GetDcmInfo()
//
function CReportDMS.prototype.GetDcmInfo()
{ with (this) {
	return null;
}}


//
//	GetHtml()
//
function CReportDMS.prototype.GetHtml()
{ with (this) {
	return '<iframe style="width=100%; height=100%" src="' + _strUrl + '"></iframe>';
}}


//
// CReport c'tor
//
function CReport(strHeader, strBody)
{
	this._strHeader = strHeader;
	this._strBody = strBody;
}




//
// onload
//
function window.onload()
{
	_oPrintCtl = new CtlPrint(btnPrintReport);

	btnPrintReport.onclick = CreateStaticFunction(_oPrintCtl, 'Invoke');
}


//
// InitializeReportListbox
//
function InitializeReportListbox(dicomdirframe)
{
	var creport = dicomdirframe.GetReportCount();
	
	for (var ireport = 0; ireport < creport; ireport++)
	{
		var elem		= document.createElement('option');
		elem.text		= dicomdirframe.GetReportLabel(ireport);
		elem.value		= ireport;

		selectReport.options.add(elem);
	}
	
	selectReport.selectedIndex	= creport - 1;
	selectReport.onchange		= OnSelectedReportChanged;
	selectReport.disabled		= creport <= 1;
}


//
// ClearReportListbox
//
function ClearReportListbox()
{
	var creport = selectReport.options.length;
	for (var ireport = 0; ireport < creport; ireport++)
	{
		selectReport.options.remove(0);
	}
}


//
// OnSelectedReportChanged
//
function OnSelectedReportChanged()
{
	ShowReport(_dicomdirframe);
}


//
// TransformXMLDocument
//
function TransformXMLDocument(xmldoc, strXsl)
{
	try
	{
		var xsldoc = CreateXmlDoc4(strXsl);	
		return xmldoc.transformNode(xsldoc);
	}
	catch(e)
	{
		alert('Error transforming XML: ' + e.description);
		return '';
	}
}


//
// TransformXMLDocumentToNode
//
function TransformXMLDocumentToNode(xmldoc, strXsl)
{
	try
	{
		var xsldoc = CreateXmlDoc4(strXsl);	
		var xmlOutput = CreateXmlDoc4();	

		xmldoc.transformNodeToObject(xsldoc, xmlOutput);
		return xmlOutput;
	}
	catch(e)
	{
		alert('Error transforming XML: ' + e.description);
		return null;
	}
}

//
// GetTagContents
//
function GetTagContents(xmldoc, strDicomTag)
{
	var strXPath = '/dicom:set/dicom:el[@tag="' + strDicomTag + '"]';
	var xmlnode = xmldoc.selectSingleNode(strXPath);
	return xmlnode ? xmlnode.text : '';
}


//
// FormatDicomDate
//
function FormatDicomDate(strDate)
{
	if (strDate != null && _reDate.test(strDate.substr(0,8)))
	{
		return strDate.substr(0, 4) + '/' + strDate.substr(4, 2) + '/' + strDate.substr(6, 2);
	}
	return strDate;
}


//
// FormatDicomTime
//
function FormatDicomTime(strTime)
{
	if (strTime != null && _reTime.test(strTime.substr(0,6)))
	{
		return strTime.substr(0, 2) + ':' + strTime.substr(2, 2) + ':' + strTime.substr(4, 2);
	}
	return strTime;
}


//
//	GetPatientName()
//
function GetPatientName(xmldoc)
{
	var strPatName	= GetTagContents(xmldoc, "00100010");
	strPatName		= strPatName.replace(/[\^]+$/g, '');	// remove trailing ^
	strPatName		= strPatName.replace(/[\^]/g, ', ');	// replace ^ with ,
	return strPatName;
}

//
// SetReportHeader
//
function SetReportHeader(xmldoc)
{
	spanPatName.innerText		= xmldoc != null ? GetPatientName(xmldoc) : "";
	spanStudyDescr.innerText	= xmldoc != null ? GetTagContents(xmldoc, "00081030") : "";
	spanStudyDate.innerText		= xmldoc != null ? FormatDicomDate(GetTagContents(xmldoc, "00080020")) : "";
	spanStudyTime.innerText		= xmldoc != null ? FormatDicomTime(GetTagContents(xmldoc, "00080030")) : "";
}


//
// SetPrintHeader
//
function SetPrintHeader(xmldoc)
{
	idPatName.innerText			= xmldoc != null ? GetPatientName(xmldoc) : "";
	idPatId.innerText			= xmldoc != null ? GetTagContents(xmldoc, "00100020") : "";
	idStudyDescr.innerText		= xmldoc != null ? GetTagContents(xmldoc, "00081030") : "";
	idStudyDateTime.innerText	= xmldoc != null ? FormatDicomDate(GetTagContents(xmldoc, "00080020")) + " " + FormatDicomTime(GetTagContents(xmldoc, "00080030")) : "";
	idAccNo.innerText			= xmldoc != null ? GetTagContents(xmldoc, "00080050") : "";
}


//
// ShowReport
//
function ShowReport(dicomdirframe)
{
	_dicomdirframe = dicomdirframe;
	if (selectReport.options.length == 0)
	{
		InitializeReportListbox(dicomdirframe);
	}
	try
	{
		var iCurSel = selectReport.options[selectReport.selectedIndex].value;
	
		var xmldoc = dicomdirframe.GetReportDcmInfo(iCurSel);
		SetReportHeader(xmldoc);
		SetPrintHeader(xmldoc);
		
		divReportContent.innerHTML = dicomdirframe.GetReportHtml(iCurSel);
		
		_oPrintCtl.OnNotifyReport(xmldoc != null ?	new CReport(divPrintHeader.innerHTML, divReportContent.innerHTML) :
													null);
	}
	catch(e)
	{
		alert('Error loading structured report: ' + e.description);
	}
}
