<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:dicom="x-schema:DicomSchema.xml"
	xmlns="http://www.applicare.com/sr.xsd">

	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

	<xsl:template match="/">
		<xsl:element name="Document">
			<xsl:apply-templates select="dicom:set" mode="ROOT"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ContextCode">
		<xsl:element name="ContextCode">
			<xsl:apply-templates select="*|@*"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A043']">
		<xsl:element name="ConceptNameCodeSequence">
			<xsl:apply-templates select="dicom:set" mode="ContextCode"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A168']">
		<xsl:element name="ConceptCodeSequence">
			<xsl:apply-templates select="dicom:set" mode="ContextCode"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='00321064']">
		<xsl:element name="RequestedProcedureCodeSequence">
			<xsl:apply-templates select="dicom:set" mode="ContextCode"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ReferencedRequest">
		<xsl:element name="ReferencedRequest">
			<xsl:apply-templates select="dicom:el[@tag='0020000D']"/>
			<xsl:element name="AccessionNumber"><xsl:value-of select="dicom:el[@tag='00080050']"/></xsl:element>
			<xsl:apply-templates select="dicom:seq[@tag='00081110']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00321064']"/>
			<xsl:element name="PlacerOrderNumberImagingServiceRequest"><xsl:value-of select="dicom:el[@tag='00402016']"/></xsl:element>
			<xsl:element name="FillerOrderNumberImagingServiceRequest"><xsl:value-of select="dicom:el[@tag='00402017']"/></xsl:element>
			<xsl:element name="RequestedProcedureID"><xsl:value-of select="dicom:el[@tag='00401001']"/></xsl:element>
			<xsl:element name="RequestedProcedureDescription"><xsl:value-of select="dicom:el[@tag='00321060']"/></xsl:element>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A370']">
		<xsl:element name="ReferencedRequestSequence">
			<xsl:apply-templates select="dicom:set" mode="ReferencedRequest"/> 		
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ContentTemplate">
		<xsl:element name="ContentTemplate">
			<xsl:apply-templates select="*|@*"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A504']">
		<xsl:element name="ContentTemplateSequence">
			<xsl:apply-templates select="dicom:set" mode="ContentTemplate"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A088']">
		<xsl:element name="VerifyingObserverIdentificationCodeSequence">
			<xsl:apply-templates select="dicom:set" mode="ContextCode"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="VerifyingObserver">
		<xsl:element name="VerifyingObserver">
			<xsl:element name="VerifyingObserverName"><xsl:value-of select="dicom:el[@tag='0040A075']"/></xsl:element>
			<xsl:apply-templates select="dicom:seq[@tag='0040A088']"/> 		
			<xsl:element name="VerifyingOrganization"><xsl:value-of select="dicom:el[@tag='0040A027']"/></xsl:element>
			<xsl:element name="VerificationDateTime"><xsl:value-of select="dicom:el[@tag='0040A030']"/></xsl:element>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A073']">
		<xsl:element name="VerifyingObserverSequence">
			<xsl:apply-templates select="dicom:set" mode="VerifyingObserver"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ReferencedSeries">
		<xsl:element name="ReferencedSeries">
			<xsl:apply-templates select="dicom:el[@tag='0020000E']"/>
			<xsl:apply-templates select="dicom:el[@tag='00080054']"/>
			<xsl:apply-templates select="dicom:el[@tag='00880130']"/>
			<xsl:apply-templates select="dicom:el[@tag='00880140']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081199']" mode="ReferencedSOPSeq"/> 		
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='00081115']">
		<xsl:element name="ReferencedSeriesSequence">
			<xsl:apply-templates select="dicom:set" mode="ReferencedSeries"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="PredecessorDocument">
		<xsl:element name="PredecessorDocument">
			<xsl:apply-templates select="dicom:el[@tag='0020000D']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081115']"/> 		
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A360']">
		<xsl:element name="PredecessorDocumentsSequence">
			<xsl:apply-templates select="dicom:set" mode="PredecessorDocument"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="IdenticalDocument">
		<xsl:element name="IdenticalDocument">
			<xsl:apply-templates select="dicom:el[@tag='0020000D']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081115']"/> 		
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A525']">
		<xsl:element name="IdenticalDocumentsSequence">
			<xsl:apply-templates select="dicom:set" mode="IdenticalDocument"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A372']">
		<xsl:element name="PerformedProcedureCodeSequence">
			<xsl:apply-templates select="dicom:set" mode="ContextCode"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="CurrentRequestedProcedureEvidence">
		<xsl:element name="CurrentRequestedProcedureEvidence">
			<xsl:apply-templates select="dicom:el[@tag='0020000D']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081115']"/> 		
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A375']">
		<xsl:element name="CurrentRequestedProcedureEvidenceSequence">
			<xsl:apply-templates select="dicom:set" mode="CurrentRequestedProcedureEvidence"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="PertinentOtherEvidence">
		<xsl:element name="PertinentOtherEvidence">
			<xsl:apply-templates select="dicom:el[@tag='0020000D']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081115']"/> 		
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A385']">
		<xsl:element name="PertinentOtherEvidenceSequence">
			<xsl:apply-templates select="dicom:set" mode="PertinentOtherEvidence"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='0040A730']">
		<xsl:element name="ContentSequence">
			<xsl:apply-templates select="dicom:set"/> 		
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080005']">
		<xsl:element name="CharacterSet">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0020000D']">
		<xsl:element name="StudyInstanceUID">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080016']">
		<xsl:element name="SOPClassUID">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080018']">
		<xsl:element name="SOPInstanceUID">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00200013']">
		<xsl:element name="InstanceNumber">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A491']">
		<xsl:element name="CompletionFlag">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A492']">
		<xsl:element name="CompletionFlagDescription">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A493']">
		<xsl:element name="VerificationFlag">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080023']">
		<xsl:element name="ContentDate">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080033']">
		<xsl:element name="ContentTime">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0020000E']">
		<xsl:element name="SeriesInstanceUID">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080054']">
		<xsl:element name="RetrieveAETitle">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00880130']">
		<xsl:element name="StorageMediaFileSetID">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00880140']">
		<xsl:element name="StorageMediaFileSetUID">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A032']">
		<xsl:element name="ObservationDateTime">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<!-- Basic encoding mode support for context codes -->

	<xsl:template match="dicom:el[@tag='00080100']">
		<xsl:attribute name="CodeValue">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080102']">
		<xsl:attribute name="CodingSchemeDesignator">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080104']">
		<xsl:attribute name="CodeMeaning">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080103']">
		<xsl:attribute name="CodingSchemeVersion">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<!-- Enhanced encoding mode support for context codes -->

	<xsl:template match="dicom:el[@tag='0008010F']">
		<xsl:attribute name="ContextIdentifier">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080105']">
		<xsl:attribute name="MappingResource">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080106']">
		<xsl:attribute name="ContextGroupVersion">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0008010B']">
		<xsl:attribute name="CodeSetExtensionFlag">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00080107']">
		<xsl:attribute name="ContextGroupLocalVersion">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0008010C']">
		<xsl:attribute name="PrivateCodingSchemeCreatorUID">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0008010D']">
		<xsl:attribute name="CodeSetExtensionCreatorUID">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<!-- Content template support -->

	<xsl:template match="dicom:el[@tag='0040DB00']">
		<xsl:attribute name="TemplateIdentifier">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040DB06']">
		<xsl:attribute name="TemplateVersion">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040DB07']">
		<xsl:attribute name="TemplateLocalVersion">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040DB0B']">
		<xsl:attribute name="TemplateExtensionFlag">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040DB0C']">
		<xsl:attribute name="TemplateExtensionOrganizationUID">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040DB0D']">
		<xsl:attribute name="TemplateExtensionCreatorUID">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<!-- ROOT container match -->

	<xsl:template match="dicom:set" mode="ROOT">
		<xsl:apply-templates select="*[@tag!='0040A050' and @tag!='0040A043' and @tag!='0040A730' and @tag!='0040A040']"/>
		<xsl:element name="CONTAINER_ROOT">
			<xsl:apply-templates select="dicom:el[@tag='0040A050']"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A043']"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A730']"/>
		</xsl:element>
	</xsl:template> 

	<xsl:template match="dicom:el[@tag='0040A010']">
		<xsl:attribute name="Relationship">
			<xsl:value-of select="translate(., ' ', '_')"/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A050']">
		<xsl:attribute name="ContinuityOfContent">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A30A']">
		<xsl:element name="NumericValue">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A160']">
		<xsl:element name="TextValue">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A120']">
		<xsl:element name="DateTimeValue">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A121']">
		<xsl:element name="DateValue">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A122']">
		<xsl:element name="TimeValue">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A123']">
		<xsl:element name="PersonName">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A124']">
		<xsl:element name="UID">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<!-- TCOORD support -->

	<xsl:template match="dicom:el[@tag='0040A130']">
		<xsl:attribute name="TemporalRangeType">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A132']">
		<xsl:element name="ReferencedSamplePositions">
			<xsl:call-template name="templateGenerateEl">
				<xsl:with-param name="parStr"><xsl:value-of select="."/></xsl:with-param>
				<xsl:with-param name="parName">ReferencedSamplePosition</xsl:with-param>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A138']">
		<xsl:element name="ReferencedTimeOffsets">
			<xsl:call-template name="templateGenerateEl">
				<xsl:with-param name="parStr"><xsl:value-of select="."/></xsl:with-param>
				<xsl:with-param name="parName">ReferencedTimeOffset</xsl:with-param>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='0040A13A']">
		<xsl:element name="ReferencedDatetimes">
			<xsl:call-template name="templateGenerateEl">
				<xsl:with-param name="parStr"><xsl:value-of select="."/></xsl:with-param>
				<xsl:with-param name="parName">ReferencedDatetime</xsl:with-param>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>

	<xsl:template name="templateGenerateEl">
		<xsl:param name="parStr"/>
		<xsl:param name="parName"/>			
		<xsl:if test="$parStr != ''">
			<xsl:element name="{$parName}">
				<xsl:choose>
					<xsl:when test="contains($parStr, '\')">
						<xsl:value-of select="substring-before($parStr, '\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$parStr"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<!-- recurse -->
			<xsl:call-template name="templateGenerateEl">
				<xsl:with-param name="parStr" select="substring-after($parStr, '\')"/>
				<xsl:with-param name="parName" select="$parName"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- SCOORD support -->

	<xsl:template match="dicom:el[@tag='00700023']">
		<xsl:attribute name="GraphicType">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:el[@tag='00700022']">
		<xsl:element name="GraphicData">
			<xsl:call-template name="templateGeneratePoints">
				<xsl:with-param name="parStr"><xsl:value-of select="."/></xsl:with-param>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>

	<xsl:template name="templateGenerateCoord">
		<xsl:param name="parStr"/>
		<xsl:choose>
			<xsl:when test="contains($parStr, '\')">
				<xsl:value-of select="substring-before($parStr, '\')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$parStr"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="templateGeneratePoints">
		<xsl:param name="parStr"/>
		<xsl:if test="$parStr != ''">
			<xsl:element name="GraphicPoint">
				<xsl:attribute name="x">
					<xsl:call-template name="templateGenerateCoord">
						<xsl:with-param name="parStr"><xsl:value-of select="$parStr"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="y">
					<xsl:call-template name="templateGenerateCoord">
						<xsl:with-param name="parStr"><xsl:value-of select="substring-after($parStr, '\')"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</xsl:element>
			<!-- recurse -->
			<xsl:call-template name="templateGeneratePoints">
				<xsl:with-param name="parStr">
					<xsl:value-of select="substring-after(substring-after($parStr, '\'), '\')"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- ReferencedContentItem support -->

	<xsl:template match="dicom:el[@tag='0040DB73']">
		<xsl:attribute name="Identifier">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="dicom:set">
		<xsl:element name="ReferencedContentItem">
			<xsl:apply-templates select="*|@*"/>
		</xsl:element>
	</xsl:template> 

	<!-- SR entities -->

	<xsl:template match="dicom:set[dicom:el[@tag='0040A040']='IMAGE']">
		<xsl:element name="IMAGE">
			<xsl:apply-templates select="dicom:el[@tag='0040A010']"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A043']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081199']" mode="ReferencedImageSeq"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A730']"/>
		</xsl:element>
	</xsl:template> 

	<xsl:template match="dicom:set[dicom:el[@tag='0040A040']='WAVEFORM']">
		<xsl:element name="WAVEFORM">
			<xsl:apply-templates select="dicom:el[@tag='0040A010']"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A043']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081199']" mode="ReferencedWaveFormSeq"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A730']"/>
		</xsl:element>
	</xsl:template> 

	<xsl:template match="dicom:set[dicom:el[@tag='0040A040']='COMPOSITE']">
		<xsl:element name="COMPOSITE">
			<xsl:apply-templates select="dicom:el[@tag='0040A010']"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A043']"/>
			<xsl:apply-templates select="dicom:seq[@tag='00081199']" mode="ReferencedSOPSeq"/>
			<xsl:apply-templates select="dicom:seq[@tag='0040A730']"/>
		</xsl:element>
	</xsl:template> 

	<!-- CONTAINER, TEXT, DATETIME, DATE, TIME, PNAME, UIDREF, NUM, CODE, TCOORD -->
	<xsl:template match="dicom:set[dicom:el[@tag='0040A040']]" priority="0">
		<xsl:param name="parType" select="dicom:el[@tag='0040A040']"></xsl:param>
		<xsl:element name="{$parType}">
			<xsl:apply-templates select="*[@tag='0040A010']"/> <!-- otherwise the attribute will not get through -->
			<xsl:apply-templates select="*[@tag='0040A050']"/> <!-- otherwise the attribute will not get through -->
			<xsl:apply-templates select="*[@tag='0040A130']"/> <!-- otherwise the attribute will not get through -->
			<xsl:apply-templates select="*[@tag='00700023']"/> <!-- otherwise the attribute will not get through -->
			<xsl:apply-templates select="*[@tag='0040A043']"/> <!-- ConceptNameCodeSequence -->
			<xsl:apply-templates select="*[@tag='0040A730']"/> <!-- ContentSequence -->
			<xsl:apply-templates select="*[@tag!='0040A010' and @tag!='0040A040' and @tag!='0040A130' and @tag!='00700023' and @tag!='0040A050' and @tag!='0040A043' and @tag!='0040A730']|@*"/>
		</xsl:element>
	</xsl:template> 

	<!-- other -->

	<xsl:template match="dicom:seq[@tag='0040A300']">
		<xsl:element name="MeasuredValueSequence">
			<xsl:apply-templates select="dicom:set/*"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='004008EA']">
		<xsl:element name="MeasurementUnitsCodeSequence">
			<xsl:apply-templates select="dicom:set" mode="ContextCode"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='00081199']" mode="ReferencedImageSeq">
		<xsl:element name="ReferencedImageSequence">
			<xsl:apply-templates select="dicom:set" mode="ReferencedImage"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ReferencedImage">
		<xsl:element name="ReferencedImage">
			<xsl:element name="ReferencedSOPClassUID"><xsl:value-of select="dicom:el[@tag='00081150']"/></xsl:element>
			<xsl:element name="ReferencedSOPInstanceUID"><xsl:value-of select="dicom:el[@tag='00081155']"/></xsl:element>
			<xsl:if test="dicom:el[@tag='00081160']!=''">
				<xsl:element name="ReferencedFrameNumber"><xsl:value-of select="dicom:el[@tag='00081160']"/></xsl:element>
			</xsl:if>
			<xsl:apply-templates select="dicom:seq[@tag='00081199']" mode="ReferencedPresStateSeq"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='00081199']" mode="ReferencedSOPSeq">
		<xsl:element name="ReferencedSOPSequence">
			<xsl:apply-templates select="dicom:set" mode="ReferencedSOP"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ReferencedSOP">
		<xsl:element name="ReferencedSOP">
			<xsl:element name="ReferencedSOPClassUID"><xsl:value-of select="dicom:el[@tag='00081150']"/></xsl:element>
			<xsl:element name="ReferencedSOPInstanceUID"><xsl:value-of select="dicom:el[@tag='00081155']"/></xsl:element>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='00081199']" mode="ReferencedPresStateSeq">
		<xsl:element name="ReferencedPresentationStateSequence">
			<xsl:apply-templates select="dicom:set" mode="ReferencedPresState"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ReferencedPresState">
		<xsl:element name="ReferencedPresentationState">
			<xsl:element name="ReferencedSOPClassUID"><xsl:value-of select="dicom:el[@tag='00081150']"/></xsl:element>
			<xsl:element name="ReferencedSOPInstanceUID"><xsl:value-of select="dicom:el[@tag='00081155']"/></xsl:element>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='00081199']" mode="ReferencedWaveformSeq">
		<xsl:element name="ReferencedWaveformSequence">
			<xsl:apply-templates select="dicom:set" mode="ReferencedWaveform"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ReferencedWaveform">
		<xsl:element name="ReferencedWaveform">
			<xsl:element name="ReferencedSOPClassUID"><xsl:value-of select="dicom:el[@tag='00081150']"/></xsl:element>
			<xsl:element name="ReferencedSOPInstanceUID"><xsl:value-of select="dicom:el[@tag='00081155']"/></xsl:element>
			<xsl:apply-templates select="WaveformChannels"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:seq[@tag='00081110']">
		<xsl:element name="ReferencedStudySequence">
			<xsl:apply-templates select="dicom:set" mode="ReferencedStudy"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="dicom:set" mode="ReferencedStudy">
		<xsl:element name="ReferencedStudy">
			<xsl:element name="ReferencedSOPClassUID"><xsl:value-of select="dicom:el[@tag='00081150']"/></xsl:element>
			<xsl:element name="ReferencedSOPInstanceUID"><xsl:value-of select="dicom:el[@tag='00081155']"/></xsl:element>
		</xsl:element>
	</xsl:template>

	<xsl:template match="WaveformChannels">
	</xsl:template>

	<!-- do not generate code for non-matched tags at root level: -->

	<xsl:template match="/dicom:set/*" priority="0"/>

	<xsl:template match="*">
		<xsl:message terminate="yes">
			unmatched node at <xsl:value-of select="name()"/><xsl:text> tag=</xsl:text>
							  <xsl:value-of select="@tag"/><xsl:text> value=</xsl:text>
							  <xsl:value-of select="."/>
		</xsl:message>
	</xsl:template>

</xsl:stylesheet>

