//
//	Copyright (c)2004 GE Medical Systems
//
//	Helper comment to enable syntax coloring in InterDev: <script>


// Configuration variabled not exported to config.txt
var APP_NAME		= "Centricity DICOM Viewer";
var APP_VERSION		= "Version 2.2";
var APP_COPYRIGHT	= " 2004 GE Medical Systems - All rights reserved";
var APP_DIAGNOSTIC	= "Warning: Centricity DICOM Viewer is intended for secondary review and patient consultation only and should not be used to review studies for primary diagnosis.";

var _localedb		= null;
var _config			= null;
var _strErrorMsg	= null;
var _licensekey		= null;

var SYSERROR_UNABLE_TO_OPEN_LOCALE_DATABASE   = '-3';
var SYSERROR_INVALID_LOCALE                   = '-4';
var SYSERROR_INCORRECT_BROWSER                = '-5';
var SYSERROR_BROWSER_UNTESTED                 = '-6';
var SYSERROR_EXISTING_WEBVIEWER               = '-7';

var mpSysErrors = new Object();
mpSysErrors[SYSERROR_UNABLE_TO_OPEN_LOCALE_DATABASE]   = 'Unable to open the locale database.';
mpSysErrors[SYSERROR_INVALID_LOCALE]                   = 'Locale ID not supported.';
mpSysErrors[SYSERROR_INCORRECT_BROWSER]                = 'Centricity Web requires Internet Explorer 5.5 Service Pack 2 or Internet Explorer 6.0.';
mpSysErrors[SYSERROR_BROWSER_UNTESTED]                 = 'Centricity Web has been tested with Internet Explorer 5.5 Service Pack 2 and Internet Explorer 6.0.\nCentricity Web is not guaranteed to work with the currently installed version.';
mpSysErrors[SYSERROR_EXISTING_WEBVIEWER]               = 'Cannot start Centricity Web twice in one Internet Explorer.';


//
// onload
//
function window.onload()
{
	BrandTitle();
	loadframe.OnLoadComplete();

	// Check if the appframe could be loaded.
	if (HasErrors())
	{
		loadframe.SetErrorText(_strErrorMsg);
		return;
	}

	// Check if the loadframe loaded successfully.
	if (loadframe.HasErrors())
	{
		loadframe.SetErrorText(loadframe.GetErrorText());
		return;
	}

	// Check if the dicomdirframe could be loaded.
	if (dicomdirframe.HasErrors())
	{
		loadframe.SetErrorText(dicomdirframe.GetErrorText());
		return;
	}

	// Check if the viewframe could be loaded.
	if (viewframe.HasErrors())
	{
		loadframe.SetErrorText(viewframe.GetErrorText());
		return;
	}

	if (viewframe.IsStaticPaletteMonitor())
	{
		loadframe.SetErrorText('This monitor configuration is not supported');
		return;
	}

	viewframe.AttachDicomDirFrame(dicomdirframe);

	_licensekey = ShowLicenseDialog(new LicenseKey());
	if (_licensekey != null)
	{
		viewframe.viewlayout.UnlockViewports(_licensekey);
		
		// Hide the 'loadframe' and show the 'application' frames.
		framesetAll.rows = '0, *';
	}
	
	TranslateUIElements(dicomdirframe.document, "BUTTON");			// translate buttons in dicomdir frame
	TranslateUIElements(viewframe.viewcontrol.document, "BUTTON");	// translate buttons in viewcontrol frame

	viewframe.viewcontrol.spanSpeed = GetLocaleString('spanSpeed.caption');
	viewframe.CineSpeedChange(viewframe.GetCineSpeed());

	focus();

	window.setTimeout("LoadInitialDicomDir();", 0); // allow app to create itself before loading dicomdir
}


//
//	LoadInitialDicomDir()
//
function LoadInitialDicomDir()
{
	if (_licensekey == null || location.protocol != "file:")
		return;

	var strPath = GetConfig().GetCommandLineOptions()["open"];
	if (strPath == null || strPath == "")
	{
		strPath = location.pathname.substr(1, 3) + "DICOMDIR";
	}

	dicomdirframe.SetDicomDirPath(strPath);
}


//
// TranslateUIElements
//
function TranslateUIElements(objectContainer, strTag)
{ 
	ASSERT(strTag != 'INPUT'); // cannot update with innerText!
	var rgElem = objectContainer.all.tags(strTag);

	for (var i = 0; i < rgElem.length; i++)
	{
		var elem = rgElem[i];

		if (elem.id != null && elem.id != "")
		{
			var obj = FindString(elem.id + '.caption');
			if (obj.bFound)
			{
				SetElemText(elem, obj.strText);
			}
			elem.title = GetLocaleString(elem.id + '.title');
		}
	}
}


//
// BrandTitle
//
// Purpose: This function brands the title displayed in the caption bar with the text 
//          provided in the configuration file.
//
function BrandTitle()
{
	var strProvidedByTitle = _config.ProvidedByTitle();
	if (strProvidedByTitle.length > 0)
	{
		document.title = APP_NAME + " - " + strProvidedByTitle;
	}
	else
	{
		document.title = APP_NAME;
	}
}


//
// ShowAboutDialog
//
// Purpose: Shows the modal dialog with version, copyright info and a link
//          to the Applicare website.
//
function ShowAboutDialog()
{
	showModalDialog("aboutdlg.htm", window, "dialogHeight:550px; dialogWidth:590px; help:no; edge:raised; status:no; unadorned:yes" );
}


//
// oncontextmenu
//
// Purpose: Mark oncontextmenu events as handled to prevent that IE
//          displays its default menu.
//
function document.oncontextmenu()
{
	return false;
}


//
// ShowHelp
//
function ShowHelp()
{
	showModalDialog("help.htm", window, "help:no; edge:sunken; status:no; resizable:yes");
	return false;
}


//
// GetISettings()
//
function GetISettings()
{
	return window;
}


//
// GetConfiguration
//
function GetConfigurationItem(strKey)
{
	return window[strKey];
}


//
// GetApp
//
function GetApp()
{
  return self;
}


//
// ShowMessageID
// 
function ShowMessageID(strMsgId)
{
	alert(mpSysErrors[strMsgId]);
}


//
// HasErrors
//
function HasErrors()
{
	try
	{
		return (typeof(_localedb) != 'object');
	}
	catch (e)
	{
		return true;
	}
}


//
// GetLicenseKey
//
function GetLicenseKey()
{
	return _licensekey;
}


//
//	GetApplicationDataUrl()
//
function GetApplicationDataUrl(location)
{
	var strLoc = location.href;
	
	var ipos = strLoc.indexOf('?')
	if (ipos > 0)
	{
		strLoc = strLoc.slice(0, ipos);
	}

	ipos = strLoc.lastIndexOf("/");
	return unescape(strLoc.slice(0, ipos));
}


//
// LoadConfigurationFile
//
function LoadConfigurationFile()
{
	if (_config == null)
	{
		_config = new ConfigFile();
	}
}


//
// GetConfig
//
function GetConfig()
{
	return _config;
}


//
// SetLocaleDB
//
function CreateLocaleDB(strLocale)
{
	if (_localedb == null)
	{
		_localedb = new CLocaleDb('lang');
	}

	if (!_localedb.SetLocaleId(strLocale, '_') || _localedb.GetXMLDb() == null)
	{
		_strErrorMsg = mpSysErrors[SYSERROR_UNABLE_TO_OPEN_LOCALE_DATABASE];
		return false;
	}

	if (!_localedb.IsValidLocale())
	{
		_strErrorMsg = mpSysErrors[SYSERROR_INVALID_LOCALE];
		return false;
	}
	SetLocaleDB(_localedb)

	return true;
}

//
//	IsInViewerExe
//
function IsInViewerExe()
{
	return external != null && typeof(external.CreateObject) != 'undefined';
}

LoadConfigurationFile();
CreateLocaleDB(_config.LocaleId());
