//
//	Copyright (c)2004 GE Medical Systems
//

DeriveFrom(SeriesLayoutManager, TableLayoutManager);

//
// SeriesLayoutManager C'tor
//
function SeriesLayoutManager(elemContainer)
{
	this._activeseriesindex	= 0;	// index of the series with the active viewport (0 or 1)
	this._rgseries			= null;
	
	this.CtorTableLayoutManager(this, elemContainer);
	this.SetSeriesLayout(1, 1);
}

//
//	FindViewport
//
function SeriesLayoutManager.prototype.FindViewport(oViewport)
{ with(this) {
	var cseries = GetSeriesCount();
	for (var iseries = 0; iseries < cseries; iseries++)
	{
		var viewport = _rgseries[iseries].FindViewport(oViewport);
		if (viewport != null)
			return viewport;
	}
	return null;
}}

//
// CreateCellContent
//
function SeriesLayoutManager.prototype.CreateCellContent(iCell)
{ with(this) {
	return '<div class=\"classContainer\" id=\"series' + iCell + '"></div>';
}}

//
// SetSeriesLayout
//
function SeriesLayoutManager.prototype.SetSeriesLayout(newRowCnt, newColCnt)
{ with(this) {
	if (newRowCnt == GetRowCount() && newColCnt == GetColCount())
		return false;

	DisposeSeriesAreas();

	_rgseries = new Array();
	
	ChangeLayout(newRowCnt, newColCnt, true);
	
	if (_activeseriesindex >= GetSeriesCount())
	{
		_activeseriesindex = 0;
	}
	
	InitSeriesAreas();
	return true;
}}


//
// DisposeSeriesAreas
//
function SeriesLayoutManager.prototype.DisposeSeriesAreas()
{ with(this) {
	var cseries = GetSeriesCount();
	for (var iseries = 0; iseries < cseries; iseries++)
	{
		_rgseries[iseries].DisposeViewports();
	}
}}


//
// InitSeriesAreas
//
function SeriesLayoutManager.prototype.InitSeriesAreas()
{ with(this) {
	var cseries = GetSeriesCount();
	for (var iseries = 0; iseries < cseries; iseries++)
	{
		_rgseries[_rgseries.length] = new ViewportLayoutManager(GetTableCell(iseries).children[0], iseries);
	}
}}


//
// GetActiveSeries
//
function SeriesLayoutManager.prototype.GetActiveSeries()
{ with(this) {
	return _rgseries[_activeseriesindex];
}}


//
// SetActiveSeries
//
function SeriesLayoutManager.prototype.SetActiveSeries(nSeriesIndex)
{ with(this) {
	if (_activeseriesindex != nSeriesIndex)
	{
		GetActiveViewport().MakeInactive();
		_activeseriesindex = nSeriesIndex;
	}
	
	return _rgseries[_activeseriesindex];
}}


//
// GetSeries
//
function SeriesLayoutManager.prototype.GetSeries(index)
{ with(this) {
	return _rgseries[index];
}}


//
// GetSeriesCount
//
function SeriesLayoutManager.prototype.GetSeriesCount()
{ with(this) {
	return GetCellCount();
}}


//
// GetActiveSeriesIndex
//
function SeriesLayoutManager.prototype.GetActiveSeriesIndex()
{ with (this) {
	return _activeseriesindex;
}}


//
// GetSeriesLayout
//
function SeriesLayoutManager.prototype.GetSeriesLayout()
{ with (this) {
	return GetRowCount().toString() + 'x' + GetColCount().toString();
}}
