//
//	Copyright (c)2004 GE Medical Systems
//

// -------------------- WindowLevelPreset ------------------------------
//
// WindowLevelPreset C'tor
//
function WindowLevelPreset(strPresetName, strPresetValue)
{
	this._strPresetName = strPresetName;
	this._strPresetValue = strPresetValue;
}

//
// GetName
//
function WindowLevelPreset.prototype.GetName()
{ with(this) {
	return _strPresetName;
}}

//
// GetValue
//
function WindowLevelPreset.prototype.GetValue()
{ with(this) {
	return _strPresetValue;
}}


//
// WindowLevelPresetFromString
//
function WindowLevelPresetFromString(strValueName)
{
	if (strValueName == '')
		return null;
		
	var rgstr = strValueName.split(";");
	if (rgstr.length != 2)
		return null;
		
	return new WindowLevelPreset(rgstr[1], rgstr[0]);
}


// -------------------- ModalityPresetList ------------------------------
//
// ModalityPresetList
//
function ModalityPresetList(strMod)
{
	this._strMod = strMod;
	this._rgPresets = new Array;
}

//
// Initialize
//
function ModalityPresetList.prototype.Initialize(rgnode)
{ with(this) {
	for (var i = 0; i < rgnode.length; i++)
	{
		_rgPresets[_rgPresets.length] = new WindowLevelPreset(rgnode[i].getAttribute('name'), rgnode[i].getAttribute('value'));
	}
}}


// -------------------- WLPresetListControl ------------------------------
//
// WLPresetListControl C'tor
//
function WLPresetListControl(elemSelect)
{
	elemSelect.onchange = CreateStaticFunction(this, 'OnWindowLevelPresetChange');
	this._elemSelect = elemSelect;
	this._mpModPresets = new Object;
	this._strMod = '';
}


//
// Initialize
//
function WLPresetListControl.prototype.Initialize(nodeXML)
{ with(this) {
	if (nodeXML == null)
		return;

	var rgnode = nodeXML.selectNodes('modality');
	for (var i = 0; i < rgnode.length; i++)
	{
		var strMod = rgnode[i].getAttribute('value');
		var modpresetlist = new ModalityPresetList(strMod);
		modpresetlist.Initialize(rgnode[i].selectNodes('wlpreset'));
		_mpModPresets[strMod] = modpresetlist;
	}
}}


//
// OnWindowLevelPresetChange
//
function WLPresetListControl.prototype.OnWindowLevelPresetChange()
{ with(this) {
	parent.OnWindowLevelPresetChange(_elemSelect.value);
}}


//
// OnModalityChange
//
function WLPresetListControl.prototype.OnModalityChange(strMod, preset)
{ with(this) {
	if (_strMod == strMod)
		return false;

	ClearPresets();
	AddPresets(_mpModPresets[strMod], preset);
	_strMod = strMod;
	return true;
}}


//
// ClearPresets
//
function WLPresetListControl.prototype.ClearPresets()
{ with(this) {
	var cpreset = _elemSelect.options.length;
	for (var ipreset = 0; ipreset < cpreset; ipreset++)
	{
		_elemSelect.options.remove(0);
	}
}}


//
// AddOption
//
function WLPresetListControl.prototype.AddOption(strValue, strText, nPosition)
{ with(this) {
	var option		= document.createElement("OPTION");
	option.text		= strText;
	option.value	= strValue;
	_elemSelect.options.add(option, nPosition);
}}


//
// AddPresets
//
function WLPresetListControl.prototype.AddPresets(rgpresets, preset)
{ with(this) {
	if (rgpresets == null)
		return;
		
	var rgpreset		= rgpresets._rgPresets;
	var bTmpPresetAdded	= false;
	
	if (preset != null)
	{
		// SCR 6370: add future preset first to prevent flickering when adding many (e.g. >100) items
		for (var ipreset = 0; ipreset < rgpreset.length; ipreset++)
		{
			if (rgpreset[ipreset].GetValue() == preset.GetValue())
			{
				AddOption(rgpreset[ipreset].GetValue(), rgpreset[ipreset].GetName());
				bTmpPresetAdded = true;
				break;
			}
		}
	}
	
	for (var ipreset = 0; ipreset < rgpreset.length; ipreset++)
	{
		AddOption(rgpreset[ipreset].GetValue(), rgpreset[ipreset].GetName());
	}
	
	if (bTmpPresetAdded)
	{
		_elemSelect.options.remove(0);
	}
}}


//
// Update
//
function WLPresetListControl.prototype.Update(bIsPetCtMode, dicomdirframe, viewport)
{ with(this) {

	var preset				= null;
	var bDisable			= false;
	
	if (bIsPetCtMode && viewport != null && viewport.GetViewportIndex() == SERIESTYPE_FUSED) 
	{
		var	strWL				= viewport == null ? "" : viewport.GetFusionColorPalette();
		preset					= new WindowLevelPreset(strWL, strWL);
	
		OnModalityChange("FUSION", preset);

		bDisable	= !dicomdirframe.IsImageSelected();
	}
	else
	{
		var strMod	= dicomdirframe.GetActiveModality();
		var strWL	= strMod == "PT" || viewport == null ? "" : viewport.GetWindowLevel();
		preset		= WindowLevelPresetFromString(strWL);
		
		if (OnModalityChange(strMod, preset))
		{
			AddOption("", GetApp().GetLocaleString('strNoWindowLevel'), 0);
		}
		
		bDisable	= !dicomdirframe.IsImageSelected() || strMod == "PT";
	}

	listWindowPreset.disabled	= bDisable;
	listWindowPreset.value		= preset != null ? preset.GetValue() : "";
	
	if (listWindowPreset.value == "")
	{
		listWindowPreset.selectedIndex = 0;
	}
}}
