//
//	Copyright (c)2005 GE Medical Systems
//
//	Helper comment to enable syntax coloring in InterDev: <script>

var _dicomdirframe			= null;
var _bPlayMode				= false;
var _timerID;
var _bMultiFrameCine		= false;
var _bShowAnnotations		= true;
var _nCineSpeed				= 10; // in frames per second.
var _nCineSpeedMax			= 100;
var _nCineSpeedMin			=  1;
var _rgattributeSeries		= new Array();
var _mapAnnotation			= new Object();
var _bReportListInitialized = false;

//
// onunload
//
function window.onunload()
{
	try
	{
		HideReportFrame();
	}
	catch (e)
	{
	}
}

//
// HasErrors
//
function HasErrors()
{
	return (viewlayout.HasErrors() || viewcontrol.HasErrors());
}


//
// GetErrorText
//
function GetErrorText()
{
	if (viewlayout.HasErrors())
		return viewlayout.GetErrorText();

	if (viewcontrol.HasErrors())
		return viewcontrol.GetErrorText();
}


//
// AttachDicomDirFrame
//
function AttachDicomDirFrame(dicomdirframe)
{
	_dicomdirframe						= dicomdirframe;
	_dicomdirframe.OnDicomDirChanged	= OnDicomDirChanged;
	_dicomdirframe.OnStudyChanged		= OnStudyChanged;
	_dicomdirframe.OnSeriesChanged		= OnSeriesChanged;
	_dicomdirframe.OnImageChanged		= OnImageChanged;

	// Stop the cine if the user goes to the browse dialog.
	_dicomdirframe.onbrowsemode = StopCine;

	// Trigger the first initial update.
	_dicomdirframe.OnImageChanged();
	
	InitStructuredReportUI();
	InitPresentationStateUI();
}


//
// OnSeriesLayoutChange
//
function OnSeriesLayoutChange()
{
	if (_dicomdirframe == null)
		return;
		
	var nSeriesIndex	= _dicomdirframe.GetActiveSeriesIndex();
	var nImageIndex		= _dicomdirframe.GetActiveImageIndex();
	var nSeriesCount	= viewlayout._serieslayoutman.GetSeriesCount();
	
	for (var i = nSeriesCount - 1; i >= 0; i--)
	{
		var oSeries = viewlayout._serieslayoutman.SetActiveSeries(i);
		oSeries.SetSeriesNr(nSeriesIndex);
		oSeries.SetImageNr(nImageIndex);
		SetDicomDirActiveImages(nSeriesIndex, nImageIndex);
	}
}


//
// OnViewportLayoutChange
//
function OnViewportLayoutChange()
{
	if (_dicomdirframe == null)
		return;

	SetDicomDirActiveImages(_dicomdirframe.GetActiveSeriesIndex(), _dicomdirframe.GetActiveImageIndex());
}


//
// GetSeriesAttributes
//
function GetSeriesAttributes(strSeriesUID)
{
	return strSeriesUID != '' ? _rgattributeSeries[strSeriesUID] : null;
}


//
// SetSeriesAttributes
//
function SetSeriesAttributes(strSeriesUID, attributes)
{
	_rgattributeSeries[strSeriesUID] = attributes;
}


//
// ClearSeriesAttributes
//
function ClearSeriesAttributes(strSeriesUID)
{
	SetSeriesAttributes(strSeriesUID, null);
}


//
// SwitchActiveViewport
//
function SwitchActiveViewport(bIsPetCtMode)
{
	if (!viewlayout._bUpdateViewports)
		return false; // prevent recursive calls

	var viewportActive		= viewlayout.GetActiveViewport();
	var viewportActivePrev	= viewportActive;
	if (viewportActive == null)
	{
		viewportActive = viewlayout.SetActiveViewport(0);
	}

	var nActiveSeriesIndex = _dicomdirframe.GetActiveSeriesIndex();
	
	if (nActiveSeriesIndex != -1 && bIsPetCtMode)
	{
		var nActiveViewportIndex = viewportActive.GetViewportIndex();

		for (var iviewport = SERIESTYPE_CT; iviewport <= SERIESTYPE_MIP; iviewport++)
		{
			if (iviewport == nActiveViewportIndex || iviewport == SERIESTYPE_FUSED)
				continue;

			var nSeriesIndexViewport = _dicomdirframe.GetRealSeriesIndex(iviewport);
			if (nSeriesIndexViewport != nActiveSeriesIndex)
				continue;
		
			if (nActiveViewportIndex == SERIESTYPE_FUSED && (iviewport == SERIESTYPE_CT || iviewport == SERIESTYPE_PT))
				continue;
			
			viewportActive = viewlayout.SetActiveViewport(iviewport);
		}
	}
	
	viewportActive.MakeActive();
	
	return viewportActive != viewportActivePrev;
}


//
// SetViewportLayout
//
function SetViewportLayout(nRows, nColumns)
{
	if (viewlayout.SetViewportLayout(nRows, nColumns))
	{
		OnViewportLayoutChange();
	}
}


//
// SetSeriesLayout
//
function SetSeriesLayout(nRows, nColumns)
{
	if (viewlayout.SetSeriesLayout(nRows, nColumns))
	{
		OnSeriesLayoutChange();
	}
}

//
// BrowseForFile
//
function BrowseForFile()
{
	_dicomdirframe.BrowseForFile();
}


//
// ImageBack
//
function ImageBack()
{
	if (viewlayout.IsSelectedImageMultiFrame())
	{
		viewlayout.GetActiveViewport().SelectPreviousFrame();
	}
	else
	{
		_dicomdirframe.SelectPreviousImagesInSeries(1);
	}
}


//
// ImageForward
//
function ImageForward()
{
	if (viewlayout.IsSelectedImageMultiFrame())
	{
		viewlayout.GetActiveViewport().SelectNextFrame();
	}
	else
	{
		_dicomdirframe.SelectNextImagesInSeries(1);
	}
}


//
// GetImagesPerPage
//
function GetImagesPerPage(keyevent)
{
	if (IsPetCtMode()) 
	{
		var nImagesPerPage = Math.max(GetApp().GetConfig().GetImagesPerPage(), 2);
			
		return keyevent != null && keyevent.ctrlKey ? nImagesPerPage / 2 : nImagesPerPage;		
	}
	
	return viewlayout.GetViewportCount();
}


//
// PageBack
//
function PageBack(keyevent)
{
	ASSERT(!viewlayout.IsSelectedImageMultiFrame());
	_dicomdirframe.SelectPreviousImagesInSeries(GetImagesPerPage(keyevent));
}


//
// PageForward
//
function PageForward(keyevent)
{
	ASSERT(!viewlayout.IsSelectedImageMultiFrame());
	_dicomdirframe.SelectNextImagesInSeries(GetImagesPerPage(keyevent));
}


//
// SeriesBack
//
function SeriesBack()
{
	_dicomdirframe.SelectPreviousSeries();
}


//
// SeriesForward
//
function SeriesForward()
{
	_dicomdirframe.SelectNextSeries();
}


//
// ImageRewind
//
function ImageRewind()
{
	if (viewlayout.IsSelectedImageMultiFrame())
	{
		viewlayout.GetActiveViewport().SelectFrame(0);
	}
	else
	{
		_dicomdirframe.SelectFirstImageInSeries();
	}
}


//
// OnCinePlayPause
//
function OnCinePlayPause()
{
	if (IsCineRunning())
	{
		StopCine();
		return;
	}

	if (!IsPetCtMode())
	{
		SetViewportLayout(1, 1);
	}

	StartCine();	
}


//
// OnCineStop
//
function OnCineStop()
{
	StopCine();
	ImageRewind();
}


//
// IsCineRunning
//
function IsCineRunning()
{
	return _bPlayMode;
}


//
// SetCineSpeed
//
function SetCineSpeed(nCineSpeed)
{
	_nCineSpeed = nCineSpeed;
	if (_bPlayMode)
	{
		clearInterval(_timerID);
		_timerID = setInterval(OnCineTimerTick, 1000 / _nCineSpeed);
	}
}


//
// GetCineSpeed
//
function GetCineSpeed()
{
	return _nCineSpeed;
}


//
// CineSpeedChange
//
function CineSpeedChange(nCineSpeed)
{
	SetCineSpeed(nCineSpeed);
	viewcontrol.OnCineSpeedChange(_nCineSpeedMin, nCineSpeed, _nCineSpeedMax);
}


//
// CineSpeedDecrease
//
function CineSpeedDecrease()
{
	var nCineSpeed = GetCineSpeed();
	if (nCineSpeed > _nCineSpeedMin)
	{
		nCineSpeed -= 1;
		CineSpeedChange(nCineSpeed);
	}
}


//
// CineSpeedIncrease
//
function CineSpeedIncrease()
{
	var nCineSpeed = GetCineSpeed();
	if (nCineSpeed < _nCineSpeedMax)
	{
		nCineSpeed += 1;
		CineSpeedChange(nCineSpeed);
	}
}


//
// StartCine
// 
function StartCine()
{
	if (IsPetCtMode())
	{
		viewlayout.SetActiveViewport(SERIESTYPE_MIP);
	}
		
	_bPlayMode			= true;
	
	viewcontrol.NotifyPlayMode(_bPlayMode);
	
	_bMultiFrameCine	= viewlayout.IsSelectedImageMultiFrame();
	_timerID			= setInterval(OnCineTimerTick, 1000 / _nCineSpeed);
}


//
// StopCine
//
function StopCine()
{
	if (!IsCineRunning())
		return;

	clearInterval(_timerID);
	_bPlayMode = false;
	
	viewcontrol.NotifyPlayMode(_bPlayMode);
	
	_dicomdirframe.OnImageChanged();
}


//
// OnCineTimerTick
//
// Purpose: Handles timer events by selecting the next image.
//
function OnCineTimerTick()
{
	if (_bMultiFrameCine)
	{
		viewlayout.GetActiveViewport().SelectNextFrame();
	}
	else
	{
		var OrginalEventHandler = _dicomdirframe.OnImageChanged;
		_dicomdirframe.OnImageChanged = OnImageChangedCine;

		if (_dicomdirframe.HasNextImageInSeries())
		{
			_dicomdirframe.SelectNextImagesInSeries(1);
		}
		else
		{
			_dicomdirframe.SelectFirstImageInSeries();
		}

		_dicomdirframe.OnImageChanged = OrginalEventHandler;
	}
}


//
// IsSelectedImageMultiFrame
//
function IsSelectedImageMultiFrame()
{
	return viewlayout.IsSelectedImageMultiFrame();
}


//
// SetShowAnnotations
// 
function SetShowAnnotations(bShowAnnotations)
{
	_bShowAnnotations = bShowAnnotations;
	viewlayout.OnShowAnnotationsChange(IsPetCtMode());
}


//
// GetShowAnnotations
// 
function GetShowAnnotations()
{
	return _bShowAnnotations;
}

function OnSetFocus(oViewport)
{
	var viewport = viewlayout._serieslayoutman.FindViewport(oViewport);
	if (viewport != null)
		viewport.OnFocusViewControl();
}

//
// OnMouseWheelViewControl
//
// Purpose: Receives mouse wheel events from the viewport control that has the focus.
//          Normal mode: select the next or previous image in a series.
//          Cine   mode: increase or decrease the cine speed.
//
function OnMouseWheelViewControl(nTicks)
{
	if (nTicks < 0)
	{
		nTicks = Math.abs(nTicks);
		for (var i = 0; i < nTicks; i++)
		{
			_bPlayMode ? CineSpeedDecrease() : setTimeout("ImageForward();", 0);
		}
	}
	else
	{
		for (var i = 0; i < nTicks; i++)
		{
			_bPlayMode ? CineSpeedIncrease() : setTimeout("ImageBack();", 0);
		}
	}
}


//
// OnResetImageSettings
//
// Purpose: event fired when user resets image settings via the viewport context menu
//
function OnResetImageSettings()
{
	var bIsPetCtMode = IsPetCtMode();
	viewlayout.GetActiveViewport().OnResetImageSettings(bIsPetCtMode);
	viewcontrol.UpdateControls(_dicomdirframe, bIsPetCtMode);
}


//
// OnPropagateClicked
//
function OnPropagateClicked()
{
	var viewportActive	= viewlayout.GetActiveViewport();	
	var attributes		= viewportActive.GetAttributes();

	SetSeriesAttributes(viewportActive.GetSeriesUID(), attributes);

	var bIsPetCtMode = IsPetCtMode();
	
	if (bIsPetCtMode || viewlayout.GetViewportLayout() != "1x1")
	{
		viewlayout.PropagateAttributes(bIsPetCtMode, attributes);
	}
}


//
// OnDicomDirChanged
//
function OnDicomDirChanged()
{
	var cseries			= _dicomdirframe.GetSeriesCount();
	_rgattributeSeries	= new Array(cseries);
	_mapAnnotation		= new Object();	
	
	for (var i = 0; i < cseries; i++)
	{
		_rgattributeSeries[i] = null;
	}

	SetSeriesLayout(1, 1);
	
	if (cseries == 0) // single dicom file
	{
		InitStructuredReportUI();
		InitPresentationStateUI();
	}
}


//
// InitStructuredReportUI
//
function InitStructuredReportUI()
{
	_dicomdirframe.InitReports();

	var bHasReports		= _dicomdirframe.GetReportCount() > 0;

	viewcontrol.SetButtonState(viewcontrol.btnShowReport, !bHasReports);
	reportcontrol.ClearReportListbox();
	
	if (!bHasReports)
	{
		HideReportFrame();
	}
	else if (viewcontrol.IsButtonChecked(viewcontrol.btnShowReport))
	{
		ShowReportFrame();
	}
}

//
// InitPresentationStateUI
//
function InitPresentationStateUI()
{
	viewcontrol.ClearPresentationStateListbox();
	viewcontrol.Feed2PresentationStateListbox(GetApp().GetLocaleString('strEmptyPresentationState'), 0);

	// fill dropdown list with presentation states from DICOMDIR
	var cPR = _dicomdirframe.GetPresentationStateCount();
	if (cPR > 0)
	{
		for (var iPR = 0; iPR < cPR; iPR++)
		{
			var str = _dicomdirframe.GetPresentationStateDescription(iPR);
			if (str == "")
			{
				str = _dicomdirframe.GetPresentationStateLabel(iPR);
			}
			viewcontrol.Feed2PresentationStateListbox(str, iPR+1);
		}
	}

	viewcontrol.SelectPresentationState(cPR);
}


//
// OnStudyChanged
//
function OnStudyChanged()
{
	_dicomdirframe.ResetIsPetCtStudyFlag();

	SetSeriesLayout(1, 1);

	var nRowCols = IsPetCtMode() ? 2 : 1;
	SetViewportLayout(nRowCols, nRowCols);

	InitStructuredReportUI();
	InitPresentationStateUI();
	
	_bReportListInitialized	= false;
}


//
// OnSeriesChanged
//
function OnSeriesChanged()
{
}


//
// OnImageChanged
//
function OnImageChanged()
{
	if (!_bReportListInitialized)
	{
		_bReportListInitialized = true;
		InitStructuredReportUI();
	}

	var bIsPetCtMode = IsPetCtMode();
	
	viewlayout.UpdateAllViewports(bIsPetCtMode, _dicomdirframe);

	if (IsCineRunning())
	{
		StopCine();
	}

	if (!SwitchActiveViewport(bIsPetCtMode))
	{
		viewcontrol.UpdateControls(_dicomdirframe, bIsPetCtMode);
	}
}


//
// OnImageChangedCine
//
function OnImageChangedCine()
{
	var bIsPetCtMode = IsPetCtMode();
	if (bIsPetCtMode)
	{
		var viewport = viewlayout.GetActiveSeries().GetViewport(SERIESTYPE_MIP);
		viewport.UpdateViewport(_dicomdirframe, bIsPetCtMode);
	}
	else
	{
		var viewport = viewlayout.GetActiveViewport();
		viewport.UpdateViewport(_dicomdirframe, bIsPetCtMode);
	}
}


//
// OnPresentationStateChange
//
function OnPresentationStateChange(value)
{
	var strSeriesUID = viewlayout.GetActiveViewport().GetSeriesUID();
	
	ClearImageAnnotations(strSeriesUID);
	ClearSeriesAttributes(strSeriesUID);
	
	viewlayout.OnPresentationStateChange(value);
	
	viewcontrol._wlpresetlist.Update(IsPetCtMode(), _dicomdirframe, viewlayout.GetActiveViewport());
}


//
// GetPresentationStateIndex
//
function GetPresentationStateIndex()
{
	return parseInt(viewcontrol.listPresentationStates.value);
}


//
// ClearImageAnnotations
//
function ClearImageAnnotations(strSeriesUID)
{
	ASSERT(strSeriesUID != null && strSeriesUID != '');
	
	_mapAnnotation[strSeriesUID] = null;
}


//
// SetImageAnnotations
//
function SetImageAnnotations(strSeriesUID, strImageUID, nFrameIndex, strAnnot)
{
	ASSERT(strSeriesUID != null && strSeriesUID != '');
	
	if (_mapAnnotation[strSeriesUID] == null)
	{
		_mapAnnotation[strSeriesUID] = new Object;
	}
	_mapAnnotation[strSeriesUID][strImageUID + '_' + nFrameIndex] = strAnnot;
}


//
// GetImageAnnotations
//
function GetImageAnnotations(strSeriesUID, strImageUID, nFrameIndex)
{
	return _mapAnnotation[strSeriesUID] != null ? _mapAnnotation[strSeriesUID][strImageUID + '_' + nFrameIndex] : null;
}


//
// OnChangeImageAnnotations
//
function OnChangeImageAnnotations(strAnnot)
{ with(this) {

	var viewportActive = viewlayout.GetActiveViewport();

	SetImageAnnotations(viewportActive.GetSeriesUID(), viewportActive.GetImageUID(), viewportActive.GetFrameIndex(), strAnnot);
}}


//
// SetDicomDirActiveImages
//
function SetDicomDirActiveImages(nSeriesIndex, nImageIndex, nViewports)
{
	_dicomdirframe.SetActiveImages(nSeriesIndex, nImageIndex, nViewports != null ? nViewports : viewlayout.GetViewportCount());
}


//
// IsPetCtMode
//
function IsPetCtMode()
{
	return _dicomdirframe != null && _dicomdirframe.IsPetCtStudy() && _dicomdirframe.GetViewMode() == VIEWMODE_PETCT;
}


//
// OnWindowLevelPresetChange
//
function OnWindowLevelPresetChange(strValue)
{
	var viewport = viewlayout.GetActiveViewport();
	if (IsPetCtMode() && viewport.GetViewportIndex() == SERIESTYPE_FUSED)
	{
		viewport.SetFusionColorPalette(strValue);
	}
	else
	{
		viewport.SetWindowLevel(strValue != '' ? strValue : viewport.GetInitialWindowLevel());
	}
}


//
// IsStaticPaletteMonitor
//
function IsStaticPaletteMonitor()
{
	return viewlayout.GetActiveViewport().IsStaticPaletteMonitor();
}


//
// ShowAboutDialog
//
function ShowAboutDialog()
{
	parent.ShowAboutDialog();
}


//
// GetViewMode
// 
function GetViewMode()
{
	return _dicomdirframe.GetViewMode();
}


//
// SetViewMode
// 
function SetViewMode(nViewMode)
{
	var viewportActive = viewlayout.GetActiveViewport();
	if (viewportActive != null && GetViewMode() == VIEWMODE_PETCT)
	{
		this._nViewportIndexPrev = viewportActive.GetViewportIndex();
	}

	if (nViewMode == VIEWMODE_PETCT)
	{
		SetSeriesLayout(1, 1);
		SetViewportLayout(2, 2);
	}

	_dicomdirframe.SetViewMode(nViewMode);

	OnImageChanged();
	
	if (nViewMode != VIEWMODE_PETCT)
	{
		OnViewportLayoutChange();
	}	
	
	viewlayout.SetActiveViewport(nViewMode == VIEWMODE_PETCT && _nViewportIndexPrev != null ? _nViewportIndexPrev : 0);
}


//
// ShowStructuredReport
//
function ShowStructuredReport()
{
	reportcontrol.ShowReport(_dicomdirframe);
}


//
// ShowReportFrame
//
function ShowReportFrame()
{
	ShowStructuredReport();
	frmDataView.frameSpacing = '2';

	var strRows = GetUserDataAttribute(parent.framesetAll, "frmDataView_strRows");
	if (strRows == null || strRows == '')
	{
		strRows = '*, 200';
	}
	
	frmDataView.rows = strRows;
}


//
// HideReportFrame
//
function HideReportFrame()
{
	var strRows = frmDataView.rows;
	var rgstrRow = strRows.split(',');
	if (parseInt(rgstrRow[1]) > 0)
	{
		SetUserDataAttribute(parent.framesetAll, "frmDataView_strRows", frmDataView.rows);
	}

	frmDataView.frameSpacing = '';
	frmDataView.rows = '*, 0';
}
