//
//	Copyright (c)2004 GE Medical Systems
//
//	Helper comment to enable syntax coloring in InterDev: <script>

//
// CheckBrowserVersion
//
// returns whether the browser version is supported
function CheckBrowserVersion(version)
{
	// Only Internet Explorer 5.5 and up supported
	if (version < 550)
		return false;	

	// Checks for other unsupported versions can be added
	return true;
}

//
// CheckBrowserVersionUntested
//
// returns whether the browser version is supported but not tested
function CheckBrowserVersionUntested(version)
{
	// Only Internet Explorer 5.5 SP2 and IE 6.0 are tested
	if (version == 552 || version == 600 || version == 601 || version == 602)
		return false;	

	return true;
}


//
// HandleOnLoad
//
function HandleOnLoad()
{
	// Verify if we are running the correct version of IE.
	if (!CheckBrowserVersion(BrowserVersion()))
	{
		alert("Centricity DICOM Viewer requires Internet Explorer 5.5 Service Pack 2 or Internet Explorer 6.0.");
		return;
	}

	if (CheckBrowserVersionUntested(BrowserVersion()))
	{
		alert('Centricity DICOM Viewer has been tested with Internet Explorer 5.5 (SP2) and Internet Explorer 6.0 (SP1/SP2).\nCentricity DICOM Viewer is not guaranteed to work with the currently installed version.');
	}

	// Verify if we are running on the correct CPU.
	if (navigator.cpuClass != "x86")
	{
		alert("This page can only be viewed on a computer with a x86 CPU.");
		return;
	}

	// Verify if we are running on the correct OS.
	if (navigator.platform != "Win32")
	{
		alert("This page can only be viewed with a browser running on Microsoft Windows");
		return;
	}

	// Check the screen settings.
	if (screen.colorDepth < 24)
	{
		var strMessage = "Warning: Your display is not configured to display TrueColor (24 bit color)\n" +
		                 "Some images require TrueColor to be correct displayed.";
		alert(strMessage);
	}

	// Execute the application.
	location.replace('app.htm' + location.search);
}

