/*
	(c)2004 GE Medical Systems


	Version control:
*/
//<SCRIPT>


//
// CLocaleDb
//
// Purpose: Constructor. Argument 'strLocaleId' contains the locale to use in RFC 1766 format.
//
function CLocaleDb(strXmlFilenameBase)
{
	this._strLocaleId = '';
	this._xmlDb       = null;
	this._strXmlFilenameBase = strXmlFilenameBase;
}


//
// IsValidLocale
//
// Purpose: Verifies that locale db supports the current locale id
function CLocaleDb.prototype.IsValidLocale()
{ with (this) {
	return _xmlDb != null && FindString('msgIsValidLocale').bFound;
}}


//
// GetLocaleId
//
function CLocaleDb.prototype.GetLocaleId()
{ with (this) {
	return _strLocaleId;
}}


//
// GetXmlFilename()
//
function CLocaleDb.prototype.GetXmlFilename(strLocaleId)
{ with (this) {
	return _strXmlFilenameBase +  "-" + strLocaleId + ".xml";
}}


//
// SetLocaleId
//
// Purpose: Set a new locale ID. Will return false if XML database needs to be reloaded and its fails.
//
function CLocaleDb.prototype.SetLocaleId(strLocaleId, strDelim)
{ with (this) {
	if (strDelim == null)
		strDelim = '-';

	var strNewLocaleId = strLocaleId.toLowerCase();
	if (strNewLocaleId == _strLocaleId)
		return true;

	try
	{
		var strXmlDoc = _strXmlFilenameBase +  strDelim + strNewLocaleId + ".xml";
		var xmlDb = CreateXmlDoc(strXmlDoc, false, true);
	}
	catch (e)
	{
		return false;
	}

	_strLocaleId = strNewLocaleId;
	_xmlDb = xmlDb;
	return true; 
}}


//
// GetXMLDb
//
function CLocaleDb.prototype.GetXMLDb()
{ with (this) {
	return _xmlDb;
}}


//
// FindString
//
// Purpose: Tries to find a string that matches the requested ID in the configured locale.
//          The functions returns a small 'result' object that contains the properties:
//          strText: containing the found string or 'strStringId' when the string could not be found.
//          bFound:  result of the find operation.
//
function CLocaleDb.prototype.FindString(strStringId)
{ with (this) {
	var result = new Object;
	var strMatch = "id('" + strStringId + "')/tuv[@lang = '" + _strLocaleId + "']";
	
	if (_xmlDb != null)
	{
		var nodeTranslationUnitVariant = _xmlDb.selectSingleNode(strMatch);
		if (nodeTranslationUnitVariant != null)
		{
			result.strText = nodeTranslationUnitVariant.text;
			result.bFound  = true;
			return result;
		}
	}

	result.strText = strStringId;
	result.bFound  = false;
	return result;
}}



