/*
	(c)2004 GE Medical Systems


	Version control:

	This file containts support functions to translate strings and elements.
*/
// <SCRIPT>


// Create a private reference to '_localedb' to be able to use '_localedb' when the
// the parent is already unloaded (during the shutdown process for example).
var _localedb = parent._localedb;


//
// SetLocaleDB
//
function SetLocaleDB(newlocaledb)
{
	_localedb = newlocaledb;
}

//
// GetLocaleDB
//
function GetLocaleDB()
{
	return _localedb;
}

//
// GetLocaleString
//
function GetLocaleString(strStringID)
{
	return _localedb.FindString(strStringID).strText;
}

//
// FindString
//
function FindString(strStringID)
{
	return _localedb.FindString(strStringID);
}

//
//	FindStringCached
//
function FindStringCached(strStringId, mpCache)
{
	var res = mpCache[strStringId];
	if (res != null)
	{
		return res;
	}

	res = FindString(strStringId);
	mpCache[strStringId] = res;
	return res;
}

//
// SetElemText
//
function SetElemText(elem, str)
{
	for (var i = 0; i < elem.childNodes.length; i++)
	{
		var node = elem.childNodes.item(i);
		if (node.nodeType == 3)
		{
			node.data = str;
			return;
		}
	}
	elem.insertAdjacentText('afterBegin', str);
}


//
// TranslateElements
//
function TranslateElements(objectContainer, strTag)
{ 
	ASSERT(strTag != 'INPUT'); // cannot update with innerText!
	var rgElem = objectContainer.all.tags(strTag);

	for (var i = 0; i < rgElem.length; i++)
	{
		var elem = rgElem[i];
		
		if (elem.captionid != null && elem.captionid != "")
		{
			SetElemText(elem, GetLocaleString(elem.captionid));
		}
		if (elem.tooltipid != null && elem.tooltipid != "")
		{
			elem.title = GetLocaleString(elem.tooltipid);
		}
	}
}

//
// TranslateCaptions
//
function TranslateCaptions(xmlnode)
{ with (this) {
	var mpCache = new Object();
	var nodesTranslate = xmlnode.selectNodes(".//*[@captionid]");
	for (var inode = 0; inode != nodesTranslate.length; inode++)
	{
		var node = nodesTranslate.item(inode);
		var oRes = FindStringCached(node.getAttribute("captionid"), mpCache);
		if (oRes.bFound)
		{
			node.text = oRes.strText;
		}
	}
}}


//
// TranslateNode
//
function TranslateNode(xmlnode)
{
	if (xmlnode.getAttribute('descrid') != '')
	{
		return GetLocaleString(xmlnode.getAttribute('descrid'));
	}
	if (xmlnode.getAttribute('nameid') != '')
	{
		return GetLocaleString(xmlnode.getAttribute('descrid'));
	}
	if (xmlnode.getAttribute('descr') != '')
	{
		return xmlnode.getAttribute('descrid');
	}
	return xmlnode.getAttribute('name');
}



//
// TranslateChilderenByID
//
function TranslateChilderenByID(elemParent, strTag)
{
	var rgElem = elemParent.all.tags(strTag);

	var bLabel   = strTag == "LABEL";
	var bLegend	 = strTag == "LEGEND";

	for (var i = 0; i < rgElem.length; i++)
	{
		var elem = rgElem[i];
		var strId = elem.id;

		if (elem.getAttribute('CAPTION') != 'false')
		{			
			elem.innerText = GetLocaleString( (bLabel || bLegend) ? strId : (strId + '.Caption'));
		}

		if (!bLegend && (elem.getAttribute('TOOLTIP') != 'false'))
		{
			var elemFor = null;
			var result = null;
			if (bLabel)
			{
				elemFor = elem.parentElement.all[elem.htmlFor];
				if ((elemFor != null) && (elemFor.getAttribute('TOOLTIP') != 'false'))
				{
					result = FindString(elemFor.id + '.Tooltip');
				}
			}
			
			if (result == null)
			{
				result = FindString(elem.id + '.Tooltip');
			}

			if (result.bFound)
			{
				elem.title = result.strText;
				if (elemFor != null)
				{
					elemFor.title = result.strText;
				}
			}
		}
	}
}

