import cv
#from scipy import ndimage.label

import os,sys
import numpy as np
import cv2

#input_image = sys.argv[1]

#imcolor = cv.LoadImage(input_image ) # input image

#imcolor = cv.LoadImage('frontal_mid.jpg') # input image
#imcolor = cv.LoadImage('frontal_med.jpg') # input image
#imcolor = cv.LoadImage('face1.jpg') # input image


inVid = cv.CaptureFromCAM(0)
cv.SetCaptureProperty(inVid, cv.CV_CAP_PROP_FRAME_WIDTH,640)
cv.SetCaptureProperty(inVid, cv.CV_CAP_PROP_FRAME_HEIGHT,400)


imcolor = cv.QueryFrame(inVid)


#some optional args
do_inpaint_eyes = True
do_inpaint_mouth = True

#some hard coded args:
inpaint_thickness = 5 #num of pixels to inpaint around fitted boxes


# load the classifiers
haarFace = cv.Load('haarcascade_frontalface_default.xml')
#haarEyes = cv.Load('haarcascade_eye.xml')
#haarEyes = cv.Load('haarcascade_lefteye_2splits.xml')
haarEyesPair = cv.Load('haarcascade_mcs_eyepair_big.xml')
haarEyeSingle= cv.Load('eyeRight.xml')
haarEyeSingle = cv.Load('eyeLeft.xml')
haarMouth = cv.Load('haarcascade_mcs_mouth.xml')
# running the classifiers
storage1 = cv.CreateMemStorage()
storage2 = cv.CreateMemStorage()
storage3 = cv.CreateMemStorage()
storage4 = cv.CreateMemStorage()


while True:
    try:
        detectedFace = cv.HaarDetectObjects(imcolor, haarFace, storage1)
        imcolor = cv.QueryFrame(inVid)
        cnt=0
        # draw a green rectangle where the face is detected
        if detectedFace:
            #if face is in the centre (ignore others)
            for face in detectedFace:
                #print face
                print cv.GetSize(imcolor)
                #TODO .. only process face in centre of screen
                #if (face[0][0]+face[0][0]+face[0][2])/2.0 > cv.GetSize(imcolor)[0]/2.0-20 and (face[0][0]+face[0][0]+face[0][2])/2.0 > cv.GetSize(imcolor)[0]/2.0+20:

                cnt+=1
                roi = imcolor[face[0][1]:face[0][1]+face[0][3]+10,face[0][0]:face[0][0]+face[0][2]]
                dst = cv.CreateImage(cv.GetSize(roi), 8, 3);
                eye_mask = cv.CreateImage(cv.GetSize(roi), 8, 1);
                cv.Zero(eye_mask)
                mouth_mask = cv.CreateImage(cv.GetSize(roi), 8, 1);
                cv.Zero(mouth_mask)

                cv.Copy(roi, dst)
                dst2 = cv.CloneImage(dst)        
                detectedEyePair = cv.HaarDetectObjects(dst, haarEyesPair, storage2)
                detectedMouth = cv.HaarDetectObjects(dst, haarMouth, storage3)
                cv.Rectangle(imcolor,(face[0][0],face[0][1]),
                       (face[0][0]+face[0][2],face[0][1]+face[0][3]+10),
                       cv.RGB(0, 255, 0),2)

                print 'here'
                if detectedEyePair:
                    print 'yep'
                    for eyes in detectedEyePair:
                        #check only top half of image
                        if eyes[0][1]<cv.GetSize(roi)[1]/2.0:
                            #cv.Rectangle(dst,(eyes[0][0],eyes[0][1]),
                            #    (eyes[0][0]+eyes[0][2],eyes[0][1]+eyes[0][3]),
                            #     cv.RGB(255, 0, 0),1)
                            #cv.Rectangle(eye_mask,(eyes[0][0],eyes[0][1]),
                            #             (eyes[0][0]+eyes[0][2],eyes[0][1]+eyes[0][3]),
                            #             cv.RGB(255, 255, 255),inpaint_thickness)

                            roi_eye_pair = dst[eyes[0][1]-10:eyes[0][1]+eyes[0][3]+10,eyes[0][0]-10:eyes[0][0]+eyes[0][2]+10]
                            roi_eye_pair_unmarked = dst2[eyes[0][1]-10:eyes[0][1]+eyes[0][3]+10,eyes[0][0]-10:eyes[0][0]+eyes[0][2]+10]

                            #now detect left and right eyes individually WITHIN the eye pair range
                            detectedEyeSingle = cv.HaarDetectObjects(roi_eye_pair, haarEyeSingle, storage4)

                            eye_cnt = 0 # keep track of eyes found
                            #image to hold flipped eyes
                            finalFlippedEyes = cv.CreateImage(cv.GetSize(roi_eye_pair), 8, 3);
                            finalFlippedEyesOutline = cv.CreateImage(cv.GetSize(roi_eye_pair), 8, 1);

                            cv.Zero(finalFlippedEyes)
                            cv.Zero(finalFlippedEyesOutline)


                            for singleEye in detectedEyeSingle:  
                                eye_cnt+=1
                                if eye_cnt<3: #HACK! - only 'first' and 'second' eyes
                                    #mark once found
                                    #cv.Rectangle(roi_eye_pair,(singleEye[0][0]-3,singleEye[0][1]),
                                    #            (singleEye[0][0]+singleEye[0][2]+6,singleEye[0][1]+singleEye[0][3]),
                                    #             cv.RGB(255, 255, 0),1)      

                                    #mask to hold single eye data
                                    tmpSingleEyeMask = cv.CreateImage(cv.GetSize(roi_eye_pair), 8, 3);
                                    cv.Zero(tmpSingleEyeMask)

                                    #try ellipse fitting
                                    min_x = singleEye[0][0]
                                    max_x = min_x+singleEye[0][2]
                                    mid_x = (min_x+max_x)/2.0;
                                    min_y = singleEye[0][1]
                                    max_y = min_y+singleEye[0][3]
                                    mid_y = (min_y+max_y)/2.0;


                                    pts_array = np.array([[[min_x, mid_y]],[[mid_x, min_y]],
                                                            [[max_x,mid_y]],[[mid_x, max_y]],
                                                            [[mid_x, mid_y]]],'i')
                                    #print pts_array

                                    (center, size, angle) = cv.FitEllipse2(cv.fromarray(pts_array))

                                    # for some reason we need to convert (from float to int .. see docs)
                                    center = (cv.Round(center[0]), cv.Round(center[1]))
                                    size = (cv.Round(size[0] * 0.55), cv.Round(size[1] * 0.75))
                                    angle = -angle
                                    #done

                                    print center, size, angle
                                    cv.Ellipse(roi_eye_pair, center, size, angle, 0.0, 360.0, cv.RGB(1, 1, 1))
                                    cv.Ellipse(tmpSingleEyeMask, center, size, angle, 0.0, 360.0, cv.RGB(1, 1, 1))
                                    cv.Ellipse(finalFlippedEyesOutline, center, size, angle, 0.0, 360.0, 255, 3)

                                    #fill the region we want to use as mask        
                                    cv.FloodFill(tmpSingleEyeMask, center, (1,1,1))
                                    #threshold the mask to ones/zeros        

                                    tmpSingleEyeMasked = cv.CreateImage(cv.GetSize(roi_eye_pair), 8, 3);
                                    cv.Zero(tmpSingleEyeMasked)
                                    cv.Mul(roi_eye_pair, tmpSingleEyeMask, tmpSingleEyeMasked)


                                    try:
                                        ## elipse fitting works well.. now we need to get the data just in the elipse and manipulate that
                                        # get the rect that contains our eye
                                        
                                        ellipseEyeRegion = tmpSingleEyeMasked[int(center[1]-(size[0])):int(center[1]+(size[0])),
                                                                    int(center[0]-(size[1])):int(center[0]+(size[1]))]

                                        #flip the eye
                                        cv.Flip(ellipseEyeRegion,ellipseEyeRegion,0)

                                        #now add this to our blank canvas that will hold both eyes
                                        cv.Add(tmpSingleEyeMasked, finalFlippedEyes, finalFlippedEyes)
                                        this_trial = 1
                                    except:
                                        this_trial = 0
                                        pass

                if this_trial == 1:
                    #eyes are ready .. need to apply to original image
                    #first mask out the eye areas to zero so create mask
                    
                    finalFlippedEyesMask = cv.CloneImage(finalFlippedEyes)
                    tmp = cv.CloneImage(finalFlippedEyes)
                    cv.Zero(tmp)
                    grey=cv.CreateImage(cv.GetSize(finalFlippedEyes),8,1)
                    cv.CvtColor(finalFlippedEyesMask,grey,cv.CV_BGR2GRAY)
                    cv.Threshold(grey,grey,1,1,cv.CV_THRESH_BINARY_INV)
                    cv.Merge(grey,grey,grey,None,tmp)
                    print tmp
                    cv.Mul(tmp,roi_eye_pair_unmarked, finalFlippedEyesMask)

                    ## now add the flipped eyes to the masked bg
                    finEyesRegion = cv.CloneImage(finalFlippedEyes)
                    cv.Add(finalFlippedEyes, finalFlippedEyesMask, finEyesRegion)
                    if do_inpaint_eyes == 1:
                        cv.Inpaint(finEyesRegion, finalFlippedEyesOutline, finEyesRegion, 7, cv.CV_INPAINT_TELEA)


                if detectedMouth:
                    for mouth in detectedMouth:
                        #print mouth
                        if mouth[0][1]>cv.GetSize(roi)[1]/2.0:
                            #####if mouth[0][3]>eyes[0][1]/2.5: #magic: check proportion of mouth with to eye width
                            #cv.Rectangle(dst,(mouth[0][0],mouth[0][1]),
                            #         (mouth[0][0]+mouth[0][2],mouth[0][1]+mouth[0][3]),
                            #         cv.RGB(255, 255, 0),2)
                            cv.Rectangle(mouth_mask,(mouth[0][0],mouth[0][1]+0),
                                    (mouth[0][0]+mouth[0][2],mouth[0][1]+mouth[0][3]),
                                    cv.RGB(255, 255, 255),inpaint_thickness)
                            roi_mouth = dst[mouth[0][1]+0:mouth[0][1]+mouth[0][3]+0,mouth[0][0]:mouth[0][0]+mouth[0][2]]
                            cv.Flip(roi_mouth,roi_mouth,0)




            inpainted = cv.CreateImage(cv.GetSize(roi), 8, 3);




                

            cv.NamedWindow('Face Detection', cv.CV_WINDOW_AUTOSIZE)
            cv.NamedWindow('Face bit', cv.CV_WINDOW_AUTOSIZE)
            cv.NamedWindow('Face flipped', cv.CV_WINDOW_AUTOSIZE)
            #cv.NamedWindow('Inpaint Mask', cv.CV_WINDOW_AUTOSIZE)
            #cv.NamedWindow('inpainted image', cv.CV_WINDOW_AUTOSIZE)
            cv.NamedWindow('Just eyes', cv.CV_WINDOW_AUTOSIZE)
            #cv.NamedWindow('Mask', cv.CV_WINDOW_AUTOSIZE)
            #cv.NamedWindow('Masked', cv.CV_WINDOW_AUTOSIZE)
            #cv.NamedWindow('Final flipped eyes', cv.CV_WINDOW_AUTOSIZE)
            #cv.NamedWindow('Final flipped eyes Mask', cv.CV_WINDOW_AUTOSIZE)
            cv.NamedWindow('eye outline', cv.CV_WINDOW_AUTOSIZE)            


            if this_trial == 1:
                cv.NamedWindow('abs eyes', cv.CV_WINDOW_AUTOSIZE)

            if this_trial == 1:    
                cv.ShowImage('abs eyes', finEyesRegion)
                cv.ShowImage('eye outline', finalFlippedEyesOutline)                
                print 'start'
                myROI = dst[eyes[0][1]-10:eyes[0][1]+eyes[0][3]+10,eyes[0][0]-10:eyes[0][0]+eyes[0][2]+10]
                cv.Copy(finEyesRegion,myROI)# = finEyesRegion
                print 'end'


                if do_inpaint_mouth == 1:
                 cv.Inpaint(dst, mouth_mask, dst, 7, cv.CV_INPAINT_TELEA)
                

            #cv.ShowImage('Final flipped eyes Mask', finalFlippedEyesMask)
            #cv.ShowImage('Final flipped eyes', roi_eye_pair_unmarked)
            #cv.ShowImage('Mask', tmpSingleEyeMask)
            #cv.ShowImage('Masked', tmpSingleEyeMasked)
            cv.ShowImage('Just eyes', roi_eye_pair)
            cv.ShowImage('Face Detection', imcolor) 
            cv.ShowImage('Face bit', dst)
            #cv.SaveImage('%s_flipped.jpg' %input_image[:-4], dst)
            cv.Flip(dst,dst,0)
            #cv.SaveImage('%s_thatcher.jpg' %input_image[:-4], dst)
            cv.ShowImage('Face flipped', dst)
            #cv.ShowImage('Inpaint Mask', mouth_mask)
            #cv.ShowImage('inpainted image', inpainted)

            cv.WaitKey(5)
        else:
            pass
    except:
        pass

