% make a fake structure for simulated fmri data
%     simDat{1} = ['item1']
%     simDat{1}.impulse_ts = [zeros(1,10),ones(1,10),zeros(1,10)];
%     simDat{1}.noise = 1
%     simDat{1}.dispersion = 4
%     simDat{1}.location = [10,20,30]

%empty structure
simDat = {};

%add first 'blob' of activity
simDat{1} = ['item1']; 
simDat{1}.impulse_ts = repmat([zeros(1,10),ones(1,10)],1,10); 
simDat{1}.noise = 1;
simDat{1}.location = [10,20,10];
simDat{1}.dispersion = 3;

%add 2nd 'blob' of activity
simDat{2} = ['item2'];
simDat{2}.impulse_ts = repmat([ones(1,8),zeros(1,8)],1,15);
simDat{2}.impulse_ts = simDat{2}.impulse_ts(1:length(simDat{1}.impulse_ts)); %clip so that vectors are the same length
simDat{2}.impulse_ts = simDat{2}.impulse_ts*1.5; %scale relative to first signal
simDat{2}.noise = 1;
simDat{2}.location = [60,60,20];
simDat{2}.dispersion = 5;


%add 3rd 'blob' of activity
simDat{3} = ['item3 - quadratic']; 
simDat{3}.impulse_ts = repmat([zeros(1,10),ones(1,10).*1.0, ... %evt1 apmlitude 1.0
                               zeros(1,10),ones(1,10).*1.5, ... %evt2 relative to ev1 amplitude is 1.5
                               zeros(1,10),ones(1,10).*2.5, ... %evt3 relative to ev1 amplitude is 2.5
                               zeros(1,10),ones(1,10).*1.5, ... %evt4 relative to ev1 amplitude is 1.5
                               zeros(1,10),ones(1,10).*2.5], ... %evt5 relative to ev1 amplitude is 2.5
                               1,2); % .. and repeat the whole thing twice 
simDat{3}.noise = 1;
simDat{3}.location = [80,40,40];
simDat{3}.dispersion = 5;







