function [simData, myMat] = simulatefMRIData(voxelCount, TRcount, voxelSize, TR_duration, activityStructure)
%% simData = simulatefMRIData(voxelCount, TRcount, voxelSize, TR_duration, activityStructure)
% code to make a simulate fmri dataset 
%
% where:
%   voxelCount = [x, y, z] - number of voxels in each direction in a single
%                   volume
%
%   TRcount = number of TRs (must be same length as samples in stimus
%                   descriptors used in activityStructure
%
%   voxelSize = [x, y, z] - dims of single voxel in mm for nifti output
%
%   TR_duration = x in seconds for nifti output
%
%   activityStructure = a Matlab structure holding an array of desciptors
%                       as follows:
%                         simDat{1} = ['item1']
%                         simDat{1}.impulse_ts = [zeros(1,10),ones(1,10),zeros(1,10)];
%                         simDat{1}.noise = 'zeros(1,10)'
%                         simDat{1}.dispersion = 4
%                         simDat{1}.location = [10,20,30]

%% go!

%first create a noise matrix of the correct dimensions - noise between
%zero and one (not taking autocorrelation into account at all
myMat = rand(voxelCount(1), voxelCount(1), voxelCount(1), TRcount);

%%
% now imbed our required signals

for i = 1:length(activityStructure)
    %create a fake ideal timeseries by concolving the spm_hrf with the
    %impulse signal
    [simData{i}.ts, BFs] = ProduceEV(activityStructure{i}.impulse_ts, 1/TR_duration, 'spm', 0, length(activityStructure{i}.impulse_ts));
    % add some noise
    simData{i}.ts = simData{i}.ts(:,1) + (activityStructure{i}.noise .* rand(size(simData{i}.ts(:,1))));
    
    % calcualte where to insert
    activityStructure{i}.location
    
    xrange = activityStructure{i}.location(1) - activityStructure{i}.dispersion: activityStructure{i}.location(1) + activityStructure{i}.dispersion
    yrange = activityStructure{i}.location(2) - activityStructure{i}.dispersion: activityStructure{i}.location(2) + activityStructure{i}.dispersion
    zrange = activityStructure{i}.location(3) - activityStructure{i}.dispersion: activityStructure{i}.location(3) + activityStructure{i}.dispersion
    
    %now place the timeseries into the data matrix
    for x = 1:length(xrange)
        for y = 1:length(yrange)
            for z = 1:length(zrange)

                myMat(xrange(x), yrange(y), zrange(z), :) = simData{i}.ts(:,1) + (rand(1,length(simData{i}.ts)).*activityStructure{i}.noise)';
                
            end
        end
    end
    
end


%apply some smoothing to the output

for i = 1:size(myMat,4)
    i
    myMat(:,:,:,i) = smooth3(myMat(:,:,:,i),'gaussian');
end

myMat = myMat + 5000; %an arbitrary global signla offset common to MRI signals - i.e. not zero mean.


outData = make_nii(myMat,[2,2,2]);
outData.hdr.dime.datatype = 16; %float32
outData.hdr.dime.bitpix = 16; %float32
save_nii(outData,'./myFmri_noise');

disp('data saved to ./myFmri_noise.hdr');

                        



