function [desM, xBF] = ProduceEV(timeseries, samplingRate, hrf_method, derivative, numberOutputSamples)
% function [desM, xBF] = toolsBlinkProduceEV(timeseries, samplingRate, hrf_method, numberOutputSamples)
% 
% timeseries = a timeseries of events, e.g. a binarised vector [0 1 ..]
%   the length of the number of samples with 1 at the frame positions of
%   every blink
% 
% samplingRate = in Hz .. for video files thts would be the framerate e.g. 
%   30Hz,.. if using other predictors remember this has to be in Hz so you
%   may have to input 1/TR for fMRI data
% 
% hrf_method = string: 'spm' of 'boynton' for now .. NB the spm_hrf or 
%   boyntonHIRF function needs to be on your path 
%
% derivative = (optional) 0, 1 or 2: set to 1 if you wish to generate a 
%   derivative of the timeseries to add as an addional EV; set to 2 if you 
%   want derivative and dispersion EVs; set to 0 if only model EV is
%   required
%
% numberOutputSamples = (optional) default = 128  .. the final number of 
%   samples you want in your EV
%%
% NB a change here Sep 2012 - was sample first n samples instead of last n 


% lazy check in case timeseries vector is a column vector rathe than row
if size(timeseries,2) > 1
    if size(timeseries,1) == 1
        timeseries = timeseries';
        %disp('column vector received - transposed to row')
    else
        'I really want a 1xn (row) vector as input but can cope with nx1 .. looks like you gave me nxn .. cant handle that .. sorry'
        return
    end
end 
        

% check whihc hrf model to use
if strcmp(hrf_method, 'boynton') == 1
    % % FOR BOYNTON HRF MODEL
    hrf = boyntonHIRF([0:1/samplingRate:30]); %%TODO must parse more model options
    hrf = hrf';
elseif strcmp(hrf_method, 'spm') == 1
    %FOR SPM HRF MODEL (REQUIRES ynicInit spm8)

    %first we'll generate a standard spm xBF structure so that we can use 
    %  their code to generate the basis fucntions directly
    
    xBF.dt = 1/samplingRate;
    
    if derivative == 0
        xBF.name = 'hrf';
    elseif derivative == 1
        xBF.name = 'hrf (with time derivative)';
    elseif derivative == 2 
        xBF.name = 'hrf (with time and dispersion derivatives)';
    end
    
    xBF = spm_get_bf(xBF);
    
    %set the base hrf to the spm canonical hrf output
    hrf = xBF.bf(:,1);
    
    %figure;plot(hrf);
    
elseif strcmp(hrf_method, 'individual') == 1
    hrf = customHRF';
    xBF.dt = 1/samplingRate;
    xBF.bf(:,1) = hrf';
    
else
    disp('no suitable hrf model provided .. quitting here ... ');
    return
end



%use the base hrf to generate the initial convolved model
desM = conv2(timeseries, hrf,'full');
desM = desM(1:length(timeseries));

if derivative >= 1
    %use the spm temporal derivative here
    desMderiv = conv2(timeseries, xBF.bf(:,2), 'full');
    desMderiv = desMderiv(1:length(timeseries));
    desM = [desM, desMderiv];
    %disp('added hrf derivative convlolved with timeseries to model');    
end

if derivative >= 2
    %use the spm dispersion derivative here
    desMdisp = conv2(timeseries, xBF.bf(:,3), 'full');
    desMdisp= desMdisp(1:length(timeseries));
    desM = [desM, desMdisp];
    %disp('added dispersion derivative convlolved with timeseries to model');    
end
    

desM = [desM , ones(length(timeseries),1)];

if samplingRate == 30
    %disp('WARNING - you should check if convolution is correct for blinks!')
end

%downsample the desM if required
if size(desM,1) ~= numberOutputSamples
    %check that the desM is bigger than numberOutputSamples so we can
    % downsample
    if size(desM,1) < numberOutputSamples
        disp('cant donwnsample desM smaller than required samples')
        return
    else
        %TODO this will only work for 128 and 7680 for the monent or rather
        %only where desM is an integer multiple of numberOutputSamples
        sampling_factor = size(desM,1)/numberOutputSamples;
        desM = desM(1:sampling_factor:size(desM,1), :);
        %disp('downsampled input and convolved models to required number of samples');
    end
end


%figure; plot(desM); title('desm');
