#!/usr/bin/python

from flask import Flask, render_template, request, redirect, url_for 
import psycopg2 

from flask import Flask

from dbModule import connectToDB
from dbModule import executeQuery

from Module1 import app1

app = Flask(__name__) 

app.register_blueprint(app1)

debug = 1

@app.route('/campus') 
def campus(): 

	# Select all from the table 
	data = executeQuery('''SELECT * FROM campus''') 

	return render_template('campus.html', data=data) 


@app.route('/create', methods=['POST']) 
def create(): 

	# connect to db
	(conn, cur) = connectToDB() 

	# Get the data from the form 
	name = request.form['name'] 
	address = request.form['address']
	Institution_ID = request.form['Institution_ID']

	# Insert the data into the table 
	cur.execute( 
		'''INSERT INTO campus  
		(campus_name, campus_address, institution_id) VALUES (%s, %s, %s)''', 
		(name, address, Institution_ID)) 

	# commit the changes 
	conn.commit() 

	# close the cursor and connection 
	cur.close() 
	conn.close() 

	return redirect(url_for('campus')) 


@app.route('/update', methods=['POST']) 
def update(): 

	# connect to db
	(conn, cur) = connectToDB() 

	# Get the data from the form 
	name = request.form['name'] 
	address = request.form['address'] 
	I_ID = request.form['Institution_ID'] 
	id = request.form['Campus id'] 

	# Update the data in the table 

	if debug: print('''UPDATE campus SET campus_name=%s, 
		campus_address=%s WHERE campus_id=%s''', (name, address, id))

	cur.execute( 
		'''UPDATE campus SET campus_name=%s, 
		campus_address=%s WHERE campus_id=%s''', (name, address, id)) 

	# commit the changes 
	conn.commit() 
	return redirect(url_for('campus')) 


@app.route('/delete', methods=['POST']) 
def delete(): 

	# connect to db
	(conn, cur) = connectToDB() 

	# Get the data from the form 
	id = request.form['id'] 

	# Delete the data from the table 
	cur.execute('''DELETE FROM campus WHERE campus_id=%s''', (id,)) 

	# commit the changes 
	conn.commit() 

	# close the cursor and connection 
	cur.close() 
	conn.close() 

	return redirect(url_for('campus')) 


if __name__ == '__main__': 
	app.run(debug=True) 

