#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-
# generated by wxGlade 0.6.3 on Wed Sep 16 15:27:33 2009

import wx
import vtk
from vtk.wx.wxVTKRenderWindowInteractor import wxVTKRenderWindowInteractor



#utilities / modules for button panels

from dv3dKeyCapture import ProcessKey

from utils import *
import globalvar as globalvar
from buttonPanel_planes import *
from buttonPanel_volumes import *
from buttonPanel_refvol import *
from buttonPanel_functional import *
from buttonPanel_surfaces import *
from buttonPanel_markers import *
from buttonPanel_DTIFibers import *
from buttonPanel_colours import *
from buttonPanel_export import *
from buttonPanel_MEG import *
from buttonPanel_Misc import *
from buttonPanel_Threads import *

from common_functions import *

class ProcessKeyRoutine(ProcessKey):
    def __init__(self, parent, frame_parent):
        ProcessKey.__init__(self, parent, frame_parent)

class PlanesPage(PlanesTab):
    def __init__(self, parent, frame_parent):
        PlanesTab.__init__(self, parent, frame_parent)

class VolumesPage(VolumesTab):
    def __init__(self, parent, frame_parent):
        VolumesTab.__init__(self, parent, frame_parent)

class FunctionalPage(FunctionalTab):
    def __init__(self, parent, frame_parent):
        FunctionalTab.__init__(self, parent, frame_parent)

class SurfacesPage(SurfacesTab):
    def __init__(self, parent, frame_parent):
        SurfacesTab.__init__(self, parent, frame_parent)

class MarkersPage(MarkersTab):
    def __init__(self, parent, frame_parent):
        MarkersTab.__init__(self, parent, frame_parent)

class ColoursPage(ColoursTab):
    def __init__(self, parent, frame_parent):
        ColoursTab.__init__(self, parent, frame_parent)

class ExportPage(ExportTab):
    def __init__(self, parent, frame_parent):
        ExportTab.__init__(self, parent, frame_parent)

class MEGPage(MEGTab):
    def __init__(self, parent, frame_parent):
        MEGTab.__init__(self, parent, frame_parent)

class DTIFiber_page(DTIFiberTab):
    def __init__(self, parent, frame_parent):
        DTIFiberTab.__init__(self, parent, frame_parent)
        
class Threads_page(ThreadsTab):
    def __init__(self, parent, frame_parent):
        ThreadsTab.__init__(self, parent, frame_parent)

class REFVolPage(RefTab):
    def __init__(self, parent, frame_parent):
        RefTab.__init__(self, parent, frame_parent)

class MiscPage(MiscTab):
    def __init__(self, parent, frame_parent):
        MiscTab.__init__(self, parent, frame_parent)

class DataObjectTree(CreateObjectTree):
    def __init__(self, parent, frame_parent):
        CreateObjectTree.__init__(self, parent, frame_parent)
        
        

class DV3DFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: DV3DFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        
        #frame header information
        self.SetTitle("ynicDV3D v0.542 Beta")
        
        #do the core wx application window layout
        
        #the main background is a splitter window - splits into top half and bottom half of screen
        self.splitwindow_bg_horz = wx.SplitterWindow(self, -1, style=wx.SP_3DSASH)

        #sizers - place one in each of the compartments
        sizer_bg_all = wx.BoxSizer(wx.VERTICAL)
        sizer_bg_bottomhalf = wx.BoxSizer(wx.HORIZONTAL)
        sizer_bottomleft = wx.BoxSizer(wx.HORIZONTAL)
        sizer_bottomright = wx.BoxSizer(wx.HORIZONTAL)
        sizer_bg_tophalf = wx.BoxSizer(wx.HORIZONTAL)
        sizer_topright = wx.BoxSizer(wx.HORIZONTAL)
        sizer_topleft = wx.BoxSizer(wx.HORIZONTAL)

        self.SetSizer(sizer_bg_all)
        
        #place a panel on the top and one on the bottom half
        self.panel_bg_bottomhalf = wx.Panel(self.splitwindow_bg_horz, -1)
        self.panel_bg_tophalf = wx.Panel(self.splitwindow_bg_horz, -1)
        self.splitwindow_bg_horz.SplitHorizontally(self.panel_bg_tophalf, self.panel_bg_bottomhalf)
        sizer_bg_all.Add(self.splitwindow_bg_horz, 1, wx.EXPAND, 0)

 
        #split the top panel vertically and place a panel on the left and right
        self.splitwindow_upper_all = wx.SplitterWindow(self.panel_bg_tophalf, -1, style=wx.SP_3DSASH)
        sizer_bg_tophalf.Add(self.splitwindow_upper_all, 1, wx.EXPAND, 0)
        self.panel_topright = wx.Panel(self.splitwindow_upper_all, -1)
        self.panel_topleft = wx.Panel(self.splitwindow_upper_all, -1)
        self.splitwindow_upper_all.SplitVertically(self.panel_topleft, self.panel_topright)
        self.panel_bg_tophalf.SetSizer(sizer_bg_tophalf)
        
        #split the bottom panel vertically and place a panel on the left and right
        self.splitwindow_lower_all = wx.SplitterWindow(self.panel_bg_bottomhalf, -1, style=wx.SP_3D|wx.SP_BORDER)
        sizer_bg_bottomhalf.Add(self.splitwindow_lower_all, 1, wx.EXPAND, 0)
        self.panel_bottomleft = wx.Panel(self.splitwindow_lower_all, -1)
        self.panel_bottomright = wx.Panel(self.splitwindow_lower_all, -1)
        self.splitwindow_lower_all.SplitVertically(self.panel_bottomleft, self.panel_bottomright)
        self.panel_bg_bottomhalf.SetSizer(sizer_bg_bottomhalf)


        #place a text ctrl in the top left to display messages/information
        self.panel_topleft.SetSizer(sizer_topleft)
        self.textctrl_MsgBox = wx.TextCtrl(self.panel_topleft, -1, "", style=wx.TE_MULTILINE)
        sizer_topleft.Add(self.textctrl_MsgBox, 1, wx.EXPAND, 0)

        #place a notebook in the top left to hold our button panels
        self.panel_topright.SetSizer(sizer_topright)
        self.notebook_1 = wx.Notebook(self.panel_topright, -1, style=0)
        sizer_topright.Add(self.notebook_1, 1, wx.EXPAND, 0)
        #TODO .. set up the notebook
        
        # the notebook object

        ##1.) manipulating the main image planes
        #self.planes_page = PlanesPage(self.notebook_1, self)
        #self.notebook_1.AddPage(self.planes_page, "Planes")

        #1a.) volume rendering
        self.volumes_page = VolumesPage(self.notebook_1, self)
        self.notebook_1.AddPage(self.volumes_page, "Volumes")

        #2.) load a volume to reference against int real time
        self.ref_page = REFVolPage(self.notebook_1, self)
        self.notebook_1.AddPage(self.ref_page, "Reference")

        #3.) loading functional data
        self.functional_page = FunctionalPage(self.notebook_1, self)
        self.notebook_1.AddPage(self.functional_page, "Overlay")

        #4.) loading surface files
        self.surfaces_page = SurfacesPage(self.notebook_1, self)
        self.notebook_1.AddPage(self.surfaces_page, "Surfaces")

        #9.) DTI-Fiber data
        self.DTIFiber_page = DTIFiber_page(self.notebook_1, self)
        self.notebook_1.AddPage(self.DTIFiber_page, "Example: DTI Fibers")

        #10.) Threads_example
        self.Threads_page = Threads_page(self.notebook_1, self)
        self.notebook_1.AddPage(self.Threads_page, "Example: Threading")

        ##5.) placing markers
        #self.markers_page = MarkersPage(self.notebook_1, self)
        #self.notebook_1.AddPage(self.markers_page, "Markers")
        #
        ##6.) manipulating colours
        #self.colours_page = ColoursPage(self.notebook_1, self)
        #self.notebook_1.AddPage(self.colours_page, "Colours")

        ##7.) export routines
        #self.export_page = ExportPage(self.notebook_1, self)
        #self.notebook_1.AddPage(self.export_page, "Export")

        #8.) YNiC MEG
        self.MEG_page = MEGPage(self.notebook_1, self)
        self.notebook_1.AddPage(self.MEG_page, "MEG")

        ##9.) Misc items
        self.misc_page = MiscPage(self.notebook_1, self)
        self.notebook_1.AddPage(self.misc_page, "Misc")
        
        #place a TREE CTRL in the BOTTOM left to hold A LIST OF OUR OBJECTS
        self.panel_bottomleft.SetSizer(sizer_bottomleft)
        self.tree_ctrl_1 = wx.TreeCtrl(self.panel_bottomleft, -1, style=wx.TR_HAS_BUTTONS|wx.TR_DEFAULT_STYLE|wx.SUNKEN_BORDER)
        sizer_bottomleft.Add(self.tree_ctrl_1, 1, wx.EXPAND, 0)
        
        #PREPARE TO PLACE THE VTK WINDOW IN THE BOTTOM RIGHT
        self.panel_bottomright.SetSizer(sizer_bottomright)
        
        #lay out the main app window
        sizer_bg_all.Fit(self)
        self.Layout()


        self.widget = wxVTKRenderWindowInteractor(self.panel_bottomright ,-1)
        
        self.interactor_style = vtk.vtkInteractorStyleTrackballCamera()
        self.widget.SetInteractorStyle(self.interactor_style)

        #self.widget.AddObserver("ExitEvent", lambda o,e,f=MyFrame: sys.exit())

        #define the vtk renderer to do the drawing
        self.ren = vtk.vtkRenderer()
        ##self.ren.GetActiveCamera().ParallelProjectionOn()
        #self.ren.SetBackground(self.bg_cols[self.bg_col_index])

        #add the renderwindowinteractor to the wx application
        sizer_bottomright.Add(self.widget, 1, wx.EXPAND)

        self.widget.GetRenderWindow().AddRenderer(self.ren)
        
        t = vtk.vtkSphereSource()
        t.SetRadius(5)
        t.SetCenter(0,0,0)
        
        tt = vtk.vtkPolyDataMapper()
        tt.SetInput(t.GetOutput())
        
        ttt = vtk.vtkActor()
        ttt.SetMapper(tt)
        
        self.ren.AddActor(ttt)
        
        #now enable and initialise the vtk components
        self.widget.Enable(1)




# end of class DV3DFrame


if __name__ == "__main__":
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    frame_1 = DV3DFrame(None, -1, "")
    app.SetTopWindow(frame_1)
    frame_1.Show()
    app.MainLoop()
