import vtk

from dv3dObjectsToRender import *
from dv3dProbePropertyFrame import *
from dv3dExportPolyDataToDotVTKFile import *

def UseCurrentSurfaceAsDataProbe(frame_parent, the_surface, the_volume):

    LUT = the_volume[0].lookuptable
    
    new_LUT = vtk.vtkLookupTable()
    new_LUT2 = vtk.vtkLookupTable()
    #new_LUT.DeepCopy(LUT)

    my_cols = []
    my_cols.append([1,0.0468750000000000,0])
    my_cols.append([1,0.0937500000000000,0])
    my_cols.append([1,0.140625000000000,0])
    my_cols.append([1,0.187500000000000,0])
    my_cols.append([1,0.234375000000000,0])
    my_cols.append([1,0.281250000000000,0])
    my_cols.append([1,0.328125000000000,0])
    my_cols.append([1,0.375000000000000,0])
    my_cols.append([1,0.421875000000000,0])
    my_cols.append([1,0.468750000000000,0])
    my_cols.append([1,0.515625000000000,0])
    my_cols.append([1,0.562500000000000,0])
    my_cols.append([1,0.609375000000000,0])
    my_cols.append([1,0.656250000000000,0])
    my_cols.append([1,0.703125000000000,0])
    my_cols.append([1,0.750000000000000,0])
    my_cols.append([1,0.796875000000000,0])
    my_cols.append([1,0.843750000000000,0])
    my_cols.append([1,0.890625000000000,0])
    my_cols.append([1,0.937500000000000,0])
    my_cols.append([1,0.984375000000000,0])
    my_cols.append([0.968750000000000,1,0])
    my_cols.append([0.921875000000000,1,0])
    my_cols.append([0.875000000000000,1,0])
    my_cols.append([0.828125000000000,1,0])
    my_cols.append([0.781250000000000,1,0])
    my_cols.append([0.734375000000000,1,0])
    my_cols.append([0.687500000000000,1,0])
    my_cols.append([0.640625000000000,1,0])
    my_cols.append([0.593750000000000,1,0])
    my_cols.append([0.546875000000000,1,0])
    my_cols.append([0.500000000000000,1,0])
    my_cols.append([0.453125000000000,1,0])
    my_cols.append([0.406250000000000,1,0])
    my_cols.append([0.359375000000000,1,0])
    my_cols.append([0.312500000000000,1,0])
    my_cols.append([0.265625000000000,1,0])
    my_cols.append([0.218750000000000,1,0])
    my_cols.append([0.171875000000000,1,0])
    my_cols.append([0.125000000000000,1,0])
    my_cols.append([0.0781250000000000,1,0])
    my_cols.append([0.0312500000000000,1,0])
    my_cols.append([0,1,0.0156250000000000])
    my_cols.append([0,1,0.0625000000000000])
    my_cols.append([0,1,0.109375000000000])
    my_cols.append([0,1,0.156250000000000])
    my_cols.append([0,1,0.203125000000000])
    my_cols.append([0,1,0.250000000000000])
    my_cols.append([0,1,0.296875000000000])
    my_cols.append([0,1,0.343750000000000])
    my_cols.append([0,1,0.390625000000000])
    my_cols.append([0,1,0.437500000000000])
    my_cols.append([0,1,0.484375000000000])
    my_cols.append([0,1,0.531250000000000])
    my_cols.append([0,1,0.578125000000000])
    my_cols.append([0,1,0.625000000000000])
    my_cols.append([0,1,0.671875000000000])
    my_cols.append([0,1,0.718750000000000])
    my_cols.append([0,1,0.765625000000000])
    my_cols.append([0,1,0.812500000000000])
    my_cols.append([0,1,0.859375000000000])
    my_cols.append([0,1,0.906250000000000])
    my_cols.append([0,1,0.953125000000000])
    my_cols.append([0,1,1])
    my_cols.append([0,0.953125000000000,1])
    my_cols.append([0,0.906250000000000,1])
    my_cols.append([0,0.859375000000000,1])
    my_cols.append([0,0.812500000000000,1])
    my_cols.append([0,0.765625000000000,1])
    my_cols.append([0,0.718750000000000,1])
    my_cols.append([0,0.671875000000000,1])
    my_cols.append([0,0.625000000000000,1])
    my_cols.append([0,0.578125000000000,1])
    my_cols.append([0,0.531250000000000,1])
    my_cols.append([0,0.484375000000000,1])
    my_cols.append([0,0.437500000000000,1])
    my_cols.append([0,0.390625000000000,1])
    my_cols.append([0,0.343750000000000,1])
    my_cols.append([0,0.296875000000000,1])
    my_cols.append([0,0.250000000000000,1])
    my_cols.append([0,0.203125000000000,1])
    my_cols.append([0,0.156250000000000,1])
    my_cols.append([0,0.109375000000000,1])
    my_cols.append([0,0.0625000000000000,1])
    my_cols.append([0,0.0156250000000000,1])
    my_cols.append([0.0312500000000000,0,1])
    my_cols.append([0.0781250000000000,0,1])
    my_cols.append([0.125000000000000,0,1])
    my_cols.append([0.171875000000000,0,1])
    my_cols.append([0.218750000000000,0,1])
    my_cols.append([0.265625000000000,0,1])
    my_cols.append([0.312500000000000,0,1])
    my_cols.append([0.359375000000000,0,1])
    my_cols.append([0.406250000000000,0,1])
    my_cols.append([0.453125000000000,0,1])
    my_cols.append([0.500000000000000,0,1])
    my_cols.append([0.546875000000000,0,1])
    my_cols.append([0.593750000000000,0,1])
    my_cols.append([0.640625000000000,0,1])
    my_cols.append([0.687500000000000,0,1])
    my_cols.append([0.734375000000000,0,1])
    my_cols.append([0.781250000000000,0,1])
    my_cols.append([0.828125000000000,0,1])
    my_cols.append([0.875000000000000,0,1])
    my_cols.append([0.921875000000000,0,1])
    my_cols.append([0.968750000000000,0,1])
    my_cols.append([1,0,0.984375000000000])
    my_cols.append([1,0,0.937500000000000])
    my_cols.append([1,0,0.890625000000000])
    my_cols.append([1,0,0.843750000000000])
    my_cols.append([1,0,0.796875000000000])
    my_cols.append([1,0,0.750000000000000])
    my_cols.append([1,0,0.703125000000000])
    my_cols.append([1,0,0.656250000000000])
    my_cols.append([1,0,0.609375000000000])
    my_cols.append([1,0,0.562500000000000])
    my_cols.append([1,0,0.515625000000000])
    my_cols.append([1,0,0.468750000000000])
    my_cols.append([1,0,0.421875000000000])
    my_cols.append([1,0,0.375000000000000])
    my_cols.append([1,0,0.328125000000000])
    my_cols.append([1,0,0.281250000000000])
    my_cols.append([1,0,0.234375000000000])
    my_cols.append([1,0,0.187500000000000])
    my_cols.append([1,0,0.140625000000000])
    my_cols.append([1,0,0.0937500000000000])
    my_cols.append([1,0,0.0468750000000000])

    #here we do not want null values to be transparent
    new_LUT.SetNumberOfColors(len(my_cols)+4) 
    new_LUT.SetTableValue(0, (0.5,0.5,0.5,1.0))
    new_LUT.SetTableValue(1, (0.5,0.5,0.5,1.0))
    new_LUT.SetTableValue(2, (0.5,0.5,0.5,1.0))
    new_LUT.SetTableValue(3, (0.5,0.5,0.5,1.0))

    for i in range(4,len(my_cols)+4):
        new_LUT.SetTableValue(i,(my_cols[i-4][0],my_cols[i-4][1],my_cols[i-4][2],1.0))


    new_LUT.SetRampToLinear()
    new_LUT.SetValueRange(0,130)
    new_LUT.SetTableRange(0,130)
    new_LUT.Build()
    new_LUT.SetRampToLinear()


    
    a = the_surface.GetMapper()
    b = a.GetInput()
    
    # the really clever bit (thx VTK!) - wherever i have a datapoint on my
    # surface, go to thesame datapoint in the stat-volume and extract the
    # scalar value there- probe the data with spatial filter - ProbeFilter
    stat_probe = vtk.vtkProbeFilter()
    
    #stat_probe.SetInput(deci.GetOutput()) 
    stat_probe.SetInput(b) 
    stat_probe.SetSource(the_volume[0].volume_data.GetOutput())#.GetOutput())
    transform1 = vtk.vtkTransform()
    transform1.Scale(1.001, 1.001, 1.001)
    
    transformer1 = vtk.vtkTransformPolyDataFilter()
    transformer1.SetInput(stat_probe.GetOutput())
    transformer1.SetTransform(transform1)
    
    
    stat_contourMapper = vtk.vtkPolyDataMapper()
    stat_contourMapper.SetInput(transformer1.GetOutput())
    #stat_contourMapper.SetScalarRange(frame_parent.stat_vol.GetOutput().GetScalarRange()) #e.g. dynamically set the scalarrange based on values in the data
    print new_LUT.GetTableRange()
    stat_contourMapper.SetScalarRange(new_LUT.GetTableRange())
    #stat_contourMapper.GetLookupTable().SetTableValue(0, (0.5,0.5,0.5,1.0))
    stat_contourMapper.SetLookupTable(new_LUT)
    stat_contourMapper.SetColorModeToMapScalars()
    
    # set a colour bar for reference of scalar value mapping
    pos_scalarBar =  vtk.vtkScalarBarActor()
    pos_scalarBar.SetLookupTable(the_volume[0].lookuptable)
    pos_scalarBar.SetTitle('')
    pos_scalarBar.GetTitleTextProperty().SetFontSize(24)
    pos_scalarBar.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport()
    pos_scalarBar.GetPositionCoordinate().SetValue(0.05,0.75)
    pos_scalarBar.SetWidth(0.05)
    pos_scalarBar.SetHeight(0.2)
    pos_scalarBar.SetNumberOfLabels(5)
    pos_scalarBar.SetOrientationToVertical()
    
    sbw = vtk.vtkScalarBarWidget()
    sbw.SetScalarBarActor(pos_scalarBar)
    
    #now pass all our created and updated objects to the renderer
    stat_contourActor = vtk.vtkActor()
    stat_contourActor.SetMapper(stat_contourMapper)
    stat_contourActor.VisibilityOn()
    stat_contourActor.GetProperty().SetBackfaceCulling(0)
    
    
    dlg = wx.FileDialog(frame_parent, "Save your new surface file here:", "", "", ".vtk file|*.vtk", wx.SAVE)
        
    if dlg.ShowModal() == wx.ID_OK:
        file_to_save = dlg.GetPath()
    else:
        return
    
    frame_parent.applyVTKxfm = 0
    file_name = dv3dExportPolyDataToDotVTKFile(file_to_save, stat_contourActor, LUT)
    
    frame_parent.AutoLoadFileNow = file_name #TODO explain why - circular arg hack
    frame_parent.temp_LUT = new_LUT
    
    
