import vtk
import wx
from numpy import *
from stc_io import *
from dv3dFreeSurferLoad import *
import time
from dv3dObjectsToRender import *
import dv3dPropertyFrames
from dv3dFreeSurferLoad import *
from common_functions import align_all_planes

import dv3dSTC_ProbeShepardVolumeData


def loadSTC_bulk(the_parent_frame, sample_to_load):
    
    frame_parent = the_parent_frame
    stc_filename = '/home/andre/stc/StimOnset_Active_Low_white-lh.stc'
    surf_filename = '/home/andre/stc/lh.white'
    
    #sample_to_load = 0

    #stc_filename = '/home/andre/ind-lh.stc'
    #surf_filename = '/home/andre/ind.ynic'

    v,timeseries_data,start_ms,sample_ms = read_stc(stc_filename)
    vertices, triangles = read_fs_surf(surf_filename)
    
    #data=data*1000000
    
    print timeseries_data.shape

    scalar_verts = vertices[v]

    sc_points = vtk.vtkPoints()
    for i in range(len(scalar_verts)):
        sc_points.InsertPoint(i,scalar_verts[i,0],scalar_verts[i,1],scalar_verts[i,2])

    #full_points = vtk.vtkPoints()
    #for i in range(len(vertices)):
    #    full_points.InsertPoint(i,vertices[i,0],vertices[i,1],vertices[i,2]+100)    #offset 2 surfs so we can view simulataneously

    mm = timeseries_data.max()
    mmin = timeseries_data.min()
    print mm, mmin

            
    ######origMapper = vtk.vtkPolyDataMapper()
    ######origMapper.SetInput(profileA)
    ######origMapper.ScalarVisibilityOn()
    ######origActor = vtk.vtkActor()
    ######origActor.SetMapper(origMapper)
    ######origActor.VisibilityOn()
    ######the_parent_frame.ren.AddActor(origActor)
    ######origMapper.Update()
    ######origMapper.GetLookupTable().SetNumberOfTableValues(256000)
    ######origMapper.GetLookupTable().Build()
    ######origMapper.GetLookupTable().SetTableValue(0, (0.5,0.5,0.5,1.0))
    ######origMapper.GetLookupTable().SetTableValue(1, (1.0,0.0,0.0,1.0))
    ######origMapper.GetLookupTable().SetTableValue(255999, (0.0,0.0,1.0,1.0))
        
	
    ######origMapper.GetLookupTable().SetTableRange((mmin,mm))
    #######origMapper.GetLookupTable().Build()
    ######origMapper.Update()
            
    
    #gen fs surface
    polyData = get_surf_polyData (vertices, triangles)
    
    origMapper = vtk.vtkPolyDataMapper()
    origMapper.ImmediateModeRenderingOn()
    origMapper.SetInput(polyData)
    origMapper.Update()
    origSurface = vtk.vtkLODActor()
    origSurface.SetMapper(origMapper)
    
    Actor_to_add = prepareShepardVolume(frame_parent, sample_to_load, sc_points, timeseries_data, origSurface)
    Actor_to_add.VisibilityOff()
    the_parent_frame.st_act_list.append(Actor_to_add)
    Actor_to_add.VisibilityOff()
    the_parent_frame.ren.AddActor(Actor_to_add)

    #align_all_planes(the_parent_frame)


def prepareShepardVolume(frame_parent, sample_to_load, sc_points, timeseries_data, full_surface):
    
    mm = timeseries_data.max()
    
    sc_scalars = vtk.vtkFloatArray()
    for i in range(len(timeseries_data[:,sample_to_load])):
        val = timeseries_data[i,sample_to_load]/mm
        sc_scalars.InsertNextValue(val)
            
    scVertices = vtk.vtkPolyData()
    scVertices.SetPoints(sc_points)
    scVertices.GetPointData().SetScalars(sc_scalars)
    scVertices.Update()
    
    bounds = array(scVertices.GetBounds())
    bounds[0:6:2] =  bounds[0:6:2]-20
    bounds[1:7:2] =  bounds[1:7:2]+20
    
    shepard = vtk.vtkShepardMethod()
    shepard.SetInput(scVertices)
    shepard.SetModelBounds(bounds)
    shepard.SetMaximumDistance(0.1)
    shepard.SetNullValue(1)
    shepard.SetSampleDimensions(50, 50, 50)
    shepard.Update()

    updatedActor = dv3dSTC_ProbeShepardVolumeData.ProbeShepardVolume(frame_parent, full_surface, shepard.GetOutput())
    updatedActor.GetMapper().SetColorModeToMapScalars()
    return updatedActor