#!/usr/bin/env python

import wx
import sys
import vtk
from vtk.wx.wxVTKRenderWindowInteractor import wxVTKRenderWindowInteractor
from dv3dPlaneWidgets import *
import time
from common_functions import align_all_planes


class OrthoViews(wx.Frame):
    def __init__(self, frame_parent, f_number=0):#, plane1, plane2, plane3):
        wx.Frame.__init__(self, None, wx.ID_ANY, 'DV3D - Orthogonal Views')
        
        #so the main routine can update this window when required
        self.frame_parent = frame_parent
        
        # Add a panel so it looks the correct on all platforms
        self.panel = wx.Panel(self, wx.ID_ANY)
        bagSizer    = wx.GridBagSizer(hgap=5, vgap=5)

        #a properties panel
        self.properties_panel = wx.Panel(self.panel, wx.ID_ANY)
        
        self.Sync_with_main_window = wx.CheckBox(self.properties_panel , -1, 'Auto update? (slower)')
        self.Sync_with_main_window.SetValue(False)
        self.Sync_with_main_window.Bind(wx.EVT_CHECKBOX, self.OnSync_with_main_window,
              id=-1)

        self.L_R_flip = wx.CheckBox(self.properties_panel , -1, 'L_R_flip', pos = (0,90))
        self.L_R_flip.SetValue(False)
        self.L_R_flip.Bind(wx.EVT_CHECKBOX, self.OnL_R_flip ,
              id=-1) 

        self.enable_planes = wx.CheckBox(self.properties_panel , -1, 'Enable plane interaction', pos = (0,60))
        self.enable_planes.SetValue(False)
        self.enable_planes.Bind(wx.EVT_CHECKBOX, self.OnEnable_planes ,
              id=-1)        

        self.Manual_sync_with_main_window = wx.Button(self.properties_panel , -1, 'Manually update now', pos = (0,30))
        self.Manual_sync_with_main_window.Bind(wx.EVT_BUTTON, self.OnManual_sync_with_main_window,
              id=-1)
        self.Manual_sync_with_main_window.Enable(1)

        
        #the vtk stuff
        self.widget = wxVTKRenderWindowInteractor(self.panel, -1)
    
        self.picker = vtk.vtkCellPicker()        

        orthoWidget = create_new_planewidget(self.widget,                              \
                                            self.frame_parent.my_loaded_volumes[0][0].volume_data.GetOutput(),                                   \
                                            self.frame_parent.slice_pos[f_number],   \
                                            f_number,self.picker,0,self.frame_parent)
        orthoWidget.SetLookupTable(self.frame_parent.ListOfObjects[0].GetLookupTable())

        self.frame_parent.ortho_planes.append(orthoWidget)

        self.plane = orthoWidget       
        
        
        self.plane.SetInteractor(self.widget)
       
        self.ortho_ren = vtk.vtkRenderer()
        self.ortho_ren.GetActiveCamera().ParallelProjectionOn()
        
        self.frame_parent.ortho_ren.append(self.ortho_ren)
        
        self.widget.Enable()

        self.widget.GetRenderWindow().AddRenderer(self.ortho_ren)
        self.widget.GetRenderWindow().SetSize(300,300)

        self.interactor_style = vtk.vtkInteractorStyleTrackballCamera()

        self.widget.SetInteractorStyle(self.interactor_style)

        self.plane.On()         
       
        self.widget.AddObserver("ExitEvent", lambda o,e,f=self: f.Close())


        bagSizer.Add(self.widget, pos=(0,0),
                     flag=wx.EXPAND,
                     border=5)
        
        bagSizer.Add(self.properties_panel, pos=(0,1))    
        

        bagSizer.AddGrowableCol(0)
        bagSizer.AddGrowableCol(1)
        bagSizer.AddGrowableRow(0)
        bagSizer.AddGrowableRow(1)
                
        bounds = self.frame_parent.my_loaded_volumes[0][0].data_bounds
        
        self.midx = (bounds[1]-bounds[0])/2
        self.midy = (bounds[3]-bounds[2])/2
        self.midz = (bounds[5]-bounds[4])/2
        
        if f_number == 0:
            cur_cam = self.ortho_ren.GetActiveCamera()
            cur_cam.SetPosition(1000, self.midy, self.midz)
            cur_cam.SetFocalPoint(self.midx, self.midy, self.midz)
            cur_cam.SetViewUp(0,0,1)
        elif f_number == 2:
            cur_cam = self.ortho_ren.GetActiveCamera()
            cur_cam.SetPosition(self.midx, self.midy, -1000)
            cur_cam.SetFocalPoint(self.midx, self.midy, self.midz)
            cur_cam.SetViewUp(0,1,0)
        elif f_number == 1:        
            cur_cam = self.ortho_ren.GetActiveCamera()
            cur_cam.SetPosition(self.midx, 1000, self.midz)
            cur_cam.SetFocalPoint(self.midx, self.midy, self.midz)
            cur_cam.SetViewUp(0,0,1)
        
        self.ortho_ren.ResetCamera()  
        self.widget.Render()

        
        self.widget.Disable()
        
        self.panel.SetSizer(bagSizer)
       
        # SetSizeHints(minW, minH, maxW, maxH)
        #self.SetSizeHints(400,400,750,750)
        self.SetSizeHints(400,400)
        bagSizer.Fit(self)
        
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
        self.frame_parent.SYNC_ortho = 0

    def OnL_R_flip(self, event):
        if self.L_R_flip.GetValue() == True:
            cur_cam = self.ortho_ren2.GetActiveCamera()
            cur_cam.SetPosition(self.midx, self.midy, +1000)
            self.ortho_ren2.ResetCamera()
            cur_cam = self.ortho_ren3.GetActiveCamera()
            cur_cam.SetPosition(self.midx, -1000, self.midz)
            self.ortho_ren3.ResetCamera()

        else:
            cur_cam = self.ortho_ren2.GetActiveCamera()
            cur_cam.SetPosition(self.midx, self.midy, -1000)
            self.ortho_ren2.ResetCamera()
            cur_cam = self.ortho_ren3.GetActiveCamera()
            cur_cam.SetPosition(self.midx, 1000, self.midz)
            self.ortho_ren3.ResetCamera()


        self.widget.Render()
    
    def OnEnable_planes(self, event):
        if self.enable_planes.GetValue() == True:
            self.widget.Enable()
        else:
            self.widget.Disable()


    def OnSync_with_main_window(self, event):
        if self.Sync_with_main_window.GetValue() == True:
            self.frame_parent.SYNC_ortho = 1
            self.Manual_sync_with_main_window.Enable(0)
        else:
            self.frame_parent.SYNC_ortho = 0
            self.Manual_sync_with_main_window.Enable(1)
            
    def OnManual_sync_with_main_window(self, event):
        self.ortho_ren.ResetCamera()  
        self.widget.Render()



    def OnCloseWindow(self, event):
        try:
            # pass False to the close routine to veto the attempt to close
            #  the window .. only close it when the main app widow closes
            self.Close(0)
        except:
            pass #sys.exit()
