import vtk

def extract_rough_cortex(value, vol):

        brain_volume = vol.GetOutput()
        brain_volume.Update()

        isoSurfaceExtractor = vtk.vtkContourFilter()
        isoSurfaceExtractor.SetInput(brain_volume)
        isoSurfaceExtractor.SetValue(0, value)
        isoSurfaceExtractor.ComputeGradientsOn()
        isoSurfaceExtractor.UseScalarTreeOn()
        surfNormals = vtk.vtkPolyDataNormals()
        surfNormals.SetInput(isoSurfaceExtractor.GetOutput())
        surfNormals.SetFeatureAngle(60.0)
        
        conn = vtk.vtkPolyDataConnectivityFilter()        
        conn.SetInput(surfNormals.GetOutput())
        conn.SetExtractionModeToLargestRegion()
        conn.Update()
        
        deci = vtk.vtkDecimatePro()
        deci.SetInput(conn.GetOutput())
        deci.PreserveTopologyOff()
        deci.SetTargetReduction(0.9)
        deci.Update()
        
        surfMapper = vtk.vtkPolyDataMapper()
        surfMapper.SetInput(deci.GetOutput())
        surfMapper.ScalarVisibilityOff()
        surfMapper.Update()
        surf = vtk.vtkActor()
        surf.GetProperty().SetLineWidth(0.005) 
        surf.SetMapper(surfMapper)
        
        return surf,deci,conn
