import vtk
import time


#? redundant - saving to memeory now and writing out later
#def WriteImageStream(frame_parent):
#    '''A routine to output a real-time stream of images captured
#    from the main vtk window. Polls counters and functions is the
#    parent frame and sets the required output directory
#    '''
#    
#    fname = '%s/my_%06d.jpg' %(frame_parent.write_imagestream_directory,
#                               frame_parent.write_imagestream_count)
#
#    #frame_parent.w2i.Update()
#    frame_parent.w2i.Modified()
#    frame_parent.writer.SetInput(frame_parent.w2i.GetOutput())
#    frame_parent.writer.SetFileName(fname)
#    frame_parent.writer.Write()
#    
#    frame_parent.write_imagestream_count += 1


def WriteImageStream_buffered(frame_parent):
    '''A routine to output a real-time stream of images captured
    from the main vtk window. Polls counters and functions is the
    parent frame and sets the required output directory
    '''
    
    #tell the writer in the main program that its content has been updated
    frame_parent.w2i.Modified()
    frame_parent.w2i.Update()
    
    #create a temporary new copy of the object so that there are no
    # data sharing conflicts - this allows us to store the content of
    # the window as a picture we will write out later (writing out later
    # means that we can allow the rendering to remain fast)
    t = vtk.vtkImageData()
    t.DeepCopy(frame_parent.w2i.GetOutput())
    t.Update()
    
    # append the newly captured image to the placeholder list
    frame_parent.stream_image_list.append(t)
    frame_parent.export_page.ImageStreamFrameCount.SetLabel('Frame count = %05.0f' \
                                                   %len(frame_parent.stream_image_list))


def WriteImageStream_buffered_WriteNow(frame_parent):
    # write each of the buffered images out
    for i in range(len(frame_parent.stream_image_list)):
        
        fname = '%s/my_%06d.jpg' %(frame_parent.write_imagestream_directory,
                                   frame_parent.write_imagestream_count)
        
        print 'writing image %d to %s' %(i, fname)
        
        frame_parent.writer.SetInput(frame_parent.stream_image_list[i])
        frame_parent.writer.SetFileName(fname)
        frame_parent.writer.Write()
        
        frame_parent.write_imagestream_count += 1
        
    #and clear out the temporary buffer list to save memory
    frame_parent.stream_image_list = []
    frame_parent.export_page.ImageStreamFrameCount.SetLabel('All frames written.')
    
    
    
    
