import vtk
import wx

def writeAVI(the_frame_parent):

    filename = ChooseFile(the_frame_parent, '*.avi*')    
    
    if filename == 'cancelled':
        print 'Movie export cancelled by user ...'
        return
    else:
        if filename[-4] != '.avi':
            filename = filename + '.avi'
        
        ren = the_frame_parent.ren
        widget = the_frame_parent.widget
        window = ren.GetRenderWindow()
    
        w2i = vtk.vtkWindowToImageFilter()
        w2i.SetInput(window)
    
        w = vtk.vtkAVIWriter()
        w.SetFileName(filename);
        w.SetInputConnection(w2i.GetOutputPort())
        print 'Writing file %s...' %filename
        w.Start()
        for i in range(180):
            cam = ren.GetActiveCamera()
            cam.Azimuth(2)
            #renWin.SetSize(2300,2300)
            w2i.Modified()
        
            w.Write()
        w.End()

def ChooseFile(the_frame_parent, my_filetypes):
    dlg = wx.FileDialog(the_frame_parent, 'Save file as:', '', '', my_filetypes, wx.SAVE)
    if dlg.ShowModal() == wx.ID_OK:
        path = dlg.GetPath()
        return path
    else:
        return 'cancelled'