
import wx
import os

import globalvar as globalvar
from utils import *

from dv3dDialogs import *
from dv3dPolydataClipper import *


class SurfacesTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent

        LoadExternalSurface = wx.Button(self, -1, 'Load a surface file ', (20,10))
        self.Bind(wx.EVT_BUTTON, self.OnLoadButton, LoadExternalSurface)

        GenerateSurface = wx.Button(self, -1, 'Generate a surface file from current data', (20,40))
        self.Bind(wx.EVT_BUTTON, self.OnGenerateButton, GenerateSurface)
        
        CreateClippedSurface = wx.Button(self, -1, 'Create a clipped surface', (20,70))
        self.Bind(wx.EVT_BUTTON, self.OnCreateClippedSurfaceButton, CreateClippedSurface)
        
        ExportSurface = wx.Button(self, -1, 'Export a surface', (350,10))
        self.Bind(wx.EVT_BUTTON, self.OnExportSurfaceButton, ExportSurface)

        MNIGlassBrainSurface = wx.Button(self, -1, 'Load MNI glass brain', (350,40))
        self.Bind(wx.EVT_BUTTON, self.OnMNIGlassBrainSurfaceButton, MNIGlassBrainSurface)


    def OnMNIGlassBrainSurfaceButton(self, evt):
        frame = MyDialogFrame(self.frame_parent, 'DialogMNIGlassBrainSurface')
        frame.Show(True)

    def OnExportSurfaceButton(self, evt):
        frame = MyDialogFrame(self.frame_parent, 'DialogSurfaceExport')
        frame.Show(True)

    def OnCreateClippedSurfaceButton(self, evt):
        pass
        #AddPolyDataClipper(self.frame_parent, -1)#index_to_PolyData)
        
    def OnLoadButton(self, evt):
        frame = MyDialogFrame(self.frame_parent, 'DialogSurfaceSelection')
        frame.Show(True)
        
    def OnGenerateButton(self, evt):
        frame = MyDialogFrame(self.frame_parent, 'DialogSurfaceGenerate')
        frame.Show(True)
