
import wx
import os

import globalvar as globalvar
from utils import *
from dv3dGeneratePositionMarker import GeneratePositionMarker
from dv3dLoadMarkerList import *

class MarkersTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)
        
        self.frame_parent = frame_parent
        
        self.text_ctrl_explanation = wx.TextCtrl(self, -1, "pressing the 'm' button on your keyboard will place a marker underneath the current mouse position in the main window (i.e. at the first surface / object below the mouse pointer)", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.NO_BORDER)
        self.panel_11 = wx.Panel(self, -1)
        self.label_slice_position = wx.StaticText(self, -1, "Slice position")
        self.panel_12 = wx.Panel(self, -1)
        self.x_label_slice = wx.StaticText(self, -1, "x")
        self.text_ctrl_x_slice = wx.TextCtrl(self, -1, "")
        self.panel_6 = wx.Panel(self, -1)
        self.y_label_slice = wx.StaticText(self, -1, "y")
        self.text_ctrl_y_slice = wx.TextCtrl(self, -1, "")
        self.panel_5 = wx.Panel(self, -1)
        self.z_label_slice = wx.StaticText(self, -1, "z")
        self.text_ctrl_z_slice = wx.TextCtrl(self, -1, "")
        self.panel_4 = wx.Panel(self, -1)
        self.panel_2 = wx.Panel(self, -1)
        self.button_project_slice_marker = wx.Button(self, -1, "Place")
        self.Bind(wx.EVT_BUTTON, self.OnProjectSlice, self.button_project_slice_marker)
        self.panel_3 = wx.Panel(self, -1)
        self.panel_13 = wx.Panel(self, -1)
        self.label_4 = wx.StaticText(self, -1, "mm position")
        self.panel_14 = wx.Panel(self, -1)
        self.label_x_mm = wx.StaticText(self, -1, "x")
        self.text_ctrl_x_mm = wx.TextCtrl(self, -1, "")
        self.panel_10 = wx.Panel(self, -1)
        self.label_y_mm = wx.StaticText(self, -1, "y")
        self.text_ctrl_y_mm = wx.TextCtrl(self, -1, "")
        self.panel_9 = wx.Panel(self, -1)
        self.label_z_mm = wx.StaticText(self, -1, "z")
        self.text_ctrl_z_mm = wx.TextCtrl(self, -1, "")
        self.panel_8 = wx.Panel(self, -1)
        self.panel_1 = wx.Panel(self, -1)
        self.button_project_mm_marker = wx.Button(self, -1, "Place")
	self.panel_21 = wx.Panel(self, -1)
	self.button_load_marker_list = wx.Button(self, -1, "Load list")
	self.Bind(wx.EVT_BUTTON, self.OnLoadList, self.button_load_marker_list)
        #TODO for now#
        self.button_project_mm_marker.Disable()
        self.panel_7 = wx.Panel(self, -1)
        #self.SetTitle("frame_1")
        self.text_ctrl_explanation.SetMinSize((150, 295))
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        grid_sizer_mm = wx.FlexGridSizer(5, 3, 3, 3)
        grid_sizer_slice = wx.FlexGridSizer(5, 3, 3, 3)
	grid_sizer_misc = wx.FlexGridSizer(5, 3, 3, 3)
        sizer_2.Add(self.text_ctrl_explanation, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.panel_11, 1, wx.EXPAND, 0)
        grid_sizer_slice.Add(self.label_slice_position, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.panel_12, 1, wx.EXPAND, 0)
        grid_sizer_slice.Add(self.x_label_slice, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.text_ctrl_x_slice, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.panel_6, 1, wx.EXPAND, 0)
        grid_sizer_slice.Add(self.y_label_slice, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.text_ctrl_y_slice, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.panel_5, 1, wx.EXPAND, 0)
        grid_sizer_slice.Add(self.z_label_slice, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.text_ctrl_z_slice, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.panel_4, 1, wx.EXPAND, 0)
        grid_sizer_slice.Add(self.panel_2, 1, wx.EXPAND, 0)
        grid_sizer_slice.Add(self.button_project_slice_marker, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_slice.Add(self.panel_3, 1, wx.EXPAND, 0)
        sizer_2.Add(grid_sizer_slice, 0, wx.EXPAND, 0)
        grid_sizer_mm.Add(self.panel_13, 1, wx.EXPAND, 0)
        grid_sizer_mm.Add(self.label_4, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.panel_14, 1, wx.EXPAND, 0)
        grid_sizer_mm.Add(self.label_x_mm, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.text_ctrl_x_mm, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.panel_10, 1, wx.EXPAND, 0)
        grid_sizer_mm.Add(self.label_y_mm, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.text_ctrl_y_mm, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.panel_9, 1, wx.EXPAND, 0)
        grid_sizer_mm.Add(self.label_z_mm, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.text_ctrl_z_mm, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.panel_8, 1, wx.EXPAND, 0)
        grid_sizer_mm.Add(self.panel_1, 1, wx.EXPAND, 0)
        grid_sizer_mm.Add(self.button_project_mm_marker, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_mm.Add(self.panel_7, 1, wx.EXPAND, 0)
        sizer_2.Add(grid_sizer_mm, 0, wx.EXPAND, 0)
	grid_sizer_misc.Add(self.panel_21, 1, wx.EXPAND, 0)
	grid_sizer_misc.Add(self.button_load_marker_list, 0, wx.ADJUST_MINSIZE, 0)
	sizer_2.Add(grid_sizer_misc, 0, wx.EXPAND, 0)
        sizer_1.Add(sizer_2, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        self.Layout()

   
    def OnLoadList (self, evt):
	LoadMarkerList(self.frame_parent)

    def OnProjectSlice(self, evt):
        x = float(self.text_ctrl_x_slice.GetValue())
        y = float(self.text_ctrl_y_slice.GetValue())
        z = float(self.text_ctrl_z_slice.GetValue())
        
        GeneratePositionMarker(self.frame_parent, x, y, z)
