import wx
import time

from dv3dDialogs import *
from dv3dLoadTMSCoil import *
from dv3dGeneratePositionMarker import *
from dv3dCustomWXControls import *


class MiscTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        
        self.AddTMSCoilButton = wx.Button(self, -1, 'Add TMS Coil', (15,15))
        self.Bind(wx.EVT_BUTTON, self.OnAddTMSCoilButton, self.AddTMSCoilButton)

        self.AddPositionMarkerButton = wx.Button(self, -1, 'Add Marker', (15,60))
        self.Bind(wx.EVT_BUTTON, self.OnAddPositionMarkerButton, self.AddPositionMarkerButton)
        
        self.sliderXtranslate = VariableSlider(id=1, maxValue=1000,
              minValue=-1000, name='slider1', parent=self, pos=wx.Point(200,
              24), size=wx.Size(180, 16), style=wx.SL_VERTICAL, value=0)
        self.sliderXtranslate.Bind(EVT_V_SLIDER, self.sliderXt)

        self.sliderYtranslate = VariableSlider(id=1, maxValue=1000,
              minValue=-1000, name='slider1', parent=self, pos=wx.Point(200,
              48), size=wx.Size(180, 16), style=wx.SL_VERTICAL, value=0)
        self.sliderYtranslate.Bind(EVT_V_SLIDER, self.sliderYt)
        
        self.sliderZtranslate = VariableSlider(id=1, maxValue=1000,
              minValue=-1000, name='slider1', parent=self, pos=wx.Point(200,
              72), size=wx.Size(180, 16), style=wx.SL_VERTICAL, value=0)
        self.sliderZtranslate.Bind(EVT_V_SLIDER, self.sliderZt)
        
        self.sliderXRotate = VariableSlider(id=1, maxValue=1000,
              minValue=-1000, name='slider1', parent=self, pos=wx.Point(400,
              24), size=wx.Size(180, 16), style=wx.SL_VERTICAL, value=0)
        self.sliderXRotate.Bind(EVT_V_SLIDER, self.sliderXr)
        
        self.sliderYRotate = VariableSlider(id=1, maxValue=1000,
              minValue=-1000, name='slider1', parent=self, pos=wx.Point(400,
              48), size=wx.Size(180, 16), style=wx.SL_VERTICAL, value=0)
        self.sliderYRotate.Bind(EVT_V_SLIDER, self.sliderYr)
        
        self.sliderZRotate = VariableSlider(id=1, maxValue=1000,
              minValue=-1000, name='slider1', parent=self, pos=wx.Point(400,
              72), size=wx.Size(180, 16), style=wx.SL_VERTICAL, value=0)
        self.sliderZRotate.Bind(EVT_V_SLIDER, self.sliderZr)


    def sliderXt(self, evt):
        self.ApplyXFM('Xt')

    def sliderYt(self, evt):
        self.ApplyXFM('Yt')
        
    def sliderZt(self, evt):
        self.ApplyXFM('Zt')
    
    def sliderXr(self, evt):
        self.ApplyXFM('Xr')    

    def sliderYr(self, evt):
        self.ApplyXFM('Yr')

    def sliderZr(self, evt):
        self.ApplyXFM('Zr')

    def ApplyXFM(self, type_of_call):
        
        
        if type_of_call == 'Xt':
            rot_val = -(self.sliderXtranslate.GetValue()/100.0)
        elif type_of_call == 'Yt':
            rot_val = -(self.sliderYtranslate.GetValue()/100.0)
        elif type_of_call == 'Zt':
            rot_val = -(self.sliderZtranslate.GetValue()/100.0)
        elif type_of_call == 'Xr':
            rot_val = -(self.sliderXRotate.GetValue()/100.0)
        elif type_of_call == 'Yr':
            rot_val = -(self.sliderYRotate.GetValue()/100.0)
        elif type_of_call == 'Zr':
            rot_val = -(self.sliderZRotate.GetValue()/100.0)
        else:
            return
                
        
        self.frame_parent.TMS_Widget.GetTransform(self.frame_parent.tms_transform)
        try:
            self.frame_parent.curr_tms_transform
            if type_of_call == 'Xt':
                self.frame_parent.curr_tms_transform.Translate(rot_val,0,0)
            elif type_of_call == 'Yt':
                self.frame_parent.curr_tms_transform.Translate(0,rot_val,0)
            elif type_of_call == 'Zt':
                self.frame_parent.curr_tms_transform.Translate(0,0,rot_val)
            elif type_of_call == 'Xr':
                self.frame_parent.curr_tms_transform.RotateX(rot_val)
            elif type_of_call == 'Yr':
                self.frame_parent.curr_tms_transform.RotateY(rot_val)
            elif type_of_call == 'Zr':
                self.frame_parent.curr_tms_transform.RotateZ(rot_val)
            else:
                return
        
        except:
            self.frame_parent.curr_tms_transform = vtk.vtkTransform()
            self.frame_parent.curr_tms_transform.SetMatrix(self.frame_parent.tms_transform.GetMatrix())
            if type_of_call == 'Xt':
                self.frame_parent.curr_tms_transform.Translate(rot_val,0,0)
            elif type_of_call == 'Yt':
                self.frame_parent.curr_tms_transform.Translate(0,rot_val,0)
            elif type_of_call == 'Zt':
                self.frame_parent.curr_tms_transform.Translate(0,0,rot_val)
            elif type_of_call == 'Xr':
                self.frame_parent.curr_tms_transform.RotateX(rot_val)
            elif type_of_call == 'Yr':
                self.frame_parent.curr_tms_transform.RotateY(rot_val)
            elif type_of_call == 'Zr':
                self.frame_parent.curr_tms_transform.RotateZ(rot_val)
            else:
                return
            
        self.frame_parent.tms_transform.PostMultiply()
        self.frame_parent.tms_transform.Concatenate(self.frame_parent.curr_tms_transform.GetMatrix())
        
        
        self.frame_parent.tmsActor.SetUserTransform(self.frame_parent.tms_transform)
        self.frame_parent.widget.Render()
        self.frame_parent.ray_transform.SetMatrix(self.frame_parent.ray_transform_origmatrix)
        self.frame_parent.ray_transform.PostMultiply()
        self.frame_parent.ray_transform.Concatenate(self.frame_parent.tms_transform.GetMatrix())
        self.frame_parent.rayActor.SetUserTransform(self.frame_parent.ray_transform)
        
        

    def OnAddTMSCoilButton(self, evt):
        LoadTMSCoil(self.frame_parent)


    def OnAddPositionMarkerButton(self, evt):
        GeneratePositionMarker(self.frame_parent)
        
    