#!/usr/bin/env python

# This is a simple volume rendering example that uses a
# vtkVolumeRayCast mapper

import vtk

from dv3dNifti2VtkImageData import *

#vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('/home/andre/retinotopic_3d/DR/8ui_DR_3dAnat.nii.gz')
#!/usr/bin/env python

vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('/scratch/home/andre/8UI_zstat1.nii.gz')

########


# Create the standard renderer, render window and interactor
ren = vtk.vtkRenderer()
renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren)
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)

# Create transfer mapping scalar value to opacity
opacityTransferFunction = vtk.vtkPiecewiseFunction()
opacityTransferFunction.AddPoint(20, 0.0)
opacityTransferFunction.AddPoint(255, 0.2)

# Create transfer mapping scalar value to color
colorTransferFunction = vtk.vtkColorTransferFunction()
colorTransferFunction.AddRGBPoint(0.0, 0.0, 0.0, 0.0)
colorTransferFunction.AddRGBPoint(64.0, 1.0, 0.0, 0.0)
colorTransferFunction.AddRGBPoint(128.0, 0.0, 0.0, 1.0)
colorTransferFunction.AddRGBPoint(192.0, 0.0, 1.0, 0.0)
colorTransferFunction.AddRGBPoint(255.0, 0.0, 0.2, 0.0)

# The property describes how the data will look
volumeProperty = vtk.vtkVolumeProperty()
volumeProperty.SetColor(colorTransferFunction)
volumeProperty.SetScalarOpacity(opacityTransferFunction)
volumeProperty.ShadeOn()
volumeProperty.SetInterpolationTypeToLinear()

# The mapper / ray cast function know how to render the data
compositeFunction = vtk.vtkVolumeRayCastCompositeFunction()
compositeFunction.SetCompositeMethodToInterpolateFirst()
volumeMapper = vtk.vtkVolumeRayCastMapper()
volumeMapper.SetVolumeRayCastFunction(compositeFunction)
volumeMapper.SetInput(vol.GetOutput())
#volumeMapper.SetInput(reader.GetOutput())

# The volume holds the mapper and the property and
# can be used to position/orient the volume
volume = vtk.vtkVolume()
volume.SetMapper(volumeMapper)
volume.SetProperty(volumeProperty)

ren.AddVolume(volume)
ren.SetBackground(1, 1, 1)
renWin.SetSize(600, 600)
renWin.Render()

def CheckAbort(obj, event):
    if obj.GetEventPending() != 0:
        obj.SetAbortRender(1)
 
renWin.AddObserver("AbortCheckEvent", CheckAbort)

iren.Initialize()
renWin.Render()
iren.Start()



########






#shrink = vtk.vtkImageShrink3D()
#shrink.SetShrinkFactors(1, 1, 1)
#shrink.SetInput(vol.GetOutput())
#shrink.AveragingOn()
#
## Demonstrate how to use the vtkBoxWidget to control volume rendering
## within the interior of the widget.
#
#tfun = vtk.vtkPiecewiseFunction()
#tfun.AddPoint(7.0, 0.0)
#tfun.AddPoint(20.0, 0.0)
#tfun.AddPoint(60.0, 0.0)
#tfun.AddPoint(119.0, 0.0)
#tfun.AddPoint(120, 0.2)
#tfun.AddPoint(130, 0.3)
#tfun.AddPoint(200, 0.3)
##tfun.AddPoint(409.0, 1.0)
#
#ctfun = vtk.vtkColorTransferFunction()
#ctfun.AddRGBPoint(0.0, 1.0, 0.0, 1.0)
#ctfun.AddRGBPoint(20.0, 255, 0.5, 0.5)
#ctfun.AddRGBPoint(128.0, 0.9, 0.2, 0.3)
#ctfun.AddRGBPoint(196.0, 0.81, 0.27, 0.1)
#ctfun.AddRGBPoint(409.0, 0.5, 0.5, 0.5)
#
#
#
#
#compositeFunction = vtk.vtkVolumeRayCastMIPFunction()
#
#compositeFunction = vtk.vtkVolumeRayCastIsosurfaceFunction()
#compositeFunction.SetIsoValue(40)
#compositeFunction1 = vtk.vtkVolumeRayCastIsosurfaceFunction()
#compositeFunction1.SetIsoValue(50)
#compositeFunction2 = vtk.vtkVolumeRayCastIsosurfaceFunction()
#compositeFunction2.SetIsoValue(60)
#compositeFunction3 = vtk.vtkVolumeRayCastIsosurfaceFunction()
#compositeFunction3.SetIsoValue(70)
#
#
#volumeMapper = vtk.vtkVolumeRayCastMapper()
#volumeMapper.SetInputConnection(shrink.GetOutputPort())
#volumeMapper.SetVolumeRayCastFunction(compositeFunction)
#volumeMapper1 = vtk.vtkVolumeRayCastMapper()
#volumeMapper1.SetInputConnection(shrink.GetOutputPort())
#volumeMapper1.SetVolumeRayCastFunction(compositeFunction1)
#volumeMapper2 = vtk.vtkVolumeRayCastMapper()
#volumeMapper2.SetInputConnection(shrink.GetOutputPort())
#volumeMapper2.SetVolumeRayCastFunction(compositeFunction2)
#volumeMapper3 = vtk.vtkVolumeRayCastMapper()
#volumeMapper3.SetInputConnection(shrink.GetOutputPort())
#volumeMapper3.SetVolumeRayCastFunction(compositeFunction3)
#
#volumeProperty = vtk.vtkVolumeProperty()
#volumeProperty.SetColor(ctfun)
#volumeProperty.SetScalarOpacity(tfun)
#volumeProperty.SetInterpolationTypeToLinear()
#volumeProperty.ShadeOn()
#
#newvol = vtk.vtkVolume()
#newvol.SetMapper(volumeMapper)
#newvol1 = vtk.vtkVolume()
#newvol1.SetMapper(volumeMapper)
#newvol2 = vtk.vtkVolume()
#newvol2.SetMapper(volumeMapper)
#newvol3 = vtk.vtkVolume()
#newvol3.SetMapper(volumeMapper)
##newvol.SetProperty(volumeProperty)
#
## Create the RenderWindow, Renderer and both Actors
#ren = vtk.vtkRenderer()
#renWin = vtk.vtkRenderWindow()
#renWin.AddRenderer(ren)
#iren = vtk.vtkRenderWindowInteractor()
#iren.SetRenderWindow(renWin)
#
## The SetInteractor method is how 3D widgets are associated with the
## render window interactor. Internally, SetInteractor sets up a bunch
## of callbacks using the Command/Observer mechanism (AddObserver()).
#
#
## Add the actors to the renderer, set the background and size
##iren.AddActor(outlineActor)
#ren.AddVolume(newvol)
#ren.AddVolume(newvol1)
#ren.AddVolume(newvol2)
#ren.AddVolume(newvol3)
#
#ren.SetBackground(1.0, 1.0, 1.0)
#renWin.SetSize(300, 300)
#
#
#iren.Initialize()
#renWin.Render()
#iren.Start()
