import wx
from common_functions import align_all_planes


class PropertyPanel_BasePlaneWidgets(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.curr_max = self.frame_parent.my_loaded_volumes[0][0].data_max
        self.curr_min = self.frame_parent.my_loaded_volumes[0][0].data_min
        self.data_source_path = self.frame_parent.my_loaded_volumes[0][0].data_source_path
        

        self.window_WL = wx.StaticBox(id=-1,
              label='window width/level', name='window_WL', parent=self,
              pos=wx.Point(12, 24), size=wx.Size(265, 80), style=0)


        self.W = wx.StaticText(id=-1, label='W', name='W',
              parent=self, pos=wx.Point(20, 48), size=wx.Size(10, 13),
              style=0)


        self.L = wx.StaticText(id=-1, label='L', name='L',
              parent=self, pos=wx.Point(20, 69), size=wx.Size(8, 13),
              style=0)

        self.sliderLevel= wx.Slider(id=-1, maxValue=self.curr_max,
              minValue=0, name='slider1', parent=self, pos=wx.Point(36,
              72), size=wx.Size(180, 16), style=wx.SL_HORIZONTAL, value=50)
        self.sliderLevel.Bind(wx.EVT_SLIDER, self.OnSliderLevel,
              id=-1)

        self.sliderWindow = wx.Slider(id=-1, maxValue=self.curr_max,
              minValue = 0, name='slider2', parent=self, pos=wx.Point(36,
              48), size=wx.Size(180, 16), style=wx.SL_HORIZONTAL, value=50)
        self.sliderWindow.Bind(wx.EVT_SLIDER, self.OnSliderWindow,
              id=-1)

        #  sliders for plane transparency
        

        self.transp_Ax_text_label = wx.StaticText(id=-1, label='Transparency: Axial ', name='TranspA',
              parent=self, pos=wx.Point(25, 115), 
              style=0)

        self.transp_Cor_text_label = wx.StaticText(id=-1, label='            Coronal', name='TranspC',
              parent=self, pos=wx.Point(25, 135), 
              style=0)

        self.transp_Sag_text_label = wx.StaticText(id=-1, label='          Sagittal', name='TranspS',
              parent=self, pos=wx.Point(25, 155), 
              style=0)

        self.transp_value_labelA = wx.TextCtrl(id=-1, name='TranspATx',
              parent=self, pos=wx.Point(235, 115), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_labelA.SetEditable(1)
        self.transp_value_labelA.Bind(wx.EVT_TEXT, self.OnManualTranspA, id=-1)

        self.transp_value_labelC = wx.TextCtrl(id=-1, name='TranspCTx',
              parent=self, pos=wx.Point(235, 135), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_labelC.SetEditable(1)
        self.transp_value_labelC.Bind(wx.EVT_TEXT, self.OnManualTranspC, id=-1)
        
        self.transp_value_labelS = wx.TextCtrl(id=-1, name='TranspSTx',
              parent=self, pos=wx.Point(235, 155), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_labelS.SetEditable(1)
        self.transp_value_labelS.Bind(wx.EVT_TEXT, self.OnManualTranspS, id=-1)
       

        self.SliderTransparencyA = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySliderS', parent=self, pos=wx.Point(150,
              115), size=wx.Size(75, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparencyA.Bind(wx.EVT_SLIDER, self.OnSliderTransparencyA,
              id=-1)        

        self.SliderTransparencyC = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySliderC', parent=self, pos=wx.Point(150,
              135), size=wx.Size(75, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparencyC.Bind(wx.EVT_SLIDER, self.OnSliderTransparencyC,
              id=-1)

        self.SliderTransparencyS = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySliderS', parent=self, pos=wx.Point(150,
              155), size=wx.Size(75, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparencyS.Bind(wx.EVT_SLIDER, self.OnSliderTransparencyS,
              id=-1) 
        


        ###

        self.Window_Value = wx.StaticText(id=-1, label=str(float(self.sliderWindow.GetValue()/100)), name='Win',
              parent=self, pos=wx.Point(220, 48), size=wx.Size(30, 13),
              style=0)


        self.Level_Value = wx.StaticText(id=-1, label=str(float(self.sliderLevel.GetValue()/100)), name='Level',
              parent=self, pos=wx.Point(220, 69), size=wx.Size(30, 13),
              style=0)


        self.annotations_box = wx.StaticBox(id=-1,
              label='', name='window_anno', parent=self,
              pos=wx.Point(12, 174), size=wx.Size(265, 80), style=0)
        
        
        self.source_text_label = wx.StaticText(id=-1, label='Source:', name='SourceT',
              parent=self, pos=wx.Point(20, 198), size=wx.Size(50, 13),
              style=0)

        self.source_text = wx.TextCtrl(id=-1, name='Source',
              parent=self, pos=wx.Point(70, 198), size=wx.Size(200, 20),
              style=wx.TE_RIGHT, value='%s' %self.data_source_path)
        self.source_text.SetEditable(0)

        self.source_min_max_text = wx.StaticText(id=-1, label='Data max:%0.2f  Data min:%0.2f' %(self.curr_max,self.curr_min), name='MinMax',
              parent=self, pos=wx.Point(20, 229), size=wx.Size(200, 13),
              style=0)


        self.InterpolationOnOffCheckBox = wx.CheckBox(id=-1,
              label='Interpolate colours', name='ScalarBarOnOffCheckBox',
              parent=self, pos=wx.Point(20, 309),
              style=0)
        self.InterpolationOnOffCheckBox.SetValue(True)
        self.InterpolationOnOffCheckBox.Bind(wx.EVT_CHECKBOX, self.OnInterpolationOnOffCheckBox,
              id=-1)


    def OnInterpolationOnOffCheckBox(self, event):
        if self.ScalarBarOnOffCheckBox.GetValue() == True:
            self.thevtkobject.myScalarBar.On()
        else:
            self.thevtkobject.myScalarBar.Off()
 


    def OnManualTranspA(self, event):
        opacity = float(self.transp_value_labelA.GetValue())/100.0
        self.SliderTransparencyA.SetValue(float(self.transp_value_labelA.GetValue()))
        self.frame_parent.ListOfObjects[2].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()
        
        
    def OnManualTranspC(self, event):
        opacity = float(self.transp_value_labelC.GetValue())/100.0
        self.SliderTransparencyC.SetValue(float(self.transp_value_labelC.GetValue()))
        self.frame_parent.ListOfObjects[1].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnManualTranspS(self, event):
        opacity = float(self.transp_value_labelS.GetValue())/100.0
        self.SliderTransparencyS.SetValue(float(self.transp_value_labelS.GetValue()))
        self.frame_parent.ListOfObjects[0].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnSliderTransparencyA(self, event):
        opacity = self.SliderTransparencyA.GetValue()/100.0
        self.transp_value_labelA.SetValue(str(self.SliderTransparencyA.GetValue()))
        self.frame_parent.ListOfObjects[2].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()   
        
    def OnSliderTransparencyC(self, event):
        opacity = self.SliderTransparencyC.GetValue()/100.0
        self.transp_value_labelC.SetValue(str(self.SliderTransparencyC.GetValue()))
        self.frame_parent.ListOfObjects[1].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip() 
        
    def OnSliderTransparencyS(self, event):
        opacity = self.SliderTransparencyS.GetValue()/100.0
        self.transp_value_labelS.SetValue(str(self.SliderTransparencyS.GetValue()))
        self.frame_parent.ListOfObjects[0].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()         
        
    def OnSliderLevel(self, event):
        for i in range(len(self.frame_parent.ListOfObjects)):
            if self.frame_parent.ListOfObjects[i].my_parents_label == self.thevtkobject.my_label:
                #self.frame_parent.ListOfObjects[i].SetWindowLevel(float(self.sliderWindow.GetValue()),float(self.sliderLevel.GetValue()), 1)
                #self.frame_parent.widget.Render()

                lut_min =  self.frame_parent.original_LU_table.GetTableRange()[0]
                lut_max =  self.frame_parent.original_LU_table.GetTableRange()[1]
                
                self.frame_parent.original_LU_table.SetTableRange(lut_min, float(self.sliderLevel.GetValue()))
                
                self.Level_Value.SetLabel(str(float(self.sliderLevel.GetValue())))
                align_all_planes(self.frame_parent)
                event.Skip()


    def OnSliderWindow(self, event):
        for i in range(len(self.frame_parent.ListOfObjects)):
            if self.frame_parent.ListOfObjects[i].my_parents_label == self.thevtkobject.my_label:
                #self.frame_parent.ListOfObjects[i].SetWindowLevel(float(self.sliderWindow.GetValue()),float(self.sliderLevel.GetValue()), 1)
                #self.frame_parent.widget.Render()
                
                lut_min =  self.frame_parent.original_LU_table.GetTableRange()[0]
                lut_max =  self.frame_parent.original_LU_table.GetTableRange()[1]
                
                self.frame_parent.original_LU_table.SetTableRange(float(self.sliderWindow.GetValue()), lut_max)
                
                self.Window_Value.SetLabel(str(float(self.sliderWindow.GetValue())))
                align_all_planes(self.frame_parent)
                event.Skip()
