import vtk
import wx
from numpy import *
from stc_io import *
from dv3dFreeSurferLoad import *
import time


def do_stuff(the_parent_frame):
    stc_filename = '/home/andre/stc/StimOnset_Active_Low_white-rh.stc'
    surf_filename = '/home/andre/stc/rh.white'
    
    
    v,data,start_ms,sample_ms = read_stc(stc_filename)
    vertices, triangles = read_fs_surf(surf_filename)
    
    a = zeros(len(vertices))
    
    data = array(data*10e13, dtype = int)
    
    print data.max()
    print data.min()
    
    a[v] = data[:,72]
    
    a = a/(max(a))
    
    initial_scalars = vtk.vtkFloatArray()
    
    curr_val = 0
    
    for i in range(len(vertices)):
        if a[i] != 0:
            curr_val = a[i]
        #initial_scalars.InsertNextValue(a[i])
            initial_scalars.InsertValue(i, a[i])
        #else:
        #    initial_scalars.InsertValue(i, curr_va
    
    
        
    pd = get_surf_polyData(vertices, triangles)
    
    pd.Update()
    
    mn_ScalarValues = pd.GetPointData()
    
    mn_ScalarValues.SetScalars(initial_scalars)
    
    pd.Update()
    
    mn_Mapper = vtk.vtkPolyDataMapper()
    mn_Mapper.SetInput(pd)
    mn_Mapper.ScalarVisibilityOn()
    

    HueRangeMin = 0.0
    HueRangeMax = 0.1667
    ValueRangeMin = 1.0
    ValueRangeMax = 1.0
    SaturationRangeMin = 1.0
    SaturationRangeMax = 1.0
    AlphaRangeMin = 1.0
    AlphaRangeMax = 1.0
    
    #initially we set the table to display the full range of scalar
    # values in the data volume .. can be restrcited later with
    # property frames
    TableRangeMin = 0 
    TableRangeMax = data.max()

    #actually build the vtkLookupTable

    y = vtk.vtkLookupTable()
    mn_Mapper.GetLookupTable().SetNumberOfTableValues(256)
    mn_Mapper.GetLookupTable().SetHueRange(HueRangeMin, HueRangeMax)
    mn_Mapper.GetLookupTable().SetValueRange(ValueRangeMin, ValueRangeMax)
    mn_Mapper.GetLookupTable().SetSaturationRange(SaturationRangeMin, SaturationRangeMax)
    mn_Mapper.GetLookupTable().SetAlphaRange(AlphaRangeMin, AlphaRangeMax)
    #y.SetTableRange(TableRangeMin, TableRangeMax)
    mn_Mapper.GetLookupTable().SetTableRange(0, TableRangeMax)
    mn_Mapper.GetLookupTable().Build()


    
    mn_Mapper.GetLookupTable().SetTableValue(0, (0.75,0.75,0.75,1.0))
    #mn_Mapper.GetLookupTable().SetLookupTable(y)
    
    t = vtk.vtkActor()
    t.SetMapper(mn_Mapper)
    the_parent_frame.ren.AddActor(t)