import vtk

from dv3dObjectsToRender import *
from dv3dProbePropertyFrame import *
from dv3dExportPolyDataToDotVTKFile import *

def ProbeShepardVolume(frame_parent, the_surface, the_volume,mmin,mmax,rsr_min, rsr_max):
	
	surfPolyData = the_surface.GetMapper().GetInput()
	
	# the really clever bit (thx VTK!) - wherever i have a datapoint on my
	# surface, go to thesame datapoint in the stat-volume and extract the
	# scalar value there- probe the data with spatial filter - ProbeFilter
	stat_probe = vtk.vtkProbeFilter()
	stat_probe.SetInput(surfPolyData)
	stat_probe.SetSource(the_volume)
	
	transform1 = vtk.vtkTransform()
	transform1.Scale(1.001, 1.001, 1.001)
	
	transformer1 = vtk.vtkTransformPolyDataFilter()
	transformer1.SetInput(stat_probe.GetOutput())
	transformer1.SetTransform(transform1)
	
	stat_contourMapper = vtk.vtkPolyDataMapper()
	stat_contourMapper.SetInput(transformer1.GetOutput())
	#stat_contourMapper.Update()
	
	lut = vtk.vtkLookupTable()
	lut.SetHueRange(0.667,0.0)
	lut.SetNumberOfColors(256)	
	lut.Build()
	stat_contourMapper.SetColorModeToMapScalars()
	stat_contourMapper.SetLookupTable(lut)	
	stat_contourMapper.SetScalarRange(rsr_min, rsr_max)
	#stat_contourMapper.Update()
	stat_contourMapper.GetLookupTable().SetTableValue(0,(0.5,0.5,0.5,1.0))
	#stat_contourMapper.GetLookupTable().SetTableValue(1,(1.0,0.0,0.0,1.0))
	#stat_contourMapper.GetLookupTable().SetTableValue(255,(1.0,1.0,0.0,1.0))
	#stat_contourMapper.GetLookupTable().Build()



	## set a colour bar for reference of scalar value mapping
	pos_scalarBar =  vtk.vtkScalarBarActor()
	pos_scalarBar.SetLookupTable(lut)
	pos_scalarBar.SetTitle('min=%.2e    max=%.2e    scale reflects proportion of maximum' %(mmin,mmax))
	pos_scalarBar.GetLabelTextProperty().SetFontSize(48)
	pos_scalarBar.GetTitleTextProperty().SetFontSize(20)
	pos_scalarBar.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport()
	pos_scalarBar.GetPositionCoordinate().SetValue(0.05,0.05)
	pos_scalarBar.SetOrientationToHorizontal()
	pos_scalarBar.SetWidth(0.85)
	pos_scalarBar.SetHeight(0.05)
	pos_scalarBar.SetNumberOfLabels(5)
	pos_scalarBar.SetPosition(0.01, 0.1)


	sbw = vtk.vtkScalarBarWidget()
	sbw.SetScalarBarActor(pos_scalarBar)
	
	#now pass all our created and updated objects to the renderer
	stat_contourActor = vtk.vtkActor()
	stat_contourActor.SetMapper(stat_contourMapper)
	stat_contourActor.VisibilityOn()
	stat_contourActor.GetProperty().SetBackfaceCulling(0)
	
	#frame_parent.ren.AddActor(stat_contourActor)
	return stat_contourActor, sbw
	
	#frame_parent.st_act_list.append(stat_contourActor)
	
	#dlg = wx.FileDialog(frame_parent, "Save your new surface file here:", "", "", ".vtk file|*.vtk", wx.SAVE)
	#    
	#if dlg.ShowModal() == wx.ID_OK:
	#    file_to_save = dlg.GetPath()
	#else:
	#    return
	#
	#frame_parent.applyVTKxfm = 0
	#file_name = dv3dExportPolyDataToDotVTKFile(file_to_save, stat_contourActor, LUT)
	#
	#frame_parent.AutoLoadFileNow = file_name #TODO explain why - circular arg hack
	#frame_parent.temp_LUT = new_LUT
	
	
