#!/usr/bin/env python
from dv3dPolydataClipper import AddPolyDataClipper

def AddVTKObjectWithAttributes(the_vtkobject,\
                            the_parentframe,\
                            the_type,\
                            the_label,\
                            is_a_child_of_label,\
                            tree_item,\
                            tree_item_image_id,\
                            tree_item_alt_image_id,\
                            is_currently_visible,\
                            structural_or_functional,\
                            data_volume,\
                            data_path,\
                            has_property_frame,\
                            property_frame_type,\
                            property_frame_instance):
    
    #check if exportable surface and append counter if required
    #also check if the surface shoudl have a clipper and transform widget added
    if the_label[0:7] == 'surface':
        curr_count = the_parentframe.exportable_surface_count+1

        #the_label = the_label+str(curr_count) ##TODO - do we wnat to increment the surface numbers?
        the_parentframe.exportable_surface_count = curr_count
        the_vtkobjectB, planes1, clipper1 = AddPolyDataClipper(the_parentframe, the_vtkobject)
        
        the_vtkobject = the_vtkobjectB
	the_vtkobject.planes1 = planes1
	the_vtkobject.clipper1 = clipper1
        the_vtkobject.my_ClipperBoxWidget.On()
        the_vtkobject.VisibilityOn()
        the_vtkobject.my_ClipperBoxWidget.Off()
  
#add all objects to be rendered to a list so that functions can access them and their associated
# child-objects later
    the_vtkobject.my_parent_frame = the_parentframe
    the_vtkobject.my_type = the_type
    the_vtkobject.my_label = the_label
    the_vtkobject.my_parents_label = is_a_child_of_label
    the_vtkobject.my_treeitem = tree_item
    the_vtkobject.my_treeitem_img1 = tree_item_image_id
    the_vtkobject.my_treeitem_img2 = tree_item_alt_image_id
    the_vtkobject.my_visibility = is_currently_visible
    the_vtkobject.my_struct_or_func = structural_or_functional
    the_vtkobject.my_data_volume = data_volume
    the_vtkobject.my_data_path = data_path
    the_vtkobject.my_has_property_frame = has_property_frame
    the_vtkobject.my_property_frame_type = property_frame_type
    the_vtkobject.my_property_frame_instance = property_frame_instance
    
    #append the newly created object to the bject list in the main window
    the_parentframe.ListOfObjects.append(the_vtkobject)
    
    if the_label[0:7] == 'surface':
        the_vtkobject.my_ClipperBoxWidget.On()
        the_vtkobject.my_ClipperBoxWidget.GetPlanes(planes1)
        the_vtkobject.my_ClipperBoxWidget.Modified()
        the_vtkobject.VisibilityOn()
        the_vtkobject.my_ClipperBoxWidget.Off()

        #selectMapper1.Update()
        the_vtkobject.SetOrigin(the_vtkobject.GetCenter())

    ####now also append the object to the processing list so that we can create a
    #### session file if required.
    ####write actions so far to processing array
    #### 1 - internal or external data
    #### 2 - path / reference to data
    #### 3 - manipulation applied
    #### 4 - set of values passed (comma separated string)
    ###the_parentframe.Completed_processes[0] = ['ext',file_to_load,'base volume',str(self.base_loaded)]
            
