import vtk

def dv3dExportPolyDataToDotVTKFile(export_file_name, object_to_export, LUT = None):
    
    polydata_to_write = object_to_export.GetMapper().GetInput()
    
    
    
    writer = vtk.vtkPolyDataWriter()
    writer.SetInput(polydata_to_write)
    if LUT is None:
        pass
    else:
        my_lookuptable = LUT
        writer.SetLookupTableName('my_lookuptable')
    
    if export_file_name == '':
        export_file_name = '/tmp/my_surface_file.vtk'
        print 'No filename provided .. attempting to save to /tmp/my_surface_file.vtk'
    
    if export_file_name[-4:] != '.vtk':
        export_file_name = export_file_name + '.vtk'
    
    try:
        writer.SetFileName(export_file_name)
        writer.Write()
        print 'Surface successfully saved to %s' %export_file_name
        return export_file_name
    except:
        print 'Write failed for some reason (?) ...'