import vtk
from dv3dNifti2VtkImageData import *
from dv3dAnalyze2VtkImageData import *
from dv3dDICOMReader import *

class create_new_volume(vtk.vtkImageData):
    #a subclass of the vtkImageData with additional properties
    def __init__(self,source_file,vol_data_label, source_dir = None):
        if source_file[-7:] == '.nii.gz':
            self.volume_data, self.data_max, self.data_min,       \
                      self.data_bounds, self.x_slice_pos,          \
                      self.y_slice_pos, self.z_slice_pos,               \
                      self.data_s_row_x, self.data_s_row_y,   \
                      self.data_s_row_z, self.data_spacing,   \
                      = nifti2vtkImageData(source_file)
        elif (source_file[-4:] == '.hdr') or (source_file[-4:] == '.img'):
            self.volume_data, self.data_max, self.data_min,       \
                      self.data_bounds, self.x_slice_pos,          \
                      self.y_slice_pos, self.z_slice_pos,               \
                      self.data_s_row_x, self.data_s_row_y,   \
                      self.data_s_row_z, self.data_spacing,   \
                      = analyze2vtkImageData(source_file)
        else:
            source_file = source_dir
            self.volume_data, self.data_max, self.data_min,       \
                      self.data_bounds, self.x_slice_pos,          \
                      self.y_slice_pos, self.z_slice_pos,               \
                      self.data_s_row_x, self.data_s_row_y,   \
                      self.data_s_row_z, self.data_spacing,   \
                      = readDICOMFolder(source_file)            

        self.data_label = vol_data_label
        self.data_source_path = source_file
        
        ### SETTING UP COLOUR LOOKUP TABLES FOR OVERLAY DATA
        
        #dont set up lookuptables for the following:
        non_lookups = ['base data','talairach data', 'ref data']
        if vol_data_label in non_lookups:
            pass        
        
        #now set up the colour looukuptables for apt volumes
        else:
            
            #next 8 lines set the initial HSVA table - yellow to red
            self.HueRangeMin = 0.0
            self.HueRangeMax = 0.1667
            self.ValueRangeMin = 1.0
            self.ValueRangeMax = 1.0
            self.SaturationRangeMin = 1.0
            self.SaturationRangeMax = 1.0
            self.AlphaRangeMin = 1.0
            self.AlphaRangeMax = 1.0
            
            #initially we set the table to display the full range of scalar
            # values in the data volume .. can be restrcited later with
            # property frames
            self.TableRangeMin = self.data_min 
            self.TableRangeMax = self.data_max
        
            #actually build the vtkLookupTable

            y = vtk.vtkLookupTable()
            y.SetNumberOfTableValues(256)
            y.SetHueRange(self.HueRangeMin, self.HueRangeMax)
            y.SetValueRange(self.ValueRangeMin, self.ValueRangeMax)
            y.SetSaturationRange(self.SaturationRangeMin, self.SaturationRangeMax)
            y.SetAlphaRange(self.AlphaRangeMin, self.AlphaRangeMax)
            #y.SetTableRange(self.TableRangeMin, self.TableRangeMax)
            y.SetTableRange(0, self.TableRangeMax)
            y.Build()

            self.lookuptable = y
