import wx
import time

from dv3dDialogs import *
from dv3dLoadTMSCoil import *
from dv3dGeneratePositionMarker import *
from dv3dCustomWXControls import *


class MiscTab2(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        
        self.AllLightsOff = wx.Button(self, -1, 'All Lights Off', (15,15))
        self.Bind(wx.EVT_BUTTON, self.OnAllLightsOff, self.AllLightsOff)

        self.AllLightsOn = wx.Button(self, -1, 'All Lights On', (15,60))
        self.Bind(wx.EVT_BUTTON, self.OnAllLightsOn, self.AllLightsOn)


        self.LightSwitch1= wx.ToggleButton(self, -1, 'Light1 off', (150,15))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnLightSwitch1, self.LightSwitch1)
        self.LightSwitch1.SetToolTipString('Turn light1 of the scene on/off')

        self.LightSwitch2= wx.ToggleButton(self, -1, 'Light2 off', (150,75))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnLightSwitch2, self.LightSwitch2)
        self.LightSwitch2.SetToolTipString('Turn light2 of the scene on/off')

        self.LightSwitch3= wx.ToggleButton(self, -1, 'Light3 off', (150,135))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnLightSwitch3, self.LightSwitch3)
        self.LightSwitch3.SetToolTipString('Turn light3 of the scene on/off')

        self.LightSwitch4= wx.ToggleButton(self, -1, 'Light4 off', (150,195))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnLightSwitch4, self.LightSwitch4)
        self.LightSwitch4.SetToolTipString('Turn light4 of the scene on/off')


        self.Light1Slider = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='Light1Slider', parent=self, pos=wx.Point(250,
              15), size=wx.Size(200, 16), style=wx.SL_HORIZONTAL, value=100)
        self.Light1Slider.Bind(wx.EVT_SLIDER, self.OnLight1Slider,
              id=-1)

        self.Light2Slider = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='Light2Slider', parent=self, pos=wx.Point(250,
              75), size=wx.Size(200, 16), style=wx.SL_HORIZONTAL, value=100)
        self.Light2Slider.Bind(wx.EVT_SLIDER, self.OnLight2Slider,
              id=-1)

        self.Light3Slider = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='Light3Slider', parent=self, pos=wx.Point(250,
              135), size=wx.Size(200, 16), style=wx.SL_HORIZONTAL, value=100)
        self.Light3Slider.Bind(wx.EVT_SLIDER, self.OnLight3Slider,
              id=-1)

        self.Light4Slider = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='Light4Slider', parent=self, pos=wx.Point(250,
              195), size=wx.Size(200, 16), style=wx.SL_HORIZONTAL, value=0)
        self.Light4Slider.Bind(wx.EVT_SLIDER, self.OnLight4Slider,
              id=-1)

        
        

    def OnAllLightsOn(self, evt):
        self.frame_parent.light1.SwitchOn()
        self.frame_parent.light2.SwitchOn()
        self.frame_parent.light3.SwitchOn()
        self.frame_parent.light4.SwitchOn()
		


    def OnAllLightsOff(self, evt):
        self.frame_parent.light1.SwitchOff()
        self.frame_parent.light2.SwitchOff()
        self.frame_parent.light3.SwitchOff()
        self.frame_parent.light4.SwitchOff()

    def OnLightSwitch1(self, evt):
        if self.frame_parent.light1.GetSwitch() == 1:
            self.frame_parent.light1.SwitchOff()
            self.LightSwitch1.SetLabel('Light1 off')
            self.LightSwitch1.Update()
            self.frame_parent.widget.Render()
        else:
            self.frame_parent.light1.SwitchOn()
            self.LightSwitch1.SetLabel('Light1 on')
            self.LightSwitch1.Update()
            self.frame_parent.widget.Render()

    def OnLightSwitch2(self, evt):
        if self.frame_parent.light2.GetSwitch() == 1:
            self.frame_parent.light2.SwitchOff()
            self.LightSwitch2.SetLabel('Light2 off')
            self.LightSwitch2.Update()
            self.frame_parent.widget.Render()
        else:
            self.frame_parent.light2.SwitchOn()
            self.LightSwitch2.SetLabel('Light2 on')
            self.LightSwitch2.Update()
            self.frame_parent.widget.Render()

    def OnLightSwitch3(self, evt):
        if self.frame_parent.light3.GetSwitch() == 1:
            self.frame_parent.light3.SwitchOff()
            self.LightSwitch3.SetLabel('Light3 off')
            self.LightSwitch3.Update()
            self.frame_parent.widget.Render()
        else:
            self.frame_parent.light3.SwitchOn()
            self.LightSwitch3.SetLabel('Light3 on')
            self.LightSwitch3.Update()
            self.frame_parent.widget.Render()

    def OnLightSwitch4(self, evt):
        if self.frame_parent.light4.GetSwitch() == 1:
            self.frame_parent.light4.SwitchOff()
            self.LightSwitch4.SetLabel('Light4 off')
            self.LightSwitch4.Update()
            self.frame_parent.widget.Render()
        else:
            self.frame_parent.light4.SwitchOn()
            self.LightSwitch4.SetLabel('Light4 on')
            self.LightSwitch4.Update()
            self.frame_parent.widget.Render()
        
    def OnLight1Slider(self, evt):
        curr_val = float(self.Light1Slider.GetValue())
        #currently 0-100 -- rescale to -50 to 50
        scl_val = (curr_val-50.0)
        self.frame_parent.light1.SetPosition(0,0,scl_val)
        self.frame_parent.ren.UpdateLights()
        self.frame_parent.widget.Render()

    def OnLight2Slider(self, evt):
        curr_val = float(self.Light2Slider.GetValue())
        #currently 0-100 -- rescale to -50 to 50
        scl_val = (curr_val-50.0)
        self.frame_parent.light2.SetPosition(0,scl_val,0)
        self.frame_parent.ren.UpdateLights()
        self.frame_parent.widget.Render()

    def OnLight3Slider(self, evt):
        curr_val = float(self.Light3Slider.GetValue())
        #currently 0-100 -- rescale to -50 to 50
        scl_val = (curr_val-50.0)
        self.frame_parent.light3.SetPosition(scl_val,0,0)
        self.frame_parent.ren.UpdateLights()
        self.frame_parent.widget.Render()

    def OnLight4Slider(self, evt):
        curr_val = float(self.Light4Slider.GetValue())
        #currently 0-100 -- rescale to -50 to 50
        scl_val = (curr_val-50.0)
        self.frame_parent.light4.SetPosition(scl_val,scl_val,scl_val)
        self.frame_parent.ren.UpdateLights()
        self.frame_parent.widget.Render()




















