from numpy import *

import vtk
from fsFlatIO import readFSScalarData
from fsFlatGenerateLUT import generateLUT

def fsGenerateRGBALayer(parent, anatomyPolyData, new_item_index):

    ### HANDLE SCALAR OVERLAY DATA
    #now extract the scalar values for the overlay from the previous 4 volumes

    r_array = parent.loadedSurfaceTracker[-4].meta['originalScalarArray']
    g_array = parent.loadedSurfaceTracker[-3].meta['originalScalarArray']
    b_array = parent.loadedSurfaceTracker[-2].meta['originalScalarArray']
    a_array = parent.loadedSurfaceTracker[-1].meta['originalScalarArray']

    rScalars = array(r_array*255, 'i')
    gScalars = array(g_array*255, 'i')
    bScalars = array(b_array*255, 'i')
    aScalars = array(a_array*255, 'i')

    print rScalars
    print rScalars.max()
    print rScalars.min()


    outRGB = vtk.vtkUnsignedCharArray()
    outRGB.SetNumberOfComponents(4)
    outRGB.SetName("Colors")
    outRGB.SetNumberOfTuples(len(r_array))
    for ii in range(len(r_array)):
        outRGB.InsertNextTuple4(r_array[ii], g_array[ii], b_array[ii], a_array[ii])

    #print outRGB

    #the overlay plane
    overlay_polydata = vtk.vtkPolyData()
    overlay_polydata.DeepCopy(anatomyPolyData)
    overlay_polydata.GetPointData().SetScalars(outRGB)
    overlay_polydata.Modified()

    #print overlay_polydata
    
    overlay_surfMapper = vtk.vtkPolyDataMapper()
    overlay_surfMapper.SetInput(overlay_polydata)
    #overlay_surfMapper.SetColorModeToDefault()
    #overlay_surfMapper.SetScalarModeToUsePointData()
    #overlay_surfMapper.SetScalarRange((0,255))

    overlay_surfMapper.Update()
    #print overlay_surfMapper

    
    overlay_surfActor = vtk.vtkActor()
    overlay_surfActor.SetMapper(overlay_surfMapper)

    overlay_surfActor

    HSVA_start = [0.0,1.0,1.0,1.0] #red
    HSVA_end = [0.1667,1.0,1.0,1.0] #yellow

    RGBA_start = [255.0, 0.0, 0.0, 1.0] #red
    RGBA_end = [255.0, 255.0, 0.0, 1.0] #yellow


    #lets construct a metadata holder that allows us to track info about each surface, inlcuding:
    #  append the data to the list and add labels such that:
    #   .dataIndex = index position of corresponding data in loadedData
    #   .dataPath = path to original data source
    #   .listPos = physical position in list and thus layer depth (allows depth rendering)
    #   .listTxt = text description in list
    #   .dataMax = max value in scalar range of data
    #   .dataMin = min value in scalar range of data
    #   .lutStartColor = [H S V A] colour
    #   .lutEndColor = [H S V A] colour
    #   .lutBinary = 0 or 1 -> use a binary colormap? (useful for curvature data)
    #   .lutBinaryCutOff = Scalar val to define midpoint of binary range
    #   .lutVisibleScalarRange = current user set lower and upper bound of visible scalar values
    #   .visibleState = currently on/off


    overlay_surfActor.meta = {}

    overlay_surfActor.meta['dataIndex'] = new_item_index
    overlay_surfActor.meta['dataPath'] = None
    overlay_surfActor.meta['listPos'] = new_item_index
    overlay_surfActor.meta['listTxt'] = 'Overlay file %s' %new_item_index
    overlay_surfActor.meta['dataMax'] = 1#overlayScalars.max()
    overlay_surfActor.meta['dataMin'] = 1#overlayScalars.min()
    overlay_surfActor.meta['lutHSVAStartColor'] = HSVA_start
    overlay_surfActor.meta['lutHSVAEndColor'] = HSVA_end
    overlay_surfActor.meta['lutRGBAStartColor'] = RGBA_start
    overlay_surfActor.meta['lutRGBAEndColor'] = RGBA_end
    overlay_surfActor.meta['lutBinary'] = False
    overlay_surfActor.meta['lutBinaryCutOff'] = None#overlayScalars.max()/2.0
    overlay_surfActor.meta['lutVisibleScalarRange'] = [0, 1]#[overlayScalars.max()/10.0,overlayScalars.max()]    
    overlay_surfActor.meta['visibleState'] = True
    overlay_surfActor.SetPosition(0,0,0.1*new_item_index) #for multiple layers

    overlay_surfActor.GetProperty().SetOpacity(0.999)

    #create a lookupTbale for the overlay data
    overlay_lu = None #generateLUT(HSVA_start, HSVA_end, overlay_surfActor.meta['lutVisibleScalarRange'])
    #overlay_lu.SetTableValue(0,(0.0,0.0,0.0,0.0))

    #overlay_surfMapper.SetLookupTable(overlay_lu)

    overlayScalars = None

    return overlay_surfActor, overlay_lu, overlayScalars

