# core libs
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import vtk

#gui stuff
import fsFlatPy_ui as fs_ui
from fsFlatVTKFrameGui import QVtkInteractorWidget

#data handlers
from loadFsFlatAnatomy import loadFsFlatAnatomy
from loadFsOverlay import loadFsOverlay

#main program
class fsFlatPyLaunch(QMainWindow, fs_ui.Ui_myMainWindow):
    def PrintButton(self):
        pass

    def PrintList(self):
        print self.listWidget.currentRow()
                
    def LoadNewOverlay(self):
        fName = unicode(QFileDialog.getOpenFileName(self, "Open overlay file", "Open new file", self.tr("MGH Files (*.MGH)")))
        if fName != '':
            new_surf_actor, new_lut, new_scalars = loadFsOverlay(fName, self.anatomyPolyData)
        
        self.ren.AddActor(new_surf_actor)  

    def SliderStart(self):
        print 'hello3'
        self.ren.GetActiveCamera().Azimuth(5)
        self.iwidget.interactor.Render()

    def SliderStop(self):
        print 'hello4'
        self.ren.GetActiveCamera().Azimuth(-5)
        self.iwidget.interactor.Render()

    def __init__(self, text, parent=None):
        super(fsFlatPyLaunch, self).__init__(parent)
        self.__text = unicode(text)
        self.__index = 0
        self.setupUi(self)

        self.Frame3d = QFrame(self)
        self.Frame3d.setFrameShape(QFrame.StyledPanel)

        self.iwidget_3d = QVtkInteractorWidget(self.Frame3d)

        self.horizontalLayout.addWidget(self.iwidget_3d)

        self.ren = vtk.vtkRenderer()
        self.iwidget_3d.interactor.GetRenderWindow().AddRenderer(self.ren)
        self.iwidget_3d.interactor.SetInteractorStyle(vtk.vtkInteractorStyleTrackballCamera())
        
        #now use parallel projection so we don't get any 'depth' issues
        self.ren.GetActiveCamera().SetParallelProjection(1)


        ##Add the base data
        self.anatomyActor, self.anatomyOrigNumpyScalars, self.anatomyLookupTable = loadFsFlatAnatomy(pointfile=None, curvfile=None)

        #get the poydata out so we can use it for overlay surfaces        
        #self.anatomyPolyData = self.anatomyActor.GetMapper().GetInput()
        #self.ren.AddActor(self.anatomyActor)  
        

        ### ------------------------------------------------ 
        # observers / actions
        self.loadOverlayButton.connect(self.loadOverlayButton, SIGNAL("released()"), self.LoadNewOverlay) #not sure why 'clicked' gives a double hit here
        self.connect(self.listWidget, SIGNAL("currentRowChanged()"), self.PrintButton)
        self.listWidget.doubleClicked.connect(self.PrintList)
        self.listWidget.currentRowChanged.connect(self.PrintList)

        self.listWidget.setSortingEnabled(False)
    
        self.loadedOverlays = [];

            

        
if __name__ == "__main__":
    import sys
    text = "Python viewer for FreeSurfer flat pathces .. "
    app = QApplication(sys.argv)
    dv3dMain = fsFlatPyLaunch(text)
    dv3dMain.show()
    dv3dMain.iwidget_3d.interactor.Render()
    app.exec_()


