#!/usr/bin/python
#dv3d_gui_SetupMainFrames.py
#Sets up the main frame layout for the DV3D windows
#DV3D refactor 2
#AG 25/07/2013

#import libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from dv3dVTKFrameGui import QVtkInteractorWidget
import vtk


def dv3d_gui_SetupMainFrames(the_parent_window):

    tpw = the_parent_window #for brevity

    tpw.Frame3d = QFrame(tpw)
    tpw.Frame3d.setFrameShape(QFrame.StyledPanel)

    tpw.Frame2dX = QFrame(tpw)
    tpw.Frame2dX.setFrameShape(QFrame.StyledPanel)
    tpw.Frame2dX.show()

    tpw.Frame2dY = QFrame(tpw)
    tpw.Frame2dY.setFrameShape(QFrame.StyledPanel)
    tpw.Frame2dY.show()

    tpw.Frame2dZ = QFrame(tpw)
    tpw.Frame2dZ.setFrameShape(QFrame.StyledPanel)
    tpw.Frame2dZ.show()

    tpw.iwidget_3d = QVtkInteractorWidget(tpw.Frame3d)
    tpw.iwidget_2dX = QVtkInteractorWidget(tpw.Frame2dX)
    tpw.iwidget_2dY = QVtkInteractorWidget(tpw.Frame2dY)
    tpw.iwidget_2dZ = QVtkInteractorWidget(tpw.Frame2dZ)

    tpw.horizontalLayout.addWidget(tpw.iwidget_3d)

    tpw.orthoViewLayout_dock.addWidget(tpw.iwidget_2dX)
    tpw.orthoViewLayout_dock.addWidget(tpw.iwidget_2dY)
    tpw.orthoViewLayout_dock.addWidget(tpw.iwidget_2dZ)

    tpw.ren3d = vtk.vtkRenderer()
    tpw.iwidget_3d.interactor.GetRenderWindow().AddRenderer(tpw.ren3d)

    tpw.ren1 = vtk.vtkRenderer()
    tpw.iwidget_2dX.interactor.GetRenderWindow().AddRenderer(tpw.ren1)   
    
    tpw.ren2 = vtk.vtkRenderer()
    tpw.iwidget_2dZ.interactor.GetRenderWindow().AddRenderer(tpw.ren2)     

    tpw.ren3 = vtk.vtkRenderer()
    tpw.iwidget_2dY.interactor.GetRenderWindow().AddRenderer(tpw.ren3)


    tpw.ren1.ResetCamera()
    tpw.ren1.GetActiveCamera().SetViewUp((0,1,0))        
    tpw.ren1.GetActiveCamera().Azimuth(90)
    tpw.ren1.GetActiveCamera().Roll(-90)
    tpw.ren1.GetActiveCamera().ParallelProjectionOn()                
    #tpw.ren1.GetActiveCamera().SetClippingRange(0.001,500)


    tpw.ren2.ResetCamera()
    tpw.ren2.GetActiveCamera().SetViewUp((0,1,0))
    tpw.ren2.GetActiveCamera().ParallelProjectionOn()
    #tpw.ren2.GetActiveCamera().SetClippingRange(0.001,500)


    tpw.ren3.ResetCamera()
    tpw.ren3.GetActiveCamera().Elevation(90)
    tpw.ren3.GetActiveCamera().ParallelProjectionOn()
    #tpw.ren3.GetActiveCamera().SetClippingRange(0.001,500)

    tpw.iwidget_2dX.interactor.Render()
    tpw.iwidget_2dY.interactor.Render()
    tpw.iwidget_2dZ.interactor.Render()

    #allow full interaction in 3d view
    tpw.iwidget_3d.interactor.SetInteractorStyle(vtk.vtkInteractorStyleTrackballCamera())
    #restrict the 2d views so that no rotation is possible but pan and zoom still are
    tpw.iwidget_2dX.interactor.SetInteractorStyle(vtk.vtkInteractorStyleImage())
    tpw.iwidget_2dY.interactor.SetInteractorStyle(vtk.vtkInteractorStyleImage())
    tpw.iwidget_2dZ.interactor.SetInteractorStyle(vtk.vtkInteractorStyleImage())

