#!/usr/bin/python
#dv3d_export_SaveLargeImage.py
#exports a user defined size laerge image
#DV3D refactor 2
#AG 05/08/2013

import vtk
import time
from dv3d_dialogs_image_export_options_panel import imageExportOptionsPanel
from PyQt4.QtGui import *

def dv3d_export_SaveLargeImage(the_parent_window):
    tpw = the_parent_window #for brevity

    tpw.imageExportOptionsSet = 0

    #launch the options dialog
    #tpw.t = imageExportOptionsPanel('some text', tpw)

    #get some values
    magnification, ok = QInputDialog.getInt(tpw, "Image scaling",
            "Set the amount to scale the image by (1-10):", tpw.imageExportOptionsSet, 1, 10)


    if ok:
        #get a filename
        filename = str(QFileDialog.getSaveFileName(tpw, "Save file as", "", ".png"))

        if filename  != None:
            #make sure we have a file extension
            if filename[-4:] != '.png': filename = filename+'.png'

            render_large = vtk.vtkRenderLargeImage()
            render_large.SetInput(tpw.ren3d)
            writer = vtk.vtkPNGWriter()

            #filename = '/tmp/testimage.png'

            render_large.SetMagnification(magnification)
            writer.SetFileName(filename)

            writer.SetInputConnection(render_large.GetOutputPort())
            tpw.ren3d.Render()
            writer.Write()
            del render_large
            print 'image saved to %s' %filename

    else:
        pass

    tpw.imageExportOptionsSet = 0 #reset
    
    
