#!/usr/bin/python
#dv3d_data_Sync3Dand2DPlanes.py
#Functions that SYNCHRONISE AND RESET PLANES VIEWS
#DV3D refactor 2
#AG 25/07/2013



# synchronisises the positions of the 2d and 3d widgets
from dv3d_data_updateAllViews import *


def SyncPlanes(tpw, X_plane_list, Y_plane_list, Z_plane_list):
    #function used to make sure all planes follow the orientation of the first
    for i in range(1,len(X_plane_list)):

        X_plane_list[i].SetOrigin(X_plane_list[0].GetOrigin())
        X_plane_list[i].SetPoint1(X_plane_list[0].GetPoint1())
        X_plane_list[i].SetPoint2(X_plane_list[0].GetPoint2())
        X_plane_list[i].UpdatePlacement()
        X_plane_list[i].Modified()
        #X_plane_list[i].GetInteractor().GetRenderWindow().Render()
        
        Y_plane_list[i].SetOrigin(Y_plane_list[0].GetOrigin())
        Y_plane_list[i].SetPoint1(Y_plane_list[0].GetPoint1())
        Y_plane_list[i].SetPoint2(Y_plane_list[0].GetPoint2())
        Y_plane_list[i].UpdatePlacement()
        Y_plane_list[i].Modified()
        #Y_plane_list[i].GetInteractor().GetRenderWindow().Render()

        Z_plane_list[i].SetOrigin(Z_plane_list[0].GetOrigin())
        Z_plane_list[i].SetPoint1(Z_plane_list[0].GetPoint1())
        Z_plane_list[i].SetPoint2(Z_plane_list[0].GetPoint2())
        Z_plane_list[i].UpdatePlacement()
        Z_plane_list[i].Modified()
        #Z_plane_list[i].GetInteractor().GetRenderWindow().Render()

        dv3d_data_updateAllViews(tpw)


def ResetPlaneOrientations(the_parent_window):
    #function used to set first set of plane sback to default xyz orientation
    # centred on the middle of the volume data it describes .. subsequently
    # a call to SyncPlanes ensures all plane data is aligned to the first set.

    tpw = the_parent_window #for brevity

    tpw.X_plane_list[0].SetPlaneOrientationToXAxes()
    tpw.X_plane_list[0].SetSliceIndex(tpw.Planes[0].x_slice_pos)
    tpw.Y_plane_list[0].SetPlaneOrientationToYAxes()
    tpw.Y_plane_list[0].SetSliceIndex(tpw.Planes[0].y_slice_pos)
    tpw.Z_plane_list[0].SetPlaneOrientationToZAxes()
    tpw.Z_plane_list[0].SetSliceIndex(tpw.Planes[0].z_slice_pos)

    cur_cam = tpw.ren3d.GetActiveCamera()
    bounds =  tpw.Planes[0].bounds
    cur_cam.SetPosition((bounds[0]+bounds[1])/2,(bounds[2]+bounds[3])/2,(bounds[4]+bounds[5])/2+600)
    cur_cam.SetViewUp(0,1,0)
    cur_cam.SetViewAngle(30)

    SyncPlanes(tpw, tpw.X_plane_list, tpw.Y_plane_list, tpw.Z_plane_list)
    
    #defaulst back to top view so fix the 'View from' combo box too
    tpw.comboBoxViewFrom.setCurrentIndex(0)
    tpw.comboBoxViewFrom.update()
    tpw.comboBoxViewFrom.repaint()
        
    dv3d_data_updateAllViews(tpw)
    


#test code for now
def SimpleOrthoSyncPlanes(X_plane_list, Y_plane_list, Z_plane_list):
    ref_x = X_plane_list[0].GetSliceIndex()
    ref_y = Y_plane_list[0].GetSliceIndex()
    ref_z = Z_plane_list[0].GetSliceIndex()
    for i in range(1,len(X_plane_list)):
        X_plane_list[i].SetSliceIndex(ref_x)
        X_plane_list[i].Modified()
        #X_plane_list[i].GetInteractor().GetRenderWindow().Render()
        Y_plane_list[i].SetSliceIndex(ref_y)
        Y_plane_list[i].Modified()
        #Y_plane_list[i].GetInteractor().GetRenderWindow().Render()
        Z_plane_list[i].SetSliceIndex(ref_z)
        Z_plane_list[i].Modified()
        #Z_plane_list[i].GetInteractor().GetRenderWindow().Render()

    dv3d_data_updateAllViews(tpw)
