#!/usr/bin/python
#dv3d_gui_updateCurrentInteractions.py
#Keeps the gui environmet in correct synch by disablieng / enabling features
#DV3D refactor 2
#AG 01/08/2013

from dv3d_data_UpdatePlanes import dv3d_data_UpdatePropertyPlaneInfo_fromList_single
from dv3d_data_UpdateSurfaces import dv3d_data_UpdatePropertySurfaceInfo_fromList_single, forceClipperOff


#TODO - this may all need a rethink
def dv3d_gui_updateCurrentInteractions(the_parent_window, currentMode):

    tpw = the_parent_window #for brevity

    #just can get my head round dictionaries today so hack this together
    theDialogsList = ['planes', 'surfaces',
                      'volumes', 'markers',
                      'surfacegroups', 'lights']


    theDialogsDict = {'planes':tpw.PlanePropertyPanel,
                      'surfaces':tpw.SurfacePropertyPanel,
                      'volumes':tpw.VolumePropertyPanel,
                      'markers':tpw.MarkerPropertyPanel,
                      'surfacegroups':tpw.SurfaceGroupPropertyPanel,
                      'lights':tpw.LightsPropertyPanel}


    for thisItem in theDialogsList:
        if thisItem == currentMode:
            #print 'try enabling', thisItem
            #print theDialogsDict[thisItem]
            try:
                theDialogsDict[thisItem].setEnabled(1) 

            except:
                pass #for now .. it doesn't exist
            
            if currentMode == 'planes':
                dv3d_data_UpdatePropertyPlaneInfo_fromList_single(tpw)       
            elif currentMode == 'surfaces':
                dv3d_data_UpdatePropertySurfaceInfo_fromList_single(tpw)
            else:
                pass       #for now

        else:
            #print 'try disabling', thisItem
            #print theDialogsDict[thisItem]
            try:
                theDialogsDict[thisItem].setEnabled(0)
                #print 'disabling', currentMode
            except:
                pass #for now .. it doesn't exist

    if len(tpw.Surfaces) > 0:
        #at least turn off any clippers that are on
        forceClipperOff(tpw)         
        
    #also if its the first thing we loaded, set up the camera correctly
    if tpw.anythingLoaded == 0:
        tpw.anythingLoaded = 1
        tpw.ren3d.ResetCamera()
        tpw.iwidget_3d.interactor.Render()
        tpw.ren1.ResetCamera()
        tpw.ren2.ResetCamera()
        tpw.ren3.ResetCamera()
        tpw.iwidget_2dX.interactor.Render()
        tpw.iwidget_2dY.interactor.Render()
        tpw.iwidget_2dZ.interactor.Render()




        


