#!/usr/bin/python
#dv3d_dialogs_surface_properties_panel.py
#dv3d_dialogs_surface_properties_panel launcher
#DV3D refactor 2
#AG 26/07/2013

#core libs
import vtk
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#gui setup 
import ui_surfacePropertyDialog

#functions
from dv3d_gui_ColorPicker import *
from dv3d_data_updateAllViews import *


#set up the property panel
class SurfacePropertyPanel(QDialog, ui_surfacePropertyDialog.Ui_SurfaceDataProperties):  

    def __init__(self, text, the_parent_window):
        super(SurfacePropertyPanel, self).__init__(the_parent_window)
        #super(SurfacePropertyPanel, self).__init__(None)
        self.__text = unicode(text)
        self.__index = 0
        self.setupUi(self)

        #debug print
        print 'surface frame generated'
        
        #hold for now so we can fix options
        #self.show()

        self.tpw = the_parent_window

        self.spinboxSurfaceOpacity.setKeyboardTracking(0) #stops update at each keypress

        #default color for surfaces is red so set that here
        palette = self.frameSurfaceColor.palette()
        palette.setColor(self.frameSurfaceColor.backgroundRole(), QColor(255,0,0))
        self.frameSurfaceColor.setPalette(palette)
        self.frameSurfaceColor.setAutoFillBackground(1);
        setattr(self.tpw.Surfaces[-1], 'currRGB', (1,0,0))
        setattr(self.tpw.Surfaces[-1], 'currQcolor', QColor(255,0,0))


        self.generateCallbacks()



    # --------------------
    def generateCallbacks(self):

        #pushButtons
        self.pushButtonClipperToggleOnOff.released.connect(self.cb_ClipperOn)
        self.pushButtonClipperToggleInsideOutside.released.connect(self.cb_ClipperInsideOut)
        self.pushButtonClipperReset.released.connect(self.cb_ClipperReset)
        self.pushButtonSurfaceToggleMode.released.connect(self.cb_ToggleSurfaceMode)
        self.pushButtonSurfaceColor.released.connect(self.cb_colorChange)

        # opacity spinBox     
        self.spinboxSurfaceOpacity.valueChanged.connect(self.cb_OpacityChanged)


    # --------------------
    def cb_colorChange(self):
        newCol = dv3d_gui_ColorPicker_QColor()
        if newCol != 'None':
            palette = self.frameSurfaceColor.palette()
            palette.setColor(self.frameSurfaceColor.backgroundRole(), newCol)
            self.frameSurfaceColor.setPalette(palette)
            self.frameSurfaceColor.setAutoFillBackground(1);
            self.update()
            self.repaint()

            #now apply the color to the actor
            rgb = newCol.getRgb()[:3]
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].GetProperty().SetColor(rgb[0]/255.0, rgb[1]/255.0, rgb[2]/255.0)
            dv3d_data_updateAllViews(self.tpw)
            
            #keep track of state
            setattr(self.tpw.Surfaces[self.getCurrentSurfaceIndex()], 'currRGB', (rgb[0]/255.0, rgb[1]/255.0, rgb[2]/255.0))
            setattr(self.tpw.Surfaces[self.getCurrentSurfaceIndex()], 'currQcolor', newCol)



    def cb_OpacityChanged(self):
        new_opacity = self.spinboxSurfaceOpacity.value()
        self.tpw.Surfaces[self.getCurrentSurfaceIndex()].GetProperty().SetOpacity(new_opacity)
        dv3d_data_updateAllViews(self.tpw)       
        
        #keep track of state
        setattr(self.tpw.Surfaces[self.getCurrentSurfaceIndex()], 'currOpacity', new_opacity)



    def cb_ToggleSurfaceMode(self):
        #switch between wireframe and solid modes
        if self.pushButtonSurfaceToggleMode.isChecked(): #i.e. should be wireframe
            thisMode = 'Wireframe'
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].GetProperty().SetRepresentationToWireframe()
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Modified()
            #update button label
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].currSurfaceMode = thisMode
            self.pushButtonSurfaceToggleMode.setText(thisMode)
        else:
            thisMode = 'Solid'
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].GetProperty().SetRepresentationToSurface()
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Modified()                
            #update button label
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].currSurfaceMode = thisMode
            self.pushButtonSurfaceToggleMode.setText(thisMode)
            
        dv3d_data_updateAllViews(self.tpw)
        setattr(self.tpw.Surfaces[self.getCurrentSurfaceIndex()], 'currSurfaceMode', thisMode)



    def cb_ClipperOn(self):
        if self.pushButtonClipperToggleOnOff.isChecked(): #i.e.clipper should be ON
            self.pushButtonClipperToggleOnOff.setText('On')
            self.pushButtonClipperToggleInsideOutside.setEnabled(1)
            self.pushButtonClipperReset.setEnabled(1)
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].ClipperBoxWidget.On()
        else:
            self.pushButtonClipperToggleOnOff.setText('Off')
            self.pushButtonClipperToggleInsideOutside.setEnabled(0)
            self.pushButtonClipperReset.setEnabled(0)
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].ClipperBoxWidget.Off()
        
        dv3d_data_updateAllViews(self.tpw)



    def cb_ClipperInsideOut(self):
        if self.pushButtonClipperToggleInsideOutside.isChecked():
            self.pushButtonClipperToggleInsideOutside.setText('Clip inside')
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Clipper.InsideOutOff()
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Clipper.UpdateWholeExtent()
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Modified()
            setattr(tpw.Surfaces[self.getCurrentSurfaceIndex()], 'clipperInsideOut', 'ClipInside')
        else:
            self.pushButtonClipperToggleInsideOutside.setText('Clip outside')
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Clipper.InsideOutOn()
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Clipper.UpdateWholeExtent()
            self.tpw.Surfaces[self.getCurrentSurfaceIndex()].Modified()
            setattr(tpw.Surfaces[self.getCurrentSurfaceIndex()], 'clipperInsideOut', 'ClipOutside')
        dv3d_data_updateAllViews(self.tpw)



    def cb_ClipperReset(self):
        clipPlanes = self.tpw.Surfaces[self.getCurrentSurfaceIndex()].clipPlanes
        boxWidget = self.tpw.Surfaces[self.getCurrentSurfaceIndex()].clipBoxWidget

        #do reset
        clipPlanes.SetNormals(self.tpw.Surfaces[self.getCurrentSurfaceIndex()].orig_clipPlaneNormals)
        clipPlanes.SetPoints(self.tpw.Surfaces[self.getCurrentSurfaceIndex()].orig_clipPlanePoints)
        clipPlanes.Modified()
        
        #force the boxWidget recalculate its original bounds
        boxWidget.SetInput(self.tpw.Surfaces[self.getCurrentSurfaceIndex()].orig_Surface.GetMapper().GetInput())
        boxWidget.PlaceWidget()    
        boxWidget.Modified()
        
        dv3d_data_updateAllViews(self.tpw)


    def getCurrentSurfaceIndex(self):
        self.currentSurfaceIndex = self.tpw.ItemList_QTreeWidget.currentItem().surfaceDataIndex
        return self.currentSurfaceIndex











 
      
