#!/usr/bin/python
#dv3d_data_UpdatePlanes.py
#Update plane views from callbacks
#DV3D refactor 2
#AG 26/07/2013

#import libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from dv3d_data_updateAllViews import *

# functions

# a single list item is selected to toggle its related planes
def dv3d_data_TogglePlanes_fromList_single(the_parent_window):

    tpw = the_parent_window #for brevity
    
    my_plane_index = tpw.ItemList_QTreeWidget.currentItem().planeDataIndex
    the_plane_set = tpw.Planes[my_plane_index]

    #check the state of the item
    if tpw.ItemList_QTreeWidget.currentItem().checkState(0) == 0:
        #turn all related data views off
        turnPlanesOff(the_plane_set, tpw)

    else:
        #turn all related data views on    
        turnPlanesOn(the_plane_set, tpw)

    dv3d_data_updateAllViews(tpw)



# the planes header has been selected so toggle all planes
def dv3d_data_TogglePlanes_fromList_all(the_parent_window):

    tpw = the_parent_window #for brevity
    theItem = tpw.ItemList_QTreeWidget.currentItem()

    #first get the children of the list
    n_childs = theItem.childCount()
    for i in range(n_childs):
        curr_child_item = theItem.child(i)
        my_plane_index = curr_child_item.planeDataIndex
        the_plane_set = tpw.Planes[my_plane_index]
        if theItem.checkState(0) == 0:  
            #turn all planes off
            curr_child_item.setCheckState(0, Qt.CheckState(0))
            turnPlanesOff(the_plane_set, tpw)
        else:
            curr_child_item.setCheckState(0, Qt.CheckState(2))
            turnPlanesOn(the_plane_set, tpw)

    dv3d_data_updateAllViews(tpw)


def turnPlanesOff(the_plane_set, tpw):
    the_plane_set.planeWidget_3dX.SetTextureVisibility(0)
    the_plane_set.planeWidget_3dY.SetTextureVisibility(0)
    the_plane_set.planeWidget_3dZ.SetTextureVisibility(0)
    the_plane_set.planeWidget_2dX.SetTextureVisibility(0)
    the_plane_set.planeWidget_2dY.SetTextureVisibility(0)
    the_plane_set.planeWidget_2dZ.SetTextureVisibility(0) 
    dv3d_data_updateAllViews(tpw)


def turnPlanesOn(the_plane_set, tpw):
    the_plane_set.planeWidget_3dX.SetTextureVisibility(1)
    the_plane_set.planeWidget_3dY.SetTextureVisibility(1)
    the_plane_set.planeWidget_3dZ.SetTextureVisibility(1)
    the_plane_set.planeWidget_2dX.SetTextureVisibility(1)
    the_plane_set.planeWidget_2dY.SetTextureVisibility(1)
    the_plane_set.planeWidget_2dZ.SetTextureVisibility(1)  
    #slight quirk here .. just in case the planes header is off it needs to be turned on
    tpw.ItemList_QTreeWidget.topLevelItem(0).setCheckState(0, Qt.CheckState(2))
    dv3d_data_updateAllViews(tpw)


## info updates in panel when items selected in list

def dv3d_data_UpdatePropertyPlaneInfo_fromList_single(tpw):

    tpw.currentlyLoading = 1
    theItem = tpw.ItemList_QTreeWidget.currentItem()

    my_plane_index = tpw.ItemList_QTreeWidget.currentItem().planeDataIndex
    the_plane_set = tpw.Planes[my_plane_index]

    tpw.PlanePropertyPanel.spinboxDataVisibleMax.setMaximum(the_plane_set.dMax)
    tpw.PlanePropertyPanel.spinboxDataVisibleMax.setMinimum(the_plane_set.dMin)
    tpw.PlanePropertyPanel.update()
    tpw.PlanePropertyPanel.repaint()    

    tpw.PlanePropertyPanel.spinboxDataVisibleMax.setValue(the_plane_set.currVisibleMax)
    tpw.PlanePropertyPanel.spinboxDataVisibleMin.setMaximum(the_plane_set.dMax)
    tpw.PlanePropertyPanel.spinboxDataVisibleMin.setMinimum(the_plane_set.dMin)
    tpw.PlanePropertyPanel.update()
    tpw.PlanePropertyPanel.repaint()   

    tpw.PlanePropertyPanel.spinboxDataVisibleMin.setValue(the_plane_set.currVisibleMin)
    tpw.PlanePropertyPanel.spinboxDataOpacity.setValue(the_plane_set.currOpacity)
    
    tpw.PlanePropertyPanel.lineEditDataSource.setText(the_plane_set.dataPath)
    tpw.PlanePropertyPanel.labelDataMaxValue.setText('%.3f' %(float(the_plane_set.dMax)))
    tpw.PlanePropertyPanel.labelDataMinValue.setText('%.3f' %(float(the_plane_set.dMin)))
    tpw.PlanePropertyPanel.update()
    tpw.PlanePropertyPanel.repaint()    


    #first set the colors or the property frame button indicators
    cMax = the_plane_set.currMaxRGB
    cMin = the_plane_set.currMinRGB

    #clip boxes too
    #lazy
    if the_plane_set.enforceLowClip == 1:
        tpw.PlanePropertyPanel.checkBoxClipBelow.setChecked(2)
        tpw.PlanePropertyPanel.update()
        tpw.PlanePropertyPanel.repaint() 
    else:
        tpw.PlanePropertyPanel.checkBoxClipBelow.setChecked(0)
        tpw.PlanePropertyPanel.update()
        tpw.PlanePropertyPanel.repaint() 
    if the_plane_set.enforceHighClip == 1:
        tpw.PlanePropertyPanel.checkBoxClipAbove.setChecked(2)
        tpw.PlanePropertyPanel.update()
        tpw.PlanePropertyPanel.repaint() 
    else:
        tpw.PlanePropertyPanel.checkBoxClipAbove.setChecked(0)
        tpw.PlanePropertyPanel.update()
        tpw.PlanePropertyPanel.repaint() 


    palette = tpw.PlanePropertyPanel.framePlaneColorMax.palette()
    palette.setColor(tpw.PlanePropertyPanel.framePlaneColorMax.backgroundRole(), QColor(cMax[0],cMax[1],cMax[2]))
    tpw.PlanePropertyPanel.framePlaneColorMax.setPalette(palette)
    tpw.PlanePropertyPanel.framePlaneColorMax.setAutoFillBackground(1);

    palette = tpw.PlanePropertyPanel.framePlaneColorMin.palette()
    palette.setColor(tpw.PlanePropertyPanel.framePlaneColorMin.backgroundRole(), QColor(cMin[0],cMin[1],cMin[2]))
    tpw.PlanePropertyPanel.framePlaneColorMin.setPalette(palette)
    tpw.PlanePropertyPanel.framePlaneColorMin.setAutoFillBackground(1);
    tpw.PlanePropertyPanel.update()
    tpw.PlanePropertyPanel.repaint()  

    tpw.currentlyLoading = 0




def dv3d_data_TogglePlane_Edges(tpw):
    #shows or hides the colored edges of the planes 

    #first check on / off required
    on_or_off_bool = tpw.pushButtonTogglePlaneEdges.isChecked()

    if on_or_off_bool: # ==1
        tpw.pushButtonTogglePlaneEdges.setText('Plane edges hidden')
    else: # !=1
        tpw.pushButtonTogglePlaneEdges.setText('Plane edges visible')                

    #need to invert the boolean login of the button check state
    visibleState = float(not(on_or_off_bool))

    #update the toggle buttons
    tpw.pushButtonTogglePlaneEdges.update()        
    tpw.pushButtonTogglePlaneEdges.repaint()

    #apply the settingto the planes
    for the_plane_set in tpw.Planes:
        the_plane_set.planeWidget_3dX.GetPlaneProperty().SetOpacity(visibleState)
        the_plane_set.planeWidget_3dY.GetPlaneProperty().SetOpacity(visibleState)
        the_plane_set.planeWidget_3dZ.GetPlaneProperty().SetOpacity(visibleState)
        the_plane_set.planeWidget_2dX.GetPlaneProperty().SetOpacity(visibleState)
        the_plane_set.planeWidget_2dY.GetPlaneProperty().SetOpacity(visibleState)
        the_plane_set.planeWidget_2dZ.GetPlaneProperty().SetOpacity(visibleState)  

    dv3d_data_updateAllViews(tpw)




