#!/usr/bin/python
#dv3d_data_LoadVtkSurface.py
#Loading function for .vtk files
#DV3D refactor 2
#AG 25/07/2013


import vtk

def dv3d_data_LoadVtkSurface(the_parent_window, the_VTK_file):

    tpw = the_parent_window #for brevity

    #load the file
    theLoader = vtk.vtkPolyDataReader()
    theLoader.SetFileName(the_VTK_file)    

    #convert to a vtk polydata object
    thePolyData = theLoader.GetOutput()
    thePolyData.Update()

    #decimate if required    
    #d = vtk.vtkDecimatePro()
    #d.SetInput(PolyData)
    #d.SetTargetReduction(0.5)
    #d.PreserveTopologyOff()
    #d.PreserveTopologyOff()
    #d.SplittingOff()
    #d.Update()

    #smooth if required    
    smth = vtk.vtkSmoothPolyDataFilter()
    smth.SetNumberOfIterations(0)
    smth.SetInput(thePolyData)
    smth.Update()

    #create a mapper for the data  
    theMapper = vtk.vtkPolyDataMapper()
    theMapper.ImmediateModeRenderingOn()
    theMapper.SetInput(smth.GetOutput())
    theMapper.ScalarVisibilityOff()   
    theMapper.Update()

    #create an actor for the mapper    
    theActor = vtk.vtkActor()
    theActor.SetMapper(theMapper)
    #set a colour  
    theActor.GetProperty().SetColor(1.0,0.0,0.0)

    #add the actor to the main window NB ONLY THE 3D window (for now)
    tpw.ren3d.AddActor(theActor)
    
    #Add a reference to this surface to the parent window's surface list
    tpw.Surfaces.append(theActor)

    #and draw!
    tpw.iwidget_3d.interactor.GetRenderWindow().Render()



