#!/usr/bin/python
#dv3d_data_Create_Planes.py
#physcially create the plane widgets and pickers to display
# volumetric adta in planes
#DV3D refactor 2
#AG 26/07/2013

#core libs
import vtk
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *


def dv3d_data_Create_Planes(the_parent_window, vol, x_slice_pos, y_slice_pos, z_slice_pos):

    tpw = the_parent_window #for brevity

    # The shared picker enables us to use 3 planes at one time
    # and gets the picking order right
    tpw.Planes[-1].picker_3d = vtk.vtkCellPicker()
    tpw.Planes[-1].picker_3d.SetTolerance(0.005)
    
    # individual pickers for each 2d plane
    tpw.Planes[-1].picker_2dX = vtk.vtkCellPicker()
    tpw.Planes[-1].picker_2dX.SetTolerance(0.005)

    tpw.Planes[-1].picker_2dY = vtk.vtkCellPicker()
    tpw.Planes[-1].picker_2dY.SetTolerance(0.005)

    tpw.Planes[-1].picker_2dZ = vtk.vtkCellPicker()
    tpw.Planes[-1].picker_2dZ.SetTolerance(0.005)

    #plane widgets used to probe the dataset
    
    # first three planes in the same view
    tpw.Planes[-1].planeWidget_3dX = vtk.vtkImagePlaneWidget()
    tpw.Planes[-1].planeWidget_3dX.DisplayTextOn()
    tpw.Planes[-1].planeWidget_3dX.SetInput(vol.GetOutput())
    tpw.Planes[-1].planeWidget_3dX.SetPlaneOrientationToXAxes()
    tpw.Planes[-1].planeWidget_3dX.SetSliceIndex(x_slice_pos)
    tpw.Planes[-1].planeWidget_3dX.SetPicker(tpw.Planes[-1].picker_3d)
    prop1 = tpw.Planes[-1].planeWidget_3dX.GetPlaneProperty()
    prop1.SetColor(1, 0, 0)
    tpw.Planes[-1].planeWidget_3dX.SetInteractor(tpw.iwidget_3d.interactor)
    tpw.Planes[-1].planeWidget_3dX.GetTexturePlaneProperty().SetLighting(0)


    tpw.Planes[-1].planeWidget_3dY = vtk.vtkImagePlaneWidget()
    tpw.Planes[-1].planeWidget_3dY.DisplayTextOn()
    tpw.Planes[-1].planeWidget_3dY.SetInput(vol.GetOutput())
    tpw.Planes[-1].planeWidget_3dY.SetPlaneOrientationToYAxes()
    tpw.Planes[-1].planeWidget_3dY.SetSliceIndex(y_slice_pos)
    tpw.Planes[-1].planeWidget_3dY.SetPicker(tpw.Planes[-1].picker_3d)
    prop1 = tpw.Planes[-1].planeWidget_3dY.GetPlaneProperty()
    prop1.SetColor(1, 1, 0)
    tpw.Planes[-1].planeWidget_3dY.SetInteractor(tpw.iwidget_3d.interactor)
    tpw.Planes[-1].planeWidget_3dY.SetLookupTable(tpw.Planes[-1].planeWidget_3dX.GetLookupTable())
    tpw.Planes[-1].planeWidget_3dY.GetTexturePlaneProperty().SetLighting(0)

  
    tpw.Planes[-1].planeWidget_3dZ = vtk.vtkImagePlaneWidget()
    tpw.Planes[-1].planeWidget_3dZ.DisplayTextOn()
    tpw.Planes[-1].planeWidget_3dZ.SetInput(vol.GetOutput())
    tpw.Planes[-1].planeWidget_3dZ.SetPlaneOrientationToZAxes()
    tpw.Planes[-1].planeWidget_3dZ.SetSliceIndex(z_slice_pos)
    tpw.Planes[-1].planeWidget_3dZ.SetPicker(tpw.Planes[-1].picker_3d)
    prop1 = tpw.Planes[-1].planeWidget_3dZ.GetPlaneProperty()
    prop1.SetColor(0, 0, 1)
    tpw.Planes[-1].planeWidget_3dZ.SetInteractor(tpw.iwidget_3d.interactor)
    tpw.Planes[-1].planeWidget_3dZ.SetLookupTable(tpw.Planes[-1].planeWidget_3dX.GetLookupTable())
    tpw.Planes[-1].planeWidget_3dZ.GetTexturePlaneProperty().SetLighting(0)


    ## now the 2d (ortho) planes

    #TODO - disable 2d plane interactions
    tpw.Planes[-1].planeWidget_2dX = vtk.vtkImagePlaneWidget()
    tpw.Planes[-1].planeWidget_2dX.DisplayTextOn()
    tpw.Planes[-1].planeWidget_2dX.SetInput(vol.GetOutput())
    tpw.Planes[-1].planeWidget_2dX.SetPlaneOrientationToXAxes()
    tpw.Planes[-1].planeWidget_2dX.SetSliceIndex(x_slice_pos)
    tpw.Planes[-1].planeWidget_2dX.SetPicker(tpw.Planes[-1].picker_2dX)
    prop1 = tpw.Planes[-1].planeWidget_2dX.GetPlaneProperty()
    prop1.SetColor(0, 0, 0)
    tpw.Planes[-1].planeWidget_2dX.SetInteractor(tpw.iwidget_2dX.interactor)
    tpw.Planes[-1].planeWidget_2dX.SetLookupTable(tpw.Planes[-1].planeWidget_3dX.GetLookupTable())
    tpw.Planes[-1].planeWidget_2dX.GetTexturePlaneProperty().SetLighting(0)


    tpw.Planes[-1].planeWidget_2dY = vtk.vtkImagePlaneWidget()
    tpw.Planes[-1].planeWidget_2dY.DisplayTextOn()
    tpw.Planes[-1].planeWidget_2dY.SetInput(vol.GetOutput())
    tpw.Planes[-1].planeWidget_2dY.SetPlaneOrientationToYAxes()
    tpw.Planes[-1].planeWidget_2dY.SetSliceIndex(y_slice_pos)
    tpw.Planes[-1].planeWidget_2dY.SetPicker(tpw.Planes[-1].picker_2dY)
    prop1 = tpw.Planes[-1].planeWidget_2dY.GetPlaneProperty()
    prop1.SetColor(0, 0, 0)
    tpw.Planes[-1].planeWidget_2dY.SetInteractor(tpw.iwidget_2dY.interactor)
    tpw.Planes[-1].planeWidget_2dY.SetLookupTable(tpw.Planes[-1].planeWidget_3dX.GetLookupTable())      
    tpw.Planes[-1].planeWidget_2dY.GetTexturePlaneProperty().SetLighting(0)


    tpw.Planes[-1].planeWidget_2dZ = vtk.vtkImagePlaneWidget()
    tpw.Planes[-1].planeWidget_2dZ.DisplayTextOn()
    tpw.Planes[-1].planeWidget_2dZ.SetInput(vol.GetOutput())
    tpw.Planes[-1].planeWidget_2dZ.SetPlaneOrientationToZAxes()
    tpw.Planes[-1].planeWidget_2dZ.SetSliceIndex(z_slice_pos)
    tpw.Planes[-1].planeWidget_2dZ.SetPicker(tpw.Planes[-1].picker_2dZ)
    prop1 = tpw.Planes[-1].planeWidget_2dZ.GetPlaneProperty()
    prop1.SetColor(0, 0, 0)
    tpw.Planes[-1].planeWidget_2dZ.SetInteractor(tpw.iwidget_2dZ.interactor)
    tpw.Planes[-1].planeWidget_2dZ.SetLookupTable(tpw.Planes[-1].planeWidget_3dX.GetLookupTable())        
    tpw.Planes[-1].planeWidget_2dZ.GetTexturePlaneProperty().SetLighting(0)


    # observers / actions
    tpw.Planes[-1].planeWidget_3dX.AddObserver("InteractionEvent", tpw.runSyncPlanes)
    tpw.Planes[-1].planeWidget_3dY.AddObserver("InteractionEvent", tpw.runSyncPlanes)
    tpw.Planes[-1].planeWidget_3dZ.AddObserver("InteractionEvent", tpw.runSyncPlanes)

    #some extra custom restrictions we apply to all planes in DV3D

    thePlanes = [tpw.Planes[-1].planeWidget_3dX, tpw.Planes[-1].planeWidget_3dY, tpw.Planes[-1].planeWidget_3dZ ,
                tpw.Planes[-1].planeWidget_2dX, tpw.Planes[-1].planeWidget_2dY, tpw.Planes[-1].planeWidget_2dZ]

    #all planes
    for i in range(len(thePlanes)):
        # all
        #we restrict the plane's geometry to the data volume
        #thePlanes[i].RestrictPlaneToVolumeOn()
        # we use custom lookup tables 
        thePlanes[i].UserControlledLookupTableOn()

        # just 3d
        if i<3:
            #we change button interaction
            thePlanes[i].SetMiddleButtonAction(2)
            thePlanes[i].SetRightButtonAction(1)
            thePlanes[i].SetLeftButtonAction(0)


