#!/usr/bin/python
#dv3d_data_ChangeViews.py
#Functions that change the viewing experience of the 3d window
#DV3D refactor 2
#AG 25/07/2013

import vtk


global ViewSettings #may be called by multiple functions below so define once here

#dictionary of settings
ViewSettings = {'Top':[(0,0,600), (0,1,0)], 
                'Bottom':[(0,0,-600), (0,1,0)],
                'Left':[(-600,0,0), (0,0,1)], 
                'Right':[(600,0,0), (0,0,1)],
                'Front':[(0,-600,0), (0,0,1)], 
                'Back':[(0,600,0), (0,0,1)]}



def Change3DCameraView(the_parent_window):
    #chnages the direction the camera 'looks'
    global ViewSettings

    tpw = the_parent_window #for brevity

    #get the required view from the combo box
    required_view = str(tpw.comboBoxViewFrom.currentText())
    required_settings = ViewSettings[required_view]
    rs = required_settings #for brevity

    #send settings to the camera
    cur_cam = tpw.ren3d.GetActiveCamera()
    bounds =  tpw.Planes[0].bounds
    cur_cam.SetPosition((bounds[0]+bounds[1])/2+rs[0][0],(bounds[2]+bounds[3])/2+rs[0][1],(bounds[4]+bounds[5])/2+rs[0][2])
    cur_cam.SetViewUp(rs[1][0],rs[1][1],rs[1][2])
    cur_cam.SetViewAngle(30)
    cur_cam.Modified()
    tpw.ren3d.Render()
    tpw.iwidget_3d.interactor.GetRenderWindow().Render()


def ChangePerspectiveRendering(the_parent_window):
    #changes the way the camera handles depth information
    # i.e. with or withou perspective
    
    tpw = the_parent_window #for brevity

    #get the relevant camera
    cur_cam = tpw.ren3d.GetActiveCamera()

    #get the required view from the combo box
    required_projection = str(tpw.comboBoxViewType.currentText())

    if required_projection == 'Parallel':
        cur_cam.ParallelProjectionOn()
    elif required_projection == 'Perspective':
        cur_cam.ParallelProjectionOff()    
    else:
        pass #for now

    cur_cam.Modified()
    tpw.ren3d.Render()
    tpw.iwidget_3d.interactor.GetRenderWindow().Render()

