#!/usr/bin/python
#dv3d_data_AddLights.py
#Adds lights to the main 3d window
#DV3D refactor 2
#AG 25/07/2013

import vtk


def dv3d_data_AddLights(the_parent_window):

    tpw = the_parent_window #for brevity

    #a dictionary holding the lighting settings
    # indices are 'lightname':[light_position=(x,y,z), focal_point=(x, y, z), color=(r,g,b), intensity]
    # TODO- wishlist .. may want to change light types too
    # TODO- wishlist .. give users access to these features to allow interaction 

    light_settings = [[(0,0,5000),(0,0,0),(1,1,1),0.25],
                           [(0,0,-5000),(0,0,0),(1,1,1),0.5],
                           [(0,5000,0),(0,0,0),(1,1,1),0.5],
                           [(0,-5000,0),(0,0,0),(1,1,1),0.5],
                           [(5000,0,0),(0,0,0),(1,1,1),0.5],
                           [(-5000,0,0),(0,0,0),(1,1,1),0.5],
                           [(5000,5000,5000),(0,0,0),(1,1,1),0.5],
                           [(5000,-5000,5000),(0,0,0),(1,1,1),0.5],
                           [(5000,-5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(5000,5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,5000,5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,-5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,-5000,-5000),(0,0,0),(1,1,1),0.5]]


    for thisLight in light_settings:

        light = vtk.vtkLight()
        light.SetPosition(thisLight[0][0], thisLight[0][1], thisLight[0][2])
        light.SetFocalPoint(thisLight[1][0], thisLight[1][1], thisLight[1][2])
        light.SetColor(thisLight[2][0], thisLight[2][1], thisLight[2][2])
        light.SetIntensity(thisLight[3])

        light.SetLightTypeToCameraLight()
        
        tpw.Lights.append(light)       
        tpw.ren3d.AddLight(light)       
        tpw.ren1.AddLight(light)           
        tpw.ren2.AddLight(light)
        tpw.ren3.AddLight(light)


#example code for now - fix references self, etc
def AddLightToActor(tpw, the_actor):       
    # Associate the line widget with the interactor
    
    tpw.sphereWidget = vtk.vtkSphereWidget()
    tpw.sphereWidget.SetInteractor(tpw.widget)
    tpw.sphereWidget.SetProp3D(the_actor)
    tpw.sphereWidget.SetPlaceFactor(4)
    tpw.sphereWidget.PlaceWidget()
    tpw.sphereWidget.TranslationOff()
    tpw.sphereWidget.ScaleOff()
    tpw.sphereWidget.HandleVisibilityOn()
    
    # Uncomment the next line if you want to see the widget active when
    # the script starts
    #sphereWidget.EnabledOn()

    light = vtk.vtkLight()
    light.SetFocalPoint(the_actor.GetCenter())
    tpw.ren.AddLight(light)
    
    # Actually probe the data
    def MoveLight(obj, event):
        light.SetPosition(obj.GetHandlePosition())
     
    tpw.sphereWidget.AddObserver("InteractionEvent", MoveLight)
    
    # Add the actors to the renderer, set the background and size
    #self.ren.SetBackground(1, 1, 1)
    
    cam1 = tpw.ren.GetActiveCamera()
    cam1.SetViewUp(0, 0, 1)
    cam1.SetFocalPoint(the_actor.GetCenter())
    cam1.SetPosition(1, 0, 0)
    tpw.ren.ResetCamera()
    cam1.Elevation(25)
    cam1.Azimuth(125)
    cam1.Zoom(1.25)
    tpw.sphereWidget.On()
    

            
    
    
    
    
