# PyQt4 imports
from PyQt4 import QtGui, QtCore

# vtk imports
from vtk.qt4.QVTKRenderWindowInteractor import QVTKRenderWindowInteractor

class QVtkInteractorWidget(QtGui.QFrame):

   def __init__(self, parent = None):
       super(QVtkInteractorWidget, self).__init__(parent)
       self.setup_ui()

   def setup_ui(self):
       self.setAttribute(QtCore.Qt.WA_ForceUpdatesDisabled)
       self.setAttribute(QtCore.Qt.WA_PaintOnScreen)
       self.setFocusPolicy(QtCore.Qt.StrongFocus)

       self.vbox = QtGui.QVBoxLayout(self)
       self.vbox.setMargin(0)
       self.interactor = QVTKRenderWindowInteractor(self)
       self.vbox.addWidget(self.interactor)
       self.setLayout(self.vbox)


if __name__ == '__main__':
	import sys, vtk

	app = QtGui.QApplication(sys.argv)

	mw = QtGui.QMainWindow()
	iwidget = QVtkInteractorWidget(mw)
	mw.setCentralWidget(iwidget)
	mw.show()

	ren = vtk.vtkRenderer()
	iwidget.interactor.GetRenderWindow().AddRenderer(ren)
	
	cube = vtk.vtkCubeSource()
	cube.SetXLength(200)
	cube.SetYLength(200)
	cube.SetZLength(200)
	cube.Update()
	cm = vtk.vtkPolyDataMapper()
	cm.SetInputConnection(cube.GetOutputPort())
	ca = vtk.vtkActor()
	ca.SetMapper(cm)
	ren.AddActor(ca)

	app.exec_()
