import wx

from common_functions import *

class CreateObjectTree(wx.Panel):
    def __init__(self, parent, frame_parent):

        self.frame_parent = frame_parent
        
        self.frame_parent.notebook_Trees = wx.Notebook(id=-1, name='notebook_Trees',
              parent=self.frame_parent.panel_left_lower, pos=wx.Point(0, 0), size=wx.Size(50, 500), style=0)

        self.frame_parent.treepanel = wx.Panel(id=-1, name='panelRun',
              parent=self.frame_parent.notebook_Trees, pos=wx.Point(0, 0), size=wx.Size(1, 479),
              style=wx.TAB_TRAVERSAL)
        self.frame_parent.treepanel.SetBackgroundColour(wx.Colour(255, 255, 0))
        self.frame_parent.notebook_Trees.AddPage(self.frame_parent.treepanel, "", True)

        self.frame_parent.sizer_panel_ll = wx.GridSizer(rows = 1, cols = 1)
        self.frame_parent.sizer_panel_ll.Add(self.frame_parent.notebook_Trees, 0, wx.EXPAND)

        self.frame_parent.panel_left_lower.SetSizer(self.frame_parent.sizer_panel_ll)


        self.frame_parent.tree = wx.TreeCtrl(self.frame_parent.treepanel,
                                size=wx.Size(150,750), style =  wx.NO_BORDER|\
                                                                wx.TR_EDIT_LABELS|\
                                                                wx.TR_HAS_BUTTONS)
        
        self.frame_parent.tree_root = self.frame_parent.tree.AddRoot("Loaded object list")
        self.frame_parent.tree_headers = ["Structural objects","Functional datasets"]
        self.frame_parent.struct_objects = ['Plane widget']
        self.frame_parent.struct_sub_objects = [[0,'plane - axial',    \
                            'plane - sagittal', \
                            'plane - coronal']]
        self.frame_parent.func_objects = []
        self.frame_parent.func_sub_objects = []
        
        #create a list of images to use as icons in the list
        isz = (16,16)
        il = wx.ImageList(isz[0],isz[1])
        #self.im_item_on = il.Add(wx.ArtProvider_GetBitmap(wx.ART_TICK_MARK, wx.ART_OTHER, isz))
        #self.im_item_off = il.Add(wx.ArtProvider_GetBitmap(wx.ART_CROSS_MARK, wx.ART_OTHER, isz))
        self.frame_parent.im_item_on = il.Add(wx.Image('./images/bn.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        self.frame_parent.im_item_off = il.Add(wx.Image('./images/bn_off.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        self.frame_parent.tree.SetImageList(il)
        self.frame_parent.il = il
        
        #
        def AddTreeNodes(parentItem):
            for i in range(2):
                item = self.frame_parent.tree_headers[i]
                if i == 0:
                    self.tree_structural_list = self.frame_parent.tree.AppendItem(parentItem, item,0,1)
                    for k in range(len(self.frame_parent.struct_objects)):
                        self.tree_structural_subitem = self.frame_parent.tree.AppendItem(self.tree_structural_list, self.frame_parent.struct_objects[k])
                        for j in range(len(self.frame_parent.struct_sub_objects)):
                            if self.frame_parent.struct_sub_objects[j][0] == k:
                                for t in range(1,len(self.frame_parent.struct_sub_objects[j])):
                                    self.frame_parent.tree.AppendItem(self.tree_structural_subitem, self.frame_parent.struct_sub_objects[j][t])
                else:
                    curr_item = self.frame_parent.tree.AppendItem(parentItem, item)
                    if self.frame_parent.func_objects == []:
                        self.frame_parent.func_objects = ['no data loaded']
                    for func in self.frame_parent.func_objects:
                        self.frame_parent.tree.AppendItem(curr_item, func)   
        
        self.frame_parent.un_editable_labels = ['plane - sagittal',\
                              'plane - axial',\
                              'plane - coronal',\
                              'Loaded object list',\
                              'Structural objects',\
                              'Functional datasets',\
                              'Plane widget'\
                              ]

        def OnDoubleClick(evt):
            #when an item is double clicked ('activated') default behaviour is
            # for it to expand / collapse. We want to capture the 'activated'
            # event but need to reverse the default behaviour - hence we toggle
            # the state (reversing what was done) and then do waht we want - a
            # bit of a hack but gets around the fact that evt.Veto doesn't seem
            # to work here?
            
            item = evt.GetItem()
            if item != self.frame_parent.tree.GetRootItem():
                self.frame_parent.tree.Toggle(item)
                
            #now do what we want ...
            if GetItem(evt.GetItem())[0] == 'plane - sagittal':
                toggle_base_plane_from_tree(self.frame_parent.planes_page.planes_sagittal, evt.GetItem(), self.frame_parent, 0)
            elif GetItem(evt.GetItem())[0] == 'plane - coronal':
                toggle_base_plane_from_tree(self.frame_parent.planes_page.planes_coronal, evt.GetItem(), self.frame_parent, 1)
            elif GetItem(evt.GetItem())[0] == 'plane - axial':
                toggle_base_plane_from_tree(self.frame_parent.planes_page.planes_axial, evt.GetItem(), self.frame_parent, 2)
        
        
        #we dont want users renaming some of the core objects .. so we lock them down
        def OnLabelEdit(evt):
            item = evt.GetItem()
            if self.frame_parent.tree.GetItemText(item) in self.frame_parent.un_editable_labels:
                print 'cant edit this object label'
                self.frame_parent.tree.EndEditLabel(item)
        
        
        def GetItem(item):
            if item:
                return self.frame_parent.tree.GetItemText(item), item
            else:
                return ""
        
        
        #now build the tree
        AddTreeNodes(self.frame_parent.tree_root)
        self.frame_parent.tree.Bind(wx.EVT_TREE_ITEM_ACTIVATED, OnDoubleClick, self.frame_parent.tree)
        self.frame_parent.tree.Bind(wx.EVT_TREE_BEGIN_LABEL_EDIT, OnLabelEdit, self.frame_parent.tree)       
        self.frame_parent.tree.Expand(self.frame_parent.tree_root)


class EditObjectTree(wx.TreeCtrl):
    def __init__(self, frame_parent):
        
        self.frame_parent= frame_parent
        self.frame_parent.tree.Toggle(self.frame_parent.tree_root)
